\name{getReplisting}
\alias{getReplisting}
\title{A function to retrieve a repository replisting file}
\description{
  Given a repository URL, will retrieve that repository's replisting
  information. 
}
\usage{
getReplisting(repURL, repFile = "replisting", method="auto")
}
\arguments{
  \item{repURL}{URL of the repository to access}
  \item{repFile}{Name of the replisting file}
  \item{method}{Method used for file downloads.  See \code{download.file}}
}
\details{
  The 'repFile' argument should almost always be left to its default.

  This function will contact the specified repository, and attempt to
  retrive its replisting file.  This downloaded data is then formed into
  an object of class replisting and returned to the user.
}
\value{
  The appropriate replisting object, or NULL upon failure.
}
\author{Jeff Gentry}
\seealso{\code{\link{replisting-class}}}
\examples{
  z <- getReplisting("http://www.bioconductor.org/repository/sample/package")
  z
}
\keyword{utilities}
