/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


#ifndef _hexonet_Framebuffer_h_
#define _hexonet_Framebuffer_h_


#include "rfb.h"

namespace rfb {

class FramebufferPixel;

class Framebuffer
{
  public:

    virtual void update( unsigned int _x,
                         unsigned int _y,
               		 unsigned int _w,
		         unsigned int _h
	               );

    virtual void copyRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           unsigned int _srcX,
                           unsigned int _srcY
                         );
                         
    virtual void fillRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           CARD32 &pixelValue
                         );

                         
    void getPixel( unsigned int x,
                   unsigned int y,
                   unsigned int &r,
                   unsigned int &g,
                   unsigned int &b,
                   unsigned int m = 255 );
                         
    void putPixel( unsigned int x,
                   unsigned int y,
                   unsigned int r,
                   unsigned int g,
                   unsigned int b,
                   unsigned int m = 255 );

    PixelFormat pixelFormat;
    unsigned int width;
    unsigned int height;
    unsigned int bytesPerLine;
    unsigned char *data;
};


class FramebufferPixel
{
    public:
        FramebufferPixel( Framebuffer *_fb, int _x, int _y)
          : fb(_fb)
          , x(_x)
          , y(_y)
        {
            cs = (fb->pixelFormat.bits_per_pixel + 7) >> 3;
            rs = fb->bytesPerLine;
            p = fb->data + y * rs + x * cs;
            be = fb->pixelFormat.big_endian_flag;
        }
        
        void setColor( unsigned int r,
                       unsigned int g,
                       unsigned int b,
                       unsigned int m = 255 );

        void getColor( unsigned int &r,
                       unsigned int &g,
                       unsigned int &b,
                       unsigned int m = 255 );
       
        void moveUp() { p -= rs; y--; }
        void moveDown() { p += rs; y++; }
        void moveLeft() { p -= cs; x--; }
        void moveRight() { p += cs; x++; }
        void moveTo( int _x, int _y ) { 
            x = _x;
            y = _y;
            p = fb->data + y * rs + x * cs;
        }
        
        Framebuffer *fb;
        int x, y;
        int be;
        unsigned char *p;
        unsigned int cs;
        unsigned int rs;
};

int saveFramebufferAsPPM( int file, Framebuffer *fb,
                          int x0 = 0,
                          int y0 = 0,
                          int width = -1,
                          int height = -1 );

}

#endif // _hexonet_Framebuffer_h_
