/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef _hexonet_ScaleFramebuffer_h_
#define _hexonet_ScaleFramebuffer_h_


#include "Framebuffer.h"

namespace rfb {

class ScaleFramebuffer: public Framebuffer
{
  public:
    ScaleFramebuffer( Framebuffer & _fb, int _width, int _height );
    
    virtual void update( unsigned int _x,
                         unsigned int _y,
               		 unsigned int _w,
		         unsigned int _h );

    virtual void copyRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           unsigned int _srcX,
                           unsigned int _srcY );
    
    Framebuffer *fb;
};


class SmoothScaleFramebuffer: public ScaleFramebuffer
{
  public:
    SmoothScaleFramebuffer( Framebuffer & _fb, int _width, int _height )
        : ScaleFramebuffer(_fb,_width,_height) {}
    
    virtual void update( unsigned int _x,
                         unsigned int _y,
               		 unsigned int _w,
		         unsigned int _h );

    virtual void copyRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           unsigned int _srcX,
                           unsigned int _srcY );
};



}

#endif // _hexonet_ScaleFramebuffer_h_
