/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */


namespace rfb {

void computeSubrectDimensions8( unsigned char *src,
                                unsigned int &width,
                                unsigned int &height,
                                unsigned int bytesPerLine )
{
  unsigned int x = 1;
  unsigned int y = 1;
  unsigned char val = src[0];
  while ( ( x < width ) && ( src[x] == val ) ) x++;
  width = x;
  while ( y < height ) {
    src += bytesPerLine;
    for ( x = 0; x < width; x++ )
      if ( src[x] != val ) {
        height = y;
        return;
      }
    y++;
  }
}


void computeSubrectDimensions16( unsigned char *src,
                                 unsigned int &width,
                                 unsigned int &height,
                                 unsigned int bytesPerLine )
{
  unsigned int x = 1;
  unsigned int y = 1;
  unsigned char val0 = src[0];
  unsigned char val1 = src[1];
  while ( ( x < width ) && ( src[x*2] == val0 )
                        && ( src[x*2+1] == val1 ) ) x++;
  width = x;
  while ( y < height ) {
    src += bytesPerLine;
    for ( x = 0; x < width; x++ )
      if ( (src[x*2] != val0) || (src[x*2+1] != val1) ) {
        height = y;
        return;
      }
    y++;
  }
}


void computeSubrectDimensions24( unsigned char *src,
                                 unsigned int &width,
                                 unsigned int &height,
                                 unsigned int bytesPerLine )
{
  unsigned int x = 1;
  unsigned int y = 1;
  unsigned char val0 = src[0];
  unsigned char val1 = src[1];
  unsigned char val2 = src[2];
  while ( ( x < width ) && ( src[x*3] == val0 )
                        && ( src[x*3+1] == val1 )
                        && ( src[x*3+2] == val2 ) ) x++;
  width = x;
  while ( y < height ) {
    src += bytesPerLine;
    for ( x = 0; x < width; x++ )
      if (    (src[x*4] != val0)
           || (src[x*4+1] != val1)
           || (src[x*4+2] != val2)
         ) {
        height = y;
        return;
      }
    y++;
  }
}

void computeSubrectDimensions32( unsigned char *src,
                                 unsigned int &width,
                                 unsigned int &height,
                                 unsigned int bytesPerLine )
{
  unsigned int x = 1;
  unsigned int y = 1;
  unsigned char val0 = src[0];
  unsigned char val1 = src[1];
  unsigned char val2 = src[2];
  unsigned char val3 = src[3];
  while ( ( x < width ) && ( src[x*4] == val0 )
                        && ( src[x*4+1] == val1 )
                        && ( src[x*4+2] == val2 )
                        && ( src[x*4+3] == val3 ) ) x++;
  width = x;
  while ( y < height ) {
    src += bytesPerLine;
    for ( x = 0; x < width; x++ )
      if (    (src[x*4] != val0)
           || (src[x*4+1] != val1)
           || (src[x*4+2] != val2)
           || (src[x*4+3] != val3)
         ) {
        height = y;
        return;
      }
    y++;
  }
}

}
