/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "OXNewClient.h"


#include <xclass/OXClient.h>
#include <xclass/OXMsgBox.h>
#include <xclass/OXTransientFrame.h>
#include <xclass/OXTextButton.h>
#include <xclass/OXLabel.h>
#include <xclass/OXSecretTextEntry.h>
#include <xclass/OString.h>
#include <xclass/OXFont.h>
#include <xclass/OXIcon.h>
#include <xclass/OXMsgBox.h>
#include <xclass/OPicture.h>


class OXNewClient : public OXTransientFrame {
public:
  OXNewClient( char *_buffer, size_t _len, int &ret,
              const OXWindow *p, const OXWindow *m, int w = 373, int h = 116 );
  virtual ~OXNewClient();

  virtual int ProcessMessage(OMessage *msg);

protected:
  OXButton *buttonOK;
  OXButton *buttonCancel;

  OXTextEntry *entryNewClient;

  OXCompositeFrame *frameButtons;

  OXLabel *labelNewClient;

  OLayoutHints *_lh;
  
  char *buffer;
  size_t len;
  int *retCode;
};



int getNewClient( char *buffer, size_t len,
		  const OXWindow *p, const OXWindow *m )
{
  int retCode = 0;
  new OXNewClient( buffer, len, retCode, p, m );
  return retCode;
}


OXNewClient::OXNewClient( char *_buffer, size_t _len, int &ret,
                          const OXWindow *p, const OXWindow *m, int w, int h)
  : OXTransientFrame(p, m, 16, 16, 0)
  , buffer( _buffer )
  , len( _len )
  , retCode( &ret )
{
  OFontPool *fp = new OFontPool( _client );
  OXFont *font = fp->GetFont("-adobe-helvetica-medium-r-normal-*-11-*-*-*-*-*-*-*");

  ChangeOptions((GetOptions() & ~VERTICAL_FRAME) | HORIZONTAL_FRAME);

  OXCompositeFrame *frameButtons = new OXCompositeFrame(this, 60, 20, VERTICAL_FRAME | FIXED_WIDTH);

  buttonOK      = new OXTextButton(frameButtons, new OHotString("&OK"), 101);
  buttonCancel  = new OXTextButton(frameButtons, new OHotString("&Cancel"), 102);
  
  buttonOK->Associate(this);
  buttonCancel->Associate(this);

  SetDefaultAcceptButton(buttonOK);
  SetDefaultCancelButton(buttonCancel);

  _lh = new OLayoutHints(LHINTS_RIGHT | LHINTS_TOP | LHINTS_EXPAND_X, 2, 2, 2, 2);
  frameButtons->AddFrame( buttonOK, _lh );
  frameButtons->AddFrame( buttonCancel, _lh );

  frameButtons->Resize( 80, frameButtons->GetDefaultHeight());
  _lh = new OLayoutHints(LHINTS_RIGHT | LHINTS_TOP, 0, 8, 8, 8);
  AddFrame(frameButtons, _lh);


  entryNewClient = new OXTextEntry( this, new OTextBuffer( len-1 ) );
  entryNewClient->SetWidth( 160 );
  _lh = new OLayoutHints(LHINTS_RIGHT | LHINTS_TOP, 0, 8, 20, 8);
  AddFrame(entryNewClient, _lh);

  labelNewClient = new OXLabel(this, new OString("New Client:") );
  labelNewClient->SetFont( font );
  _lh = new OLayoutHints(LHINTS_TOP | LHINTS_RIGHT, 8, 8, 24, 8);
  AddFrame(labelNewClient, _lh);


  SetFocusOwner( entryNewClient );

  SetWindowName("Add New Client");

  w = GetDefaultWidth();
  h = GetDefaultHeight();
  Resize(w, h);
  SetWMSize(w, h);
  SetWMSizeHints(w, h, w, h, 0, 0);
  MapSubwindows();

  Move((_client->GetDisplayWidth() - GetWidth()) >> 1,
       (_client->GetDisplayHeight() - GetHeight()) >> 1);

  SetMWMHints(MWM_DECOR_ALL | MWM_DECOR_MAXIMIZE | MWM_DECOR_MENU,
              MWM_FUNC_ALL | MWM_FUNC_MAXIMIZE | MWM_FUNC_RESIZE,
              MWM_INPUT_MODELESS);

     
  MapWindow();
  _client->WaitFor(this);
}






OXNewClient::~OXNewClient() {
  delete _lh;
}







int OXNewClient::ProcessMessage(OMessage *msg) {
  OWidgetMessage *wmsg = (OWidgetMessage *) msg;

// Button OK
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == 101)) {
        if ( entryNewClient->GetString()[0] ) {
          snprintf ( buffer, len, "%s", entryNewClient->GetString() );
          (*retCode) = 1;
	  delete this;
        } else {
          new OXMsgBox( _client->GetRoot(), this,
                        new OString( "RFB info" ),
                        new OString( "Empty client field" ),
                        MB_ICONEXCLAMATION,
                        ID_OK );
        }
      }

// Button Cancel
  if ((msg->type == MSG_BUTTON) &&
      (msg->action == MSG_CLICK) &&
      (wmsg->id == 102)) {
        delete this;
      }


  return True;
}


