/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "XFramebuffer.h"

#include <stdlib.h>
#include <string.h>

#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/Xutil.h>
#include <X11/extensions/XShm.h>

static XShmSegmentInfo shminfo;

namespace rfb {

XFramebuffer::XFramebuffer( Display *_display,
                  Window _window,
		  unsigned int _width,
		  unsigned int _height )
      : Framebuffer()
      , display( _display )
      , window( _window )
      , colormap( NULL )
    {
      width = _width;
      height = _height;
      XWindowAttributes xwa;
      XGetWindowAttributes( display,
                            window,
			    &xwa );
                            
      sharedMemory = XShmQueryExtension(display);
//      sharedMemory = 0;
//      cout << "sharedMemory: " << sharedMemory << endl;

//      cout << "default depth: " << DefaultDepth( display, DefaultScreen( display ) ) << endl;
//      cout << "colormap: " << xwa.colormap << endl;
        
      if ( sharedMemory ) {
        image = XShmCreateImage( display,
                                 xwa.visual,
                                 DefaultDepth( display, DefaultScreen( display ) ),
                                 ZPixmap,
                                 NULL,
                                 &shminfo,
			         width,
                                 height
                               );

      } else {
        image = XCreateImage( display,
                              xwa.visual,
                              DefaultDepth( display, DefaultScreen( display ) ),
                              ZPixmap,
                              0,
                              NULL,
                              width,
                              height,
                              xwa.depth,
                              0
                            );
      }                          
      bytesPerLine = image->bytes_per_line;
      
      if ( sharedMemory ) {
        shminfo.shmid = shmget( IPC_PRIVATE,
	               	        bytesPerLine * height,
			        IPC_CREAT | 0777
                              );

      if (shminfo.shmid == -1) {
        XDestroyImage(image);
      }

      shminfo.shmaddr = image->data = (char *) shmat(shminfo.shmid, 0, 0);

      if (shminfo.shmaddr == (char *)-1) {
        XDestroyImage(image);
        shmctl(shminfo.shmid, IPC_RMID, 0);
      }

      shminfo.readOnly = True;

      XShmAttach(display, &shminfo);
      XSync(display, False);
      
      } else {
        image->data = (char *) malloc( height * bytesPerLine );
      }
      
      data = (unsigned char *) image->data;
      
//      cout << "create PixelFormat" << endl;
      
      pixelFormat.bits_per_pixel = image->bits_per_pixel;
      pixelFormat.depth = image->depth;
      pixelFormat.big_endian_flag = ( image->byte_order == MSBFirst );
      pixelFormat.true_colour_flag = 1;
      
      unsigned int min, max, mask;


//    if ( !xwa.colormap ) {
// red
      mask = 1; min = 0;
      while( !(image->red_mask & mask) ) { min++; mask <<= 1; }
      max = pixelFormat.red_shift = min;
      while( image->red_mask & mask ) { max++; mask <<= 1; }
      pixelFormat.red_max = (1 << ( max - min )) - 1;
      mask = 1; min = 0;
// green
      while( !(image->green_mask & mask) ) { min++; mask <<= 1; }
      max = pixelFormat.green_shift = min;
      while( image->green_mask & mask ) { max++; mask <<= 1; }
      pixelFormat.green_max = (1 << ( max - min )) - 1;
// blue
      mask = 1; min = 0;
      while( !(image->blue_mask & mask) ) { min++; mask <<= 1; }
      max = pixelFormat.blue_shift = min;
      while( image->blue_mask & mask ) { max++; mask <<= 1; }
      pixelFormat.blue_max = (1 << ( max - min )) - 1;

/*      
    } else {
        cmap = XCreateColormap( display,
                                DefaultRootWindow( display ),
                                xwa.visual,
                                AllocNone );
    
        pixelFormat.red_shift = 0;
        pixelFormat.green_shift = 3;
        pixelFormat.blue_shift = 6;
        pixelFormat.red_max = 7;
        pixelFormat.green_max = 7;
        pixelFormat.blue_max = 3;
        XColor c;
        colormap = new int[256];
        int i;
        for ( i = 0; i < 256; i++ ) {
          c.red   = 65535 * ((i >> 0) & 7) / 7;
          c.green = 65535 * ((i >> 3) & 7) / 7;
          c.blue  = 65535 * ((i >> 6) & 3) / 3;
          if (!XAllocColor( display, cmap, &c ) ) break;
          colormap[i] = c.pixel;
        }
    }
      
//      cout << "PixelFormat created" << endl;
*/
      gc = XCreateGC( display, window, 0, NULL );
}



void XFramebuffer::update( unsigned int _x,
                           unsigned int _y,
                           unsigned int _w,
                           unsigned int _h
                         )
  {
/*
    if ( colormap ) {
      XSetWindowColormap( display, DefaultRootWindow( display ), cmap );
      unsigned int x, y;
      for( y = _y; y < _y + _h; y++ )
        for( x = _x; x < _x + _w; x++ )
          data[ y * bytesPerLine + x ] = colormap[ data[ y * bytesPerLine + x ] ];
    }
*/
    if ( sharedMemory ) {
      XShmPutImage( display,
                    window,
                    gc,
                    image,
  	            _x, _y,
	            _x, _y,
	            _w, _h,
                    0 );
    } else {
      XPutImage( display,
                 window,
                 gc,
	         image,
	         _x, _y,
	         _x, _y,
	         _w, _h );
    }
  }

void XFramebuffer::copyRect( unsigned int _destX,
                             unsigned int _destY,
                             unsigned int _width,
                             unsigned int _height,
                             unsigned int _srcX,
                             unsigned int _srcY
                           )
  {
    XCopyArea( display,
               window,
               window,
               gc,
               _srcX, _srcY,
               _width, _height,
               _destX, _destY );
  }










}
