/* -*- Mode: C; c-file-style: "k&r"; -*-*/

/* gpcp.h
 *    library API
 *
 * $Id: gpcp.h,v 1.6 2000/10/29 03:12:07 remi Exp $
 *
 * Copyright (C) 2000,
 *     Antoine Lefebvre <antoine.lefebvre@polymtl.ca>
 *     Remi Lefebvre <remi@debian.org>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#ifndef __gpcp_h__
#define __gpcp_h__

#include "parser.h"


/* register option structure */
int GPCP_RegisterOptions(Options *opt);

/* parse file and fill in dataptr */
int GPCP_ReadFile(char *filename, Data **dataptr);

/* free memory */
int GPCP_FreeData(Data **dataptr);

/* print data out -- debug */
int GPCP_PrintData(Data *data);

/* Enter rank'th level of name 'name' */
int GPCP_EnterLevel(char *name, int rank);

/* Leave current level */
int GPCP_ExitLevel(void);


/* Get the value of 'keyword' and fill var */
int GPCP_GetValue(char *keyword, void *var);

/* get the number of parents of name "parent_name" */
int GPCP_NumParent(char *parent_name);



/* set global pointer ... huh, useful ? */
int GPCP_SetData(Data *data);

/* Return the number of keywords in the actual level.
   It starts at the main level */
int GPCP_NumKey(void);

/* Set 'name' to the name of the keywords in position pos.
   Return -1 on error (invalid pos) */
int GPCP_KeyName(int pos, char **name);

/* Set 'type' to the type of the keywords in position pos.
   Return -1 on error (invalid pos) */
int GPCP_KeyType(int pos, Types **type);


#endif /* __gpcp_h__ */
