/* -*- Mode: C; c-file-style: "k&r"; -*-*/

/* rocket.c
 *    sample program for parsing a rocket propellant simulator config.
 *
 * $Id: rocket.c,v 1.6 2001/03/30 20:38:04 antoine Exp $
 *
 * Copyright (C) 2000,
 *     Antoine Lefebvre <antoine.lefebvre@polymtl.ca>
 *     Remi Lefebvre <remi@debian.org>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#include <stdlib.h>
#include "gpcp.h"


Options rocket_options[] = {
     {"global",              PARENT, NULL},
     {"propellant_database", STRING, "global"},
     {"product_database",    STRING, "global"},
     {"propellant",          PARENT, NULL},
     {"name",                STRING, "propellant"},
     {"ingrediant",          PARENT, "propellant"},
     {"name",                STRING, "ingrediant"},
     {"formula",             STRING, "ingrediant"},
     {"comp",                PARENT, "ingrediant"},
     {"ing",                 PARENT, "comp"},
     {"qty",                 INTEGER,"ing"},
     {"at",                  STRING, "ing"},
     {"enthalpy",            PARENT, "ingrediant"},
     {"val",                 FLOAT,  "enthalpy"},
     {"units",               STRING, "enthalpy"},
     {"qty",                 PARENT, "ingrediant"},
     {"val",                 FLOAT,  "qty"},
     {"units",               STRING, "qty"},
     {"density",             PARENT, "propellant"},
     {"val",                 FLOAT,  "density"},
     {"units",               STRING, "density"},
     {"database",            INTEGER,"ingrediant"},
     {"problem",             PARENT, NULL},
     {"type",                STRING, "problem"},
     {"propellant",          STRING, "problem"},
     {"chamber_pressure",    PARENT, "problem"},
     {"val",                 FLOAT,  "chamber_pressure"},
     {"units",               STRING, "chamber_pressure"},
     {"exit_pressure",       PARENT, "problem"},
     {"val",                 FLOAT,  "exit_pressure"},
     {"units",               STRING, "exit_pressure"},
     {NULL,                  0,      NULL}
};

Functions rocket_functions[] = {
     {"compute_density", FLOAT},
     {NULL,              0}
};


int main(int argc, char *argv[])
{
     int i;
     int n;
     char *name;
     Types *type;
  
     Data *data;
  
     GPCP_RegisterOptions(rocket_options);   
     GPCP_ReadFile("input.pro", &data);

     GPCP_PrintData(data);
     
//     GPCP_SetData(data); /* set the global pointer */
/*  

  
     n = GPCP_NumKey();
     printf("Number of main key: %d\n", n);
     for (i = 0; i < n; i++)
     {
          if (GPCP_KeyName(i, &name) == -1)
               return -1;
          if (GPCP_KeyType(i, &type) == -1)
               return -1;
          printf("Keyword %d (type %d): %s\n", i, *type, name);

          if (strcmp(name, "global") == 0)
          {
               get_global_value(i);
          }
          else if (strcmp(name, "propellant") == 0)
          {
               get_propellant(i);
          }
     }
*/  
     GPCP_FreeData(&data);

  
     return 0;
  
}

/*
int get_global_value(int pos)
{
     int i;
     int n;
     char *name;
     Types *type;
     Value *val;

  
     if (GPCP_EnterSub(pos) == -1)
          return -1;

     n = GPCP_NumKey();

     for (i = 0; i <  n; i++)
     {
          GPCP_KeyName(i, &name);
          printf("Keyword %d: %s\n", i, name);

          GPCP_GetValue(i, &val, &type);
    
          if (strcmp(name, "propellant_database") == 0)
          {
               printf("  Value: %s\n", val->string);
          }
          else if (strcmp(name, "product_database") == 0)
          {
               printf("  Value: %s\n", val->string); 
          }
     }

     GPCP_LeaveSub();
  
     return 0;
}

int get_propellant(int pos)
{

     int i;
     int n;

     char *name;
     Types *type;
     Value *val;

     if (GPCP_EnterSub(pos) == -1)
          return -1;

     n = GPCP_NumKey();

     for (i = 0; i <  n; i++)
     {
          GPCP_KeyName(i, &name);
          printf("Keyword %d: %s\n", i, name);

          GPCP_GetValue(i, &val, &type);
    
          if (strcmp(name, "name") == 0)
          {
               printf("  Value: %s\n", val->string);
          }
          else if (strcmp(name, "ingrediant") == 0)
          {
               get_ingrediant(i);
//      printf("  Value: %s\n", val->string); 
          }
          else if (strcmp(name, "density") == 0)
          {
               printf("  Value: %f\n", *(val->number)); 
          }
    
     }
  
     GPCP_LeaveSub();
     return 0;
}


int get_ingrediant(int pos)
{
     int i;
     int n;
  
     char *name;
     Types *type;
     Value *val;

     if (GPCP_EnterSub(pos) == -1)
          return -1;
  
     n = GPCP_NumKey();

     for (i = 0; i <  n; i++)
     {
          GPCP_KeyName(i, &name);
          printf("Keyword %d: %s\n", i, name);

          GPCP_GetValue(i, &val, &type);
    
          if (strcmp(name, "name") == 0)
          {
               printf("  Value: %s\n", val->string);
          }
          else if (strcmp(name, "formula") == 0)
          {
               printf("  Value: %s\n", val->string); 
          }
          else if (strcmp(name, "comp") == 0)
          {
//      printf("  Value: %f\n", *(val->number)); 
          }
          else if (strcmp(name, "enthalpy") == 0)
          {

          }
          else if (strcmp(name, "qty") == 0)
          {
      
          }
    
     }

     GPCP_LeaveSub();
     return 0;
}
*/
