// @(#)root/net:$Id: TAS3File.h 41144 2011-10-05 13:15:20Z rdm $
// Author: Marcelo Sousa   23/08/2011

/*************************************************************************
 * Copyright (C) 1995-2011, Rene Brun and Fons Rademakers.               *
 * All rights reserved.                                                  *
 *                                                                       *
 * For the licensing terms see $ROOTSYS/LICENSE.                         *
 * For the list of contributors see $ROOTSYS/README/CREDITS.             *
 *************************************************************************/

#ifndef ROOT_TAS3File
#define ROOT_TAS3File

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// TAS3File                                                             //
//                                                                      //
// A TAS3File is a normal TWebFile but it reads data from the           //
// Amazon S3 server. As a derived TWebFile class TAS3File it is a       //
// read only file. The HTTP requests are generated by THTTPMessage      //
// objects with the auth_prefix set as AWS. The user id and secret pass //
// required to sign the requests are passed through the environment     //
// variables S3_ACCESS_ID and S3_ACCESS_KEY.                            //
// For more information check:                                          //
//   http://aws.amazon.com/documentation/s3/                            //
//   http://awsdocs.s3.amazonaws.com/S3/latest/s3-qrc.pdf               //
//                                                                      //
//////////////////////////////////////////////////////////////////////////

#ifndef ROOT_TWebFile
#include "TWebFile.h"
#endif

#ifndef ROOT_TUrl
#include "TUrl.h"
#endif

#ifndef ROOT_TString
#include "TString.h"
#endif

class TAS3File: public TWebFile {

private:
   TAS3File();

protected:
   TString fAuthPrefix;  //Authentication prefix for Amazon S3
   TString fAccessId;    //User id 
   TString fAccessKey;   //Secret key
   TUrl    fServer;      //Server url
   TString fBucket;      //Bucket name

   Int_t GetHead();
   Bool_t ReadBuffer10(char *buf, Int_t len);

public:
   TAS3File(const char *url, Option_t *opt="");
   virtual ~TAS3File() { }

   Bool_t  ReadBuffer(char *buf, Int_t len);
   Bool_t  ReadBuffer(char *buf, Long64_t pos, Int_t len) { return TWebFile::ReadBuffer(buf, pos, len); }
   TString GetAuthPrefix() const { return fAuthPrefix; }
   TString GetAccessId() const { return fAccessId; }
   TString GetAccessKey() const { return fAccessKey; }
   TUrl    GetUrl() const { return fServer; }
   TString GetBucket() const { return fBucket; }

   ClassDef(TAS3File, 0)  // Read a ROOT file from the Amazon S3 cloud
};

#endif
