/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyResponse;

public abstract class HttpServlet
extends GenericServlet
implements Serializable {
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(400, "GET is not supported by this URL");
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        return -1L;
    }

    private void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        NoBodyResponse noBodyResponse = new NoBodyResponse(httpServletResponse);
        this.doGet(httpServletRequest, noBodyResponse);
        noBodyResponse.setContentLength();
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(400, "POST is not supported by this URL");
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(400, "PUT is not supported by this URL");
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.sendError(400, "DELETE is not supported by this URL");
    }

    private Method[] getAllDeclaredMethods(Class clazz) {
        if (clazz.getName().equals("javax.servlet.http.HttpServlet")) {
            return null;
        }
        int n = 0;
        Method[] methodArray = this.getAllDeclaredMethods(clazz.getSuperclass());
        Method[] methodArray2 = clazz.getDeclaredMethods();
        if (methodArray != null) {
            Method[] methodArray3 = new Method[methodArray.length + methodArray2.length];
            int n2 = 0;
            while (n2 < methodArray.length) {
                methodArray3[n2] = methodArray[n2];
                n = n2++;
            }
            int n3 = ++n;
            while (n3 < methodArray2.length + n) {
                methodArray3[n3] = methodArray2[n3 - n];
                ++n3;
            }
            return methodArray3;
        }
        return methodArray2;
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Method[] methodArray = this.getAllDeclaredMethods(this.getClass());
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = true;
        boolean bl7 = true;
        int n = 0;
        while (n < methodArray.length) {
            object = methodArray[n];
            if (((Method)object).getName().equals("doGet")) {
                bl = true;
                bl2 = true;
            }
            if (((Method)object).getName().equals("doPost")) {
                bl3 = true;
            }
            if (((Method)object).getName().equals("doPut")) {
                bl4 = true;
            }
            if (((Method)object).getName().equals("doDelete")) {
                bl5 = true;
            }
            ++n;
        }
        object = null;
        if (bl && object == null) {
            object = "GET";
        }
        if (bl2) {
            object = object == null ? "HEAD" : String.valueOf(object) + ", HEAD";
        }
        if (bl3) {
            object = object == null ? "POST" : String.valueOf(object) + ", POST";
        }
        if (bl4) {
            object = object == null ? "PUT" : String.valueOf(object) + ", PUT";
        }
        if (bl5) {
            object = object == null ? "DELETE" : String.valueOf(object) + ", DELETE";
        }
        if (bl6) {
            object = object == null ? "TRACE" : String.valueOf(object) + ", TRACE";
        }
        if (bl7) {
            object = object == null ? "OPTIONS" : String.valueOf(object) + ", OPTIONS";
        }
        httpServletResponse.setHeader("Allow", (String)object);
    }

    protected void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        String string = "\r\n";
        String string2 = "TRACE " + httpServletRequest.getRequestURI() + " " + httpServletRequest.getProtocol();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            string2 = String.valueOf(string2) + string + (String)object + ": " + httpServletRequest.getHeader((String)object);
        }
        string2 = String.valueOf(string2) + string;
        int n = string2.length();
        httpServletResponse.setContentType("message/http");
        httpServletResponse.setContentLength(n);
        object = httpServletResponse.getOutputStream();
        ((ServletOutputStream)object).print(string2);
        ((OutputStream)object).close();
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (string.equals("GET")) {
            long l = httpServletRequest.getDateHeader("If-Modified-Since");
            long l2 = this.getLastModified(httpServletRequest);
            this.maybeSetLastModified(httpServletResponse, l2);
            if (l == -1L || l2 == -1L) {
                this.doGet(httpServletRequest, httpServletResponse);
                return;
            }
            long l3 = System.currentTimeMillis();
            if (l3 < l || l < l2) {
                this.doGet(httpServletRequest, httpServletResponse);
                return;
            }
            httpServletResponse.sendError(304);
            return;
        }
        if (string.equals("HEAD")) {
            long l = this.getLastModified(httpServletRequest);
            this.maybeSetLastModified(httpServletResponse, l);
            this.doHead(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals("POST")) {
            this.doPost(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals("PUT")) {
            this.doPut(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals("DELETE")) {
            this.doDelete(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals("OPTIONS")) {
            this.doOptions(httpServletRequest, httpServletResponse);
            return;
        }
        if (string.equals("TRACE")) {
            this.doTrace(httpServletRequest, httpServletResponse);
            return;
        }
        httpServletResponse.sendError(501, "Method '" + string + "' is not defined in RFC 2068");
    }

    private void maybeSetLastModified(HttpServletResponse httpServletResponse, long l) {
        if (httpServletResponse.containsHeader("Last-Modified")) {
            return;
        }
        if (l >= 0L) {
            httpServletResponse.setDateHeader("Last-Modified", l);
        }
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletResponse httpServletResponse;
        HttpServletRequest httpServletRequest;
        try {
            httpServletRequest = (HttpServletRequest)servletRequest;
            httpServletResponse = (HttpServletResponse)servletResponse;
        }
        catch (ClassCastException classCastException) {
            throw new ServletException("non-HTTP request or response");
        }
        this.service(httpServletRequest, httpServletResponse);
    }
}

