# Stolen whole-heartedly from Glib for use in Roy.
# Originally by: Owen Taylor     97-11-3
# Stolen by: Brian Bassett <bbassett@bbassett.net> 24 Jan 2002
# Fixed by Ian Main <ian4@stemwinder.org> 29 Jan 2002
# glibs error messages are broken.

dnl AM_PATH_ROY([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND [, MODULES]]]])
dnl Test for Roy, and define ROY_CFLAGS and ROY_LIBS, and pass MODULES to
dnl roy-config.
dnl
AC_DEFUN([AM_PATH_ROY],
[dnl 
dnl Get the cflags and libraries from the roy-config script
dnl
AC_ARG_WITH(roy-prefix,[  --with-roy-prefix=PFX   Prefix where Roy is installed (optional)],
            roy_config_prefix="$withval", roy_config_prefix="")
AC_ARG_WITH(roy-exec-prefix,[  --with-roy-exec-prefix=PFX Exec prefix where Roy is installed (optional)],
            roy_config_exec_prefix="$withval", roy_config_exec_prefix="")
AC_ARG_ENABLE(roytest, [  --disable-roytest       Do not try to compile and run a test Roy program],
		    , enable_roytest=yes)

  if test x$roy_config_exec_prefix != x ; then
     if test x${ROY_CONFIG+set} != xset ; then
        ROY_CONFIG=$roy_config_exec_prefix/bin/roy-config
     fi
  fi
  if test x$roy_config_prefix != x ; then
     if test x${ROY_CONFIG+set} != xset ; then
        ROY_CONFIG=$roy_config_prefix/bin/roy-config
     fi
  fi

  AC_PATH_PROG(ROY_CONFIG, roy-config, no)
  min_roy_version=ifelse([$1], ,1.0.0,$1)
  AC_MSG_CHECKING(for Roy - version >= $min_roy_version)
  no_roy=""
  if test "$ROY_CONFIG" = "no" ; then
    no_roy=yes
  else
    ROY_CFLAGS=`$ROY_CONFIG --cflags`
    CMD="$ROY_CONFIG --libs "
    CMD="$CMD $4"
    ROY_LIBS=`$CMD` 

    roy_major_version=`$ROY_CONFIG --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    roy_minor_version=`$ROY_CONFIG --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    roy_micro_version=`$ROY_CONFIG --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_roytest" = "xyes" ; then
      ac_save_CFLAGS="$CFLAGS"
      ac_save_LIBS="$LIBS"
      CFLAGS="$CFLAGS $ROY_CFLAGS"
      LIBS="$ROY_LIBS $LIBS"
dnl
dnl Now check if the installed Roy is sufficiently new. (Also sanity
dnl checks the results of roy-config to some extent
dnl
      rm -f conf.roytest
      AC_TRY_RUN([
#include <roy.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

int 
main ()
{
  int major, minor, micro;
  char *tmp_version;

  system ("touch conf.roytest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = strdup("$min_roy_version");
  if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
     printf("%s, bad version string\n", "$min_roy_version");
     exit(1);
   }

   if ( ( (ROY_MAJOR_VERSION == major) && (ROY_MINOR_VERSION > minor) ) ||
      ( (ROY_MAJOR_VERSION == major) && (ROY_MINOR_VERSION == minor) ) && 
       (ROY_MICRO_VERSION >= micro))
    {
      return 0;
    }
   else
    {
      printf ("\n*** The version of Roy found was %d.%d.%d, but the required\n",
              ROY_MAJOR_VERSION, ROY_MINOR_VERSION, ROY_MICRO_VERSION);
      printf ("*** minimum version requested is %d.%d.%d.  Please attain\n",
              major, minor, micro);
      printf ("*** a newer version of Roy.  It may also be possible that\n");
      printf ("*** the wrong roy-config is being detected. This may\n");
      printf ("*** be overridden by setting the ROY_CONFIG environment\n");
      printf ("*** variable.\n");
    }
  return 1;
}
],, no_roy=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_roy" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$ROY_CONFIG" = "no" ; then
       echo "*** The roy-config script installed by Roy could not be found"
       echo "*** If Roy was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the ROY_CONFIG environment variable to the"
       echo "*** full path to roy-config."
     else
       if test -f conf.roytest ; then
        :
       else
          echo "*** Could not run Roy test program, checking why..."
          CFLAGS="$CFLAGS $ROY_CFLAGS"
          LIBS="$LIBS $ROY_LIBS"
          AC_TRY_LINK([
#include <roy.h>
#include <stdio.h>
],      [ return 0; ],
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding Roy or finding the wrong"
          echo "*** version of Roy. If it is not finding Roy, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH"
          echo "***" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means Roy was incorrectly installed"
          echo "*** or that you have moved Roy since it was installed." ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     ROY_CFLAGS=""
     ROY_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_SUBST(ROY_CFLAGS)
  AC_SUBST(ROY_LIBS)
  rm -f conf.roytest
])

