
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

/* -*- mode: C; c-basic-offset: 4  -*- */ 
#ifndef __RLIST_OF_H__
#define __RLIST_OF_H__

/* Documentation!
 * 
 * This file defines some useful list types:
 *
 * RListOfPtr: lists whose data is a (void *), similar to glib's list type.
 * RListOfRBuf: lists whose data are RBuf *.
 */

/* ------------------------*/
/* RListOfPtr */

/* structure definitions */
typedef RList                     RListOfPtr;

typedef struct _RListOfPtrEntry   RListOfPtrEntry;

struct _RListOfPtrEntry {
    RLIST_HEADER;
    void *data;
};



/* allocate space for an RListOfPtr */
#define rlist_of_ptr_new() ((RListOfPtr*)rlist_new())

/* allocate a new entry in an RListOfPtr */
RListOfPtrEntry *
rlist_of_ptr_entry_new (void *ptr);

/* free an entry in an RListOfPtr */
void
rlist_of_ptr_entry_free (RListOfPtrEntry *ptr);



/* ------------------------*/
/* RListOfRBuf */


/* structure definitions */
typedef RList                   RListOfRBuf;

typedef struct _RListOfRBufEntry RListOfRBufEntry;

struct _RListOfRBufEntry {
    RLIST_HEADER;
    RBuf *buf;
};

/* allocate space for an RListOfRBuf */
#define rlist_of_rbuf_new() ((RListOfRBuf*)rlist_new())

/* allocate a new entry in an RListOfRBuf */
RListOfRBufEntry *
rlist_of_rbuf_entry_new (RBuf *buf);


/* Free the rlist full of RBufEntry's. */
void
rlist_of_rbuf_free (RList *list);


/* free an entry in an RListOfRBuf */
void
rlist_of_rbuf_entry_free (RListOfRBufEntry *ptr);



/* comparison function for RListOfRBuf lists. */
int
rlist_of_rbuf_compare (const RListEntry *a_, const RListEntry *b_);


RBuf *
rlist_of_rbuf_join (RList *bufs, char *separator);


#endif /* __RLIST_OF_H__ */

