#include <roy.h>

#define NUM_THREADS   5

RThreadMutex some_global_mtx;
static int some_global = 0;

RThreadMutex another_global_mtx;
static int another_global = 0;

RThreadMutex printf_mtx;

#define USE_THREADS 1


/* Total hackery to get it so we can test speed of non-threaded
 * version. */
#if !USE_THREADS

#undef RTHREAD_MUTEX_ENTER
#define RTHREAD_MUTEX_ENTER(mutex) do

#undef RTHREAD_MUTEX_EXIT
#define RTHREAD_MUTEX_EXIT(mutex) while (0)

#endif

static void *
mutex_test (void *data)
{
    long tid = (long) data;
    int a, t, i = 0;
    int tmp;

    for (a = 0; a < 1000; a++) {
        for (t = 0; t < 100000; t++) {
            i++;
        }
        RTHREAD_MUTEX_ENTER (some_global_mtx) {
            tmp = some_global;
            tmp++;
            some_global = tmp;
        } RTHREAD_MUTEX_EXIT (some_global_mtx);
       
#if USE_THREADS
        rthread_mutex_lock (another_global_mtx);
#endif
        tmp = another_global;
        tmp++;
        another_global = tmp;
#if USE_THREADS
        rthread_mutex_unlock (another_global_mtx);
#endif 

        rthread_yield_if_coop ();
    }


    RTHREAD_MUTEX_ENTER (printf_mtx) {
        printf ("-- thread %ld: %d iterations, some_global: %d\n", tid, i, some_global);
    } RTHREAD_MUTEX_EXIT (printf_mtx);

    return ((void *) tid);
}

RThreadEvent test_event;
RThreadEvent test_event_noauto;

void *
event_test (void *data)
{
    long tid = (long) data;
    int i;

    for (i = 0; i < 2; i++) {
        printf ("-- thread %ld waiting for event\n", tid);
        rthread_event_wait (test_event);
        printf ("-- thread %ld released on iteration %d\n", tid, i);
    }

    printf ("-- thread %ld waiting at manual gate..\n", tid);
    rthread_event_wait (test_event_noauto);

    printf ("-- thread %ld exiting..\n", tid);

    return ((void *) tid);
}

int
main (int argc, char *argv[])
{
    long t;
    int i;

#if USE_THREADS
    RThread *thread[NUM_THREADS];

    rinit_threaded ();

    some_global_mtx = rthread_mutex_new ();
    another_global_mtx = rthread_mutex_new ();
    printf_mtx = rthread_mutex_new ();
    
    for (t = 0; t < NUM_THREADS; t++) {
        
        printf ("Creating thread %ld\n", t);

        thread[t] = rthread_create (mutex_test, (void *) t);

        if (rthread_err (thread[t])) {
            printf ("error creating thread: %s\n", rthread_strerror (thread[t]));
            rthread_free (thread[t]);
            goto max_reached;
        }
    }

max_reached:

    /* Make sure all the threads exit before we do.. */
    for (--t; t >= 0; t--) {
        void *data;
        rthread_waitfor (thread[t], &data);
        printf ("thread %ld exited\n", (long) data);
        rthread_free (thread[t]);
    }

    rthread_mutex_destroy (some_global_mtx);
    rthread_mutex_destroy (another_global_mtx);

    test_event = rthread_event_new (TRUE);
    test_event_noauto = rthread_event_new (FALSE);

    for (t = 0; t < NUM_THREADS; t++) {
        
        printf ("Creating thread %ld\n", t);

        thread[t] = rthread_create (event_test, (void *) (long) t);

        if (rthread_err (thread[t])) {
            printf ("error creating thread: %s\n", rthread_strerror (thread[t]));
            rthread_free (thread[t]);
            goto max_reached;
        }
    }
   
    rthread_yield_if_coop ();

    /* Really this is wrong, we are doing this to wait for
     * the threads to hit the rthread_event_wait () above
     * cause if we set the event before they get there, the message
     * will be missed and they won't fall through.
     * However, this is just a test so it's ok, and it allows
     * us to test behavior on that as well.  */
    for (i = 0; i < 1000000000; i++);

    rthread_yield_if_coop ();

    for (i = 0; i < NUM_THREADS * 2; i++) {
        printf ("Calling rthread_event_set ()\n");
        rthread_event_set (test_event);
        printf ("done.\n");
    }

    for (i = 0; i < 1000000000; i++);

    printf ("Letting all threads through manual gate.\n");
    rthread_event_set (test_event_noauto);
    
    for (--t; t >= 0; t--) {
        void *data;
        rthread_waitfor (thread[t], &data);
        printf ("thread %ld exited\n", (long) data);
        rthread_free (thread[t]);
    }

    rthread_event_destroy (test_event);
    rthread_event_destroy (test_event_noauto);

#else

    rinit ();

    for (t = 0; t < NUM_THREADS; t++) {
        mutex_test ((void *) t);
    }
#endif

    printf ("global is %d\n", some_global);

    return (0);
}


