
;;
;; commit the current state of the persistent store
;; (not particularly thread safe... if you have
;; one thread writing into the pstore while another
;; is trying to commit, the commit could never complete,
;; fail, and if it did, it won't necessarily represent
;; the state of the store a the time (commit) was
;; called

;;
;; if called with just one argument, doesn't change the root object
;;

(define (get-tip-size (self <persistent-store>))
  (let ((l (underlying-lss self)))
    (lss-get-vol-size l (lss-get-tip l))))

(define-method commit ((ps <persistent-store>) 
                       #optional (root default: (root-object ps)))
  (let ((reloc (make-object-table))
        (start-size (get-tip-size ps))
        (live-table (if (online-compaction-waiting-for-commit? ps)
                        (cons (make-object-table) '())
                        #f)))
    (let loop ((i 0))
      (let ((cf (pstore-commit* ps root reloc (and live-table 
                                                   (car live-table)))))
                                                  
	(if (pair? cf)
	    (begin
	      (copy-in* ps reloc cf)
	      (loop (+ i 1)))
	    ;;
	    ;; return the new commit record ID
	    ;;
            (begin
              (fuel-online-compaction! ps 
                                       (if live-table
                                           (list cf live-table)
                                           (- (get-tip-size ps) start-size)))
              cf))))))
