/*
	Copyright (C) 2004 - 2006 rt2x00 SourceForge Project
	<http://rt2x00.serialmonkey.com>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the
	Free Software Foundation, Inc.,
	59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
	Module: rt2x00
	Abstract: rt2x00 global information.
	Supported chipsets: rt2400, rt2500, rt2561, rt2561s & rt2661.
 */

#ifndef RT2X00PCI_H
#define RT2X00PCI_H

/*
 * Register defines.
 * When register access attempts should be repeated
 * only REGISTER_BUSY_COUNT attempts with a delay
 * of REGISTER_BUSY_DELAY us should be taken.
 */
#define REGISTER_BUSY_COUNT	5
#define REGISTER_BUSY_DELAY	100

/*
 * EEPROM operation defines.
 */
#define EEPROM_WIDTH_93C46	6
#define EEPROM_WIDTH_93C66	8
#define EEPROM_WRITE_OPCODE	0x05
#define EEPROM_READ_OPCODE	0x06

/*
 * Link tuning at 1 second intervals
 */
#define LINK_TUNE_INTERVAL	( 1 * HZ )

#endif /* RT2X00PCI_H */
