%define oname rtslib

Name:           python-rtslib
License:        AGPLv3
Group:          System Environment/Libraries
Summary:        A framework to implement simple but nice CLIs.
Version:        2.1
Release:        1%{?dist}
URL:            http://www.risingtidesystems.com/git/
Source:         %{oname}-%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-rpmroot
BuildArch:      noarch
BuildRequires:  python-devel, epydoc
Requires:       python-configobj, python-netifaces, python-ipaddr
Vendor:         RisingTide Systems

%description
API for RisingTide Systems generic SCSI target.

%package doc
Summary:       PDF and HTML API reference for python-rtslib.
Group:         Documentation
BuildRequires: epydoc

%description doc
PDF and HTML API reference for python-rtslib.

%prep
%setup -q -n %{oname}-%{version}

%build
%{__python} setup.py build
mkdir -p doc/pdf
epydoc --no-sourcecode --pdf -n %{oname} --exclude configobj %{oname}/*.py
mv pdf/api.pdf doc/pdf/%{oname}_API_Documentation.pdf
epydoc --no-sourcecode --html -n %{oname} --exclude configobj %{oname}/*.py
sed -i "s/<\?/<!/g" html/*.html
sed -i "s/\?>/>/g" html/*.html
mv html doc/

%install
rm -rf %{buildroot}
%{__python} setup.py install --skip-build --root %{buildroot}
mkdir -p %{buildroot}/var/target/fabric
cp specs/* %{buildroot}/var/target/fabric
mkdir -p %{buildroot}/usr/share/doc/python-rtslib-doc-%{version}
cp -r doc/* %{buildroot}/usr/share/doc/python-rtslib-doc-%{version}/

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root,-)
%{python_sitelib}
/var/target
%doc COPYING README

%files doc
%defattr(-,root,root,-)
/usr/share/doc/python-rtslib-doc-%{version}

%changelog
* Wed Sep 21 2011 Jerome Martin <jxm@risingtidesystems.com> 2.0.5.g36f2f96-1
Fixed alignment in debian/python-rtslib.install
* Wed Sep 21 2011 Jerome Martin <jxm@risingtidesystems.com> 2.1-1
Moved doc generation to packaging scripts.
  - Doc requires version, so must be built from release tarball.
  - Building doc with package allows for clean build dependencies.
* Wed Sep 21 2011 Jerome Martin <jxm@risingtidesystems.com> 2.0.4.g811cf14-1
Cleaned up setup.py
  - Removed old vim config line.
  - Removed useless empty line.
* Wed Sep 21 2011 Jerome Martin <jxm@risingtidesystems.com> 2.0.3.gfb2bfe9-1
Now make preserves spaces for version in specfile.
* Wed Sep 21 2011 Jerome Martin <jxm@risingtidesystems.com> 2.0.2.g69b970c-1
Now using ${NAME} everywhere sensible in Makefile.
* Wed Sep 21 2011 Jerome Martin <jxm@risingtidesystems.com> 2.0.1.gb54caca-1
Now using a tarball-release based Makefile.
  - Removed useless obsolete targets (setup.py based)
  - Merged doc generation in Makefile (removed bin/gendoc).
  - Merged version templating in Makefile (removed bin/gen_changelog*).
  - Added 'release' make target that generates a dist/*.tar.gz official
    versionned release tarball from which one can just use setup.py,
    dpkg-buildpackage or rpmbuild (no Makefile in it).
  - Now the 'rpm' and 'deb' Makefile targets use the generated release build.
  - Makefile commands now use no echo mode.
  - Added timestamps for virtual targets.
* Fri Sep 16 2011 Jerome Martin <jxm@risingtidesystems.com> 2.0-1
Clarified utils.list_eth_ips() docstring.
* Fri Sep 16 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.13.g5388ea2-1
Added git URLs to README.
* Thu Sep 15 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.12.gc750957-1
Updated version numbering code.
  - Now uses 'git describe --tags' output, just replacing dashes with dots for
    compatibility with RPM version numbers.
  - For coherency, RPM and debian version numbers are now the same.
  - Removed the timestamp, as it is not needed anymore (even when reordering
    commits, the version is non-ambiguous, as for non-tagged commits we have part
    of the last commit hash and the number of commits since last tag).
* Tue Sep 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.11.gb6e4683-1
Now uses the passed ifnames in list_eth_ips().
  - Thanks to Andy Grover for spotting this bug.
* Tue Jul 19 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.10.g644eece-1
Fixed the RPM make target: work on current branch.
* Tue Jul 19 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.9.g9d8e31a-1
utils: moved threading, Queue imports to top.
* Tue Jul 19 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.8.gc316834-1
target: moved configobj, doctest imports to top.
* Mon Jul 18 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.7.g75c0cb4-1
In utils.list_eth_ips, added check for IPv4/IPv6.
  - Was trying to get IPv6 addresses even if none existed. Fixed that.
  - Was trying to get IPv4 addresses even if none existed. Fixed that.
* Thu Jun 9 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.5.g8b34822-1
Added has_feature() to NodeACL.
* Thu Jun 9 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.4.gc1d11c8-1
Added discovery auth support in fabric module.
* Thu Jun 9 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.3.gebb21d2-1
Raise RTSLibError on portal creation OSError.
  - This way, we catch the message nicely.
* Thu Jun 9 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.2.ge0fe073-1
Added missing python-configobj require to specfile
* Thu Jun 9 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.6.g52e39cf-1
Added IPv6 support for network portals.
  - utils.list_eth_ips() now lists ipv4 and ipv6
  - Added IPv6 network portal syntax for path creation
  - Added python-netifaces and python-ipaddr depends (rpm + deb)
* Sat Jun 4 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99.1.g037b92f-1
Added IOError msg to failed set attribs/params.
* Thu May 26 2011 Jerome Martin <jxm@risingtidesystems.com> 1.99-1
Added RTSLibNotInCFS exception class.
  - Using it when trying to lookup an object that does not exist.
  - Also raised when trying to call a method for an object whose configFS
    counterpart has been deleted (in _check_self()).
* Wed May 18 2011 Jerome Martin <jxm@risingtidesystems.com> 1.95.5.g47dd13a-1
Added sed inplace tmp files to clean.
* Tue May 17 2011 Jerome Martin <jxm@risingtidesystems.com> 1.95.4.gd27b82c-1
Fixed typo in module loading error message.
* Mon May 16 2011 Jerome Martin <jxm@risingtidesystems.com> 1.95.3.g549d720-1
Fixed typo/regression on backstore deletion.
  - Regression from c5578a5597e62b682382d1890d02dbe78d87da2a
* Sun May 15 2011 Jerome Martin <jxm@risingtidesystems.com> 1.95.2.g00e375d-1
Makefile cleanup: verbosity, remove tmp dir.
* Sun May 15 2011 Jerome Martin <jxm@risingtidesystems.com> 1.95.1.g93e15bd-1
Fixed RPM doc location.
* Sat May 14 2011 Jerome Martin <jxm@risingtidesystems.com> 1.95-1
For RPM build, include docs and proper version.
* Sat May 14 2011 Jerome Martin <jxm@risingtidesystems.com> 1.90.7.g9ec2cc7-1
Build process cleanup, added rpm/deb targets.
  - Now builds rpm and deb separately, intended to be used on debian and redhat
    systems respectively. No more deb -> rpm conversion using alien.
  - Integrated bin/clean into Makefile
  - Now make clean does not remove packages, added cleanall target for that.
  - Added .gitignore file.
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.90.6.gc5578a5-1
Fixed StorageObject deletion race.
  - If StorageObject status update is too slow, we might go beyond the end of the
    attached LUNs list raising a StopIteration exception. Refactored to avoid
    that.
  - Removed a couple of adjacent obsolete FIXMEs
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.90.5.gb7c496e-1
Cleaner scan of luns attached to a storage object.
  - Fixed bug in _gen_attached_luns(): checking that the /lun directory exists
    under the tpgt dirs, to make sure there _are_ tpgt dirs and not funny
    dirs like fabric_statistics or any future non-lun configfs group.
  - Simplified _list_attached_luns() by calling _gen_attached_luns(), as this was
    not a very maintainable method. Probably lost a lot of speed optimization in
    the process, but this should still be a lot faster than using RTSRoot-based
    scan, and is much cleaner.
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.90.4.g2d96b2f-1
Cleaned up trailing spaces from *.py.
* Fri May 13 2011 Jerome Martin <jxm@risingtidesystems.com> 1.90.3.g922ee7f-1
Removed duplicate _get_wwn() from PSCSIStorageObject.
  - The method was redefined there identically to parent StorageObject's one.
* Wed May 11 2011 Jerome Martin <jxm@risingtidesystems.com> 1.90.2.g1e50a7d-1
Utils: Added linux device list disk as type_disk.
  - get_block_type() was relying too much on /sys/block/*/device/type
    to infer disk type, and thus was missing a lot of type_disk devices,
    despite a couple of special cases. Added a list of all block major
    numbers from the official linux devices list that should be reported
    as TYPE_DISK, aka type '0'.
* Tue May 10 2011 Jerome Martin <jxm@risingtidesystems.com> 1.90.1.gd2c2132-1
Added public repo URL to README.
* Wed May 4 2011 Nicholas Bellinger <nab@risingtidesystems.com> 1.90-1
Initial rtslib commit
  Signed-off-by: Nicholas A. Bellinger <nab@risingtidesystems.com>
