
#line 1 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
#include <assert.h>
#include <ruby.h>

#if defined(_WIN32)
#include <stddef.h>
#endif

#ifdef HAVE_RUBY_RE_H
#include <ruby/re.h>
#else
#include <re.h>
#endif

#ifdef HAVE_RUBY_ENCODING_H
#include <ruby/encoding.h>
#define ENCODED_STR_NEW(ptr, len) \
    rb_enc_str_new(ptr, len, rb_utf8_encoding())
#else
#define ENCODED_STR_NEW(ptr, len) \
    rb_str_new(ptr, len)
#endif

#ifndef RSTRING_PTR
#define RSTRING_PTR(s) (RSTRING(s)->ptr)
#endif

#ifndef RSTRING_LEN
#define RSTRING_LEN(s) (RSTRING(s)->len)
#endif

#define DATA_GET(FROM, TYPE, NAME) \
  Data_Get_Struct(FROM, TYPE, NAME); \
  if (NAME == NULL) { \
    rb_raise(rb_eArgError, "NULL found for " # NAME " when it shouldn't be."); \
  }
 
typedef struct lexer_state {
  int content_len;
  int line_number;
  int current_line;
  int start_col;
  size_t mark;
  size_t keyword_start;
  size_t keyword_end;
  size_t next_keyword_start;
  size_t content_start;
  size_t content_end;
  size_t docstring_content_type_start;
  size_t docstring_content_type_end;
  size_t query_start;
  size_t last_newline;
  size_t final_newline;
} lexer_state;

static VALUE mGherkin;
static VALUE mGherkinLexer;
static VALUE mCLexer;
static VALUE cI18nLexer;
static VALUE rb_eGherkinLexingError;

#define LEN(AT, P) (P - data - lexer->AT)
#define MARK(M, P) (lexer->M = (P) - data)
#define PTR_TO(P) (data + lexer->P)

#define STORE_KW_END_CON(EVENT) \
  store_multiline_kw_con(listener, # EVENT, \
    PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end - 1)), \
    PTR_TO(content_start), LEN(content_start, PTR_TO(content_end)), \
    lexer->current_line, lexer->start_col); \
    if (lexer->content_end != 0) { \
      p = PTR_TO(content_end - 1); \
    } \
    lexer->content_end = 0

#define STORE_ATTR(ATTR) \
    store_attr(listener, # ATTR, \
      PTR_TO(content_start), LEN(content_start, p), \
      lexer->line_number)


#line 254 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"


/** Data **/

#line 89 "ext/gherkin_lexer_vi/gherkin_lexer_vi.c"
static const char _lexer_actions[] = {
	0, 1, 0, 1, 1, 1, 2, 1, 
	3, 1, 4, 1, 5, 1, 6, 1, 
	7, 1, 8, 1, 9, 1, 10, 1, 
	11, 1, 12, 1, 13, 1, 16, 1, 
	17, 1, 18, 1, 19, 1, 20, 1, 
	21, 1, 22, 1, 23, 2, 1, 18, 
	2, 4, 5, 2, 13, 0, 2, 14, 
	15, 2, 17, 0, 2, 17, 2, 2, 
	17, 16, 2, 17, 19, 2, 18, 6, 
	2, 18, 7, 2, 18, 8, 2, 18, 
	9, 2, 18, 10, 2, 18, 16, 2, 
	20, 21, 2, 22, 0, 2, 22, 2, 
	2, 22, 16, 2, 22, 19, 3, 3, 
	14, 15, 3, 5, 14, 15, 3, 11, 
	14, 15, 3, 12, 14, 15, 3, 13, 
	14, 15, 3, 14, 15, 18, 3, 17, 
	0, 11, 3, 17, 14, 15, 4, 1, 
	14, 15, 18, 4, 4, 5, 14, 15, 
	4, 17, 0, 14, 15, 5, 17, 0, 
	11, 14, 15
};

static const short _lexer_key_offsets[] = {
	0, 0, 18, 19, 20, 37, 38, 39, 
	41, 43, 48, 53, 58, 63, 67, 71, 
	73, 74, 75, 76, 77, 78, 79, 80, 
	81, 82, 83, 84, 85, 86, 87, 88, 
	89, 91, 93, 98, 105, 110, 112, 113, 
	114, 115, 116, 117, 118, 119, 120, 121, 
	122, 123, 124, 125, 139, 141, 143, 145, 
	147, 149, 151, 153, 155, 157, 159, 161, 
	163, 165, 167, 169, 186, 187, 188, 189, 
	190, 191, 192, 193, 194, 195, 196, 197, 
	198, 199, 200, 201, 208, 210, 212, 214, 
	216, 218, 220, 222, 224, 226, 228, 230, 
	232, 233, 234, 235, 236, 237, 238, 239, 
	240, 241, 242, 243, 244, 245, 259, 261, 
	263, 265, 267, 269, 271, 273, 275, 277, 
	279, 281, 283, 285, 287, 289, 292, 294, 
	296, 298, 300, 302, 304, 306, 308, 310, 
	312, 314, 316, 318, 320, 322, 324, 326, 
	329, 331, 333, 335, 337, 339, 341, 343, 
	345, 347, 349, 352, 354, 356, 358, 361, 
	363, 365, 367, 369, 371, 373, 375, 377, 
	379, 381, 383, 385, 387, 389, 391, 393, 
	395, 397, 400, 403, 405, 407, 409, 411, 
	413, 415, 417, 419, 421, 423, 425, 426, 
	427, 428, 430, 431, 432, 433, 434, 435, 
	436, 437, 438, 439, 440, 441, 442, 443, 
	444, 458, 460, 462, 464, 466, 468, 470, 
	472, 474, 476, 478, 480, 482, 484, 486, 
	488, 490, 492, 494, 496, 498, 500, 502, 
	505, 507, 509, 511, 513, 515, 517, 519, 
	521, 523, 525, 527, 529, 531, 533, 535, 
	537, 539, 542, 545, 547, 549, 551, 553, 
	555, 557, 559, 561, 563, 565, 567, 569, 
	571, 573, 575, 577, 579, 581, 583, 585, 
	586, 587, 588, 589, 590, 591, 592, 593, 
	594, 595, 596, 597, 598, 599, 600, 601, 
	602, 604, 606, 607, 608, 609, 610, 611, 
	612, 613, 614, 615, 616, 617, 618, 619, 
	620, 621, 622, 623, 624, 625, 626, 627, 
	638, 640, 642, 644, 646, 648, 650, 652, 
	654, 656, 658, 660, 662, 664, 666, 668, 
	670, 672, 674, 676, 678, 680, 682, 684, 
	686, 688, 690, 692, 694, 696, 698, 700, 
	702, 704, 706, 708, 710, 713, 715, 717, 
	719, 721, 723, 725, 727, 729, 731, 733, 
	735, 737, 739, 741, 744, 746, 748, 750, 
	752, 754, 756, 758, 760, 762, 764, 766, 
	768, 770, 772, 775, 777, 779, 781, 783, 
	785, 787, 788, 789, 790, 791, 795, 801, 
	804, 806, 812, 829, 831, 833, 835, 837, 
	839, 841, 843, 846, 848, 850, 852, 854, 
	856, 858, 860, 862, 864, 866, 868, 871, 
	873, 875, 877, 880, 882, 884, 886, 888, 
	890, 892, 894, 896, 898, 900, 902, 904, 
	906, 908, 910, 912, 914, 916, 919, 922, 
	924, 926, 928, 930, 932, 934, 936, 938, 
	940, 942, 943, 944, 945, 946
};

static const char _lexer_trans_keys[] = {
	-17, 10, 32, 34, 35, 37, 42, 64, 
	66, 67, 68, 75, 78, 84, 86, 124, 
	9, 13, -69, -65, 10, 32, 34, 35, 
	37, 42, 64, 66, 67, 68, 75, 78, 
	84, 86, 124, 9, 13, 34, 34, 10, 
	13, 10, 13, 10, 32, 34, 9, 13, 
	10, 32, 34, 9, 13, 10, 32, 34, 
	9, 13, 10, 32, 34, 9, 13, 10, 
	32, 9, 13, 10, 32, 9, 13, 10, 
	13, 10, 95, 70, 69, 65, 84, 85, 
	82, 69, 95, 69, 78, 68, 95, 37, 
	32, 10, 13, 10, 13, 13, 32, 64, 
	9, 10, 9, 10, 13, 32, 64, 11, 
	12, 10, 32, 64, 9, 13, -31, 105, 
	-69, -111, 105, 32, 99, -31, -70, -93, 
	110, 104, 58, 10, 10, 10, 32, 35, 
	37, 42, 64, 66, 67, 75, 78, 84, 
	86, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	32, 10, 32, 34, 35, 37, 42, 64, 
	66, 67, 68, 75, 78, 84, 86, 124, 
	9, 13, 104, 111, -31, -69, -81, 32, 
	108, 105, -31, -69, -121, 117, 58, 10, 
	10, 10, 32, 35, 84, 124, 9, 13, 
	-61, 10, -83, 10, 10, 110, 10, 104, 
	10, 32, 10, 110, -60, 10, -125, 10, 
	10, 110, 10, 103, 10, 58, -31, 104, 
	-69, -117, 99, 104, 32, 98, -31, -70, 
	-93, 110, 58, 10, 10, 10, 32, 35, 
	37, 42, 64, 66, 67, 75, 78, 84, 
	86, 9, 13, 10, 95, 10, 70, 10, 
	69, 10, 65, 10, 84, 10, 85, 10, 
	82, 10, 69, 10, 95, 10, 69, 10, 
	78, 10, 68, 10, 95, 10, 37, 10, 
	32, -31, 10, 105, -69, 10, -111, 10, 
	10, 105, 10, 32, 10, 99, -31, 10, 
	-70, 10, -93, 10, 10, 110, 10, 104, 
	10, 58, -31, 10, -70, 10, -65, 10, 
	10, 116, 10, 104, 10, 111, -31, 10, 
	104, -69, 10, -117, 10, 10, 99, 10, 
	104, 10, 32, 10, 98, -31, 10, -70, 
	10, -93, 10, 10, 110, 10, 105, 117, 
	10, 110, 10, 103, 10, 32, 10, 107, 
	116, -31, 10, -61, 10, -84, 10, 10, 
	110, 10, 104, 10, 32, 10, 104, 10, 
	117, -31, 10, -69, 10, -111, 10, 10, 
	110, 10, 103, 10, 104, -58, 10, -80, 
	10, 10, 110, 10, 103, -61, 10, 104, 
	-84, -83, 10, 10, 110, 10, 104, 10, 
	32, 10, 110, -60, 10, -125, 10, -61, 
	10, -84, 10, -61, 10, -96, 10, 105, 
	117, 110, 103, 32, 107, 116, -31, -69, 
	-117, 99, 104, 32, 98, -31, -70, -93, 
	110, 58, 10, 10, 10, 32, 35, 37, 
	42, 64, 66, 67, 75, 78, 84, 86, 
	9, 13, 10, 95, 10, 70, 10, 69, 
	10, 65, 10, 84, 10, 85, 10, 82, 
	10, 69, 10, 95, 10, 69, 10, 78, 
	10, 68, 10, 95, 10, 37, 10, 32, 
	10, 105, -31, 10, -70, 10, -65, 10, 
	10, 116, 10, 104, 10, 111, -31, 10, 
	104, -69, 10, -117, 10, 10, 99, 10, 
	104, 10, 32, 10, 98, -31, 10, -70, 
	10, -93, 10, 10, 110, 10, 58, 10, 
	105, 10, 104, -58, 10, -80, 10, 10, 
	110, 10, 103, -61, 10, 104, -84, -83, 
	10, 10, 110, 10, 104, 10, 32, 10, 
	104, 10, 117, -31, 10, -69, 10, -111, 
	10, 10, 110, 10, 103, 10, 110, 10, 
	104, 10, 32, 10, 110, -60, 10, -125, 
	10, -61, 10, -84, 10, -61, 10, -96, 
	10, -61, -84, 110, 104, 32, 104, 117, 
	-31, -69, -111, 110, 103, 104, -58, -80, 
	110, 103, -61, 104, -84, -83, 110, 104, 
	32, 104, 117, -31, -69, -111, 110, 103, 
	110, 104, 32, 110, -60, -125, 110, 103, 
	58, 10, 10, 10, 32, 35, 37, 64, 
	66, 68, 75, 84, 9, 13, 10, 95, 
	10, 70, 10, 69, 10, 65, 10, 84, 
	10, 85, 10, 82, 10, 69, 10, 95, 
	10, 69, 10, 78, 10, 68, 10, 95, 
	10, 37, -31, 10, -69, 10, -111, 10, 
	10, 105, 10, 32, 10, 99, -31, 10, 
	-70, 10, -93, 10, 10, 110, 10, 104, 
	10, 58, -31, 10, -69, 10, -81, 10, 
	10, 32, 10, 108, 10, 105, -31, 10, 
	-69, 10, -121, 10, 10, 117, -31, 10, 
	104, -69, 10, -117, 10, 10, 99, 10, 
	104, 10, 32, 10, 98, -31, 10, -70, 
	10, -93, 10, 10, 110, 10, 117, 10, 
	110, 10, 103, 10, 32, 10, 107, 116, 
	-31, 10, -61, 10, -84, 10, 10, 110, 
	10, 104, 10, 32, 10, 104, 10, 117, 
	-31, 10, -69, 10, -111, 10, 10, 110, 
	10, 103, -61, 10, -84, -83, 10, 10, 
	110, 10, 104, 10, 32, 10, 110, -60, 
	10, -125, 10, -61, -84, -61, -96, 32, 
	124, 9, 13, 10, 32, 92, 124, 9, 
	13, 10, 92, 124, 10, 92, 10, 32, 
	92, 124, 9, 13, 10, 32, 34, 35, 
	37, 42, 64, 66, 67, 68, 75, 78, 
	84, 86, 124, 9, 13, 10, 105, -31, 
	10, -70, 10, -65, 10, 10, 116, 10, 
	104, 10, 111, -31, 10, 104, -69, 10, 
	-117, 10, 10, 99, 10, 104, 10, 32, 
	10, 98, -31, 10, -70, 10, -93, 10, 
	10, 110, 10, 58, 10, 105, 117, 10, 
	110, 10, 103, 10, 32, 10, 107, 116, 
	-31, 10, -61, 10, -84, 10, 10, 110, 
	10, 104, 10, 32, 10, 104, 10, 117, 
	-31, 10, -69, 10, -111, 10, 10, 110, 
	10, 103, 10, 104, -58, 10, -80, 10, 
	10, 110, 10, 103, -61, 10, 104, -84, 
	-83, 10, 10, 110, 10, 104, 10, 32, 
	10, 110, -60, 10, -125, 10, -61, 10, 
	-84, 10, -61, 10, -96, 10, -31, -70, 
	-65, 116, 0
};

static const char _lexer_single_lengths[] = {
	0, 16, 1, 1, 15, 1, 1, 2, 
	2, 3, 3, 3, 3, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 3, 5, 3, 2, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 12, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 15, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 5, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 12, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 1, 1, 
	1, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	12, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 3, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 3, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	2, 2, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 9, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 3, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 3, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 2, 4, 3, 
	2, 4, 15, 2, 2, 2, 2, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 3, 2, 
	2, 2, 3, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 3, 3, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 
	2, 1, 1, 1, 1, 0
};

static const char _lexer_range_lengths[] = {
	0, 1, 0, 0, 1, 0, 0, 0, 
	0, 1, 1, 1, 1, 1, 1, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 1, 1, 1, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 1, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 1, 1, 0, 
	0, 1, 1, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0
};

static const short _lexer_index_offsets[] = {
	0, 0, 18, 20, 22, 39, 41, 43, 
	46, 49, 54, 59, 64, 69, 73, 77, 
	80, 82, 84, 86, 88, 90, 92, 94, 
	96, 98, 100, 102, 104, 106, 108, 110, 
	112, 115, 118, 123, 130, 135, 138, 140, 
	142, 144, 146, 148, 150, 152, 154, 156, 
	158, 160, 162, 164, 178, 181, 184, 187, 
	190, 193, 196, 199, 202, 205, 208, 211, 
	214, 217, 220, 223, 240, 242, 244, 246, 
	248, 250, 252, 254, 256, 258, 260, 262, 
	264, 266, 268, 270, 277, 280, 283, 286, 
	289, 292, 295, 298, 301, 304, 307, 310, 
	313, 315, 317, 319, 321, 323, 325, 327, 
	329, 331, 333, 335, 337, 339, 353, 356, 
	359, 362, 365, 368, 371, 374, 377, 380, 
	383, 386, 389, 392, 395, 398, 402, 405, 
	408, 411, 414, 417, 420, 423, 426, 429, 
	432, 435, 438, 441, 444, 447, 450, 453, 
	457, 460, 463, 466, 469, 472, 475, 478, 
	481, 484, 487, 491, 494, 497, 500, 504, 
	507, 510, 513, 516, 519, 522, 525, 528, 
	531, 534, 537, 540, 543, 546, 549, 552, 
	555, 558, 562, 566, 569, 572, 575, 578, 
	581, 584, 587, 590, 593, 596, 599, 601, 
	603, 605, 608, 610, 612, 614, 616, 618, 
	620, 622, 624, 626, 628, 630, 632, 634, 
	636, 650, 653, 656, 659, 662, 665, 668, 
	671, 674, 677, 680, 683, 686, 689, 692, 
	695, 698, 701, 704, 707, 710, 713, 716, 
	720, 723, 726, 729, 732, 735, 738, 741, 
	744, 747, 750, 753, 756, 759, 762, 765, 
	768, 771, 775, 779, 782, 785, 788, 791, 
	794, 797, 800, 803, 806, 809, 812, 815, 
	818, 821, 824, 827, 830, 833, 836, 839, 
	841, 843, 845, 847, 849, 851, 853, 855, 
	857, 859, 861, 863, 865, 867, 869, 871, 
	873, 876, 879, 881, 883, 885, 887, 889, 
	891, 893, 895, 897, 899, 901, 903, 905, 
	907, 909, 911, 913, 915, 917, 919, 921, 
	932, 935, 938, 941, 944, 947, 950, 953, 
	956, 959, 962, 965, 968, 971, 974, 977, 
	980, 983, 986, 989, 992, 995, 998, 1001, 
	1004, 1007, 1010, 1013, 1016, 1019, 1022, 1025, 
	1028, 1031, 1034, 1037, 1040, 1044, 1047, 1050, 
	1053, 1056, 1059, 1062, 1065, 1068, 1071, 1074, 
	1077, 1080, 1083, 1086, 1090, 1093, 1096, 1099, 
	1102, 1105, 1108, 1111, 1114, 1117, 1120, 1123, 
	1126, 1129, 1132, 1136, 1139, 1142, 1145, 1148, 
	1151, 1154, 1156, 1158, 1160, 1162, 1166, 1172, 
	1176, 1179, 1185, 1202, 1205, 1208, 1211, 1214, 
	1217, 1220, 1223, 1227, 1230, 1233, 1236, 1239, 
	1242, 1245, 1248, 1251, 1254, 1257, 1260, 1264, 
	1267, 1270, 1273, 1277, 1280, 1283, 1286, 1289, 
	1292, 1295, 1298, 1301, 1304, 1307, 1310, 1313, 
	1316, 1319, 1322, 1325, 1328, 1331, 1335, 1339, 
	1342, 1345, 1348, 1351, 1354, 1357, 1360, 1363, 
	1366, 1369, 1371, 1373, 1375, 1377
};

static const short _lexer_trans_targs[] = {
	2, 4, 4, 5, 15, 17, 31, 34, 
	37, 68, 70, 95, 283, 288, 387, 389, 
	4, 0, 3, 0, 4, 0, 4, 4, 
	5, 15, 17, 31, 34, 37, 68, 70, 
	95, 283, 288, 387, 389, 4, 0, 6, 
	0, 7, 0, 9, 8, 8, 9, 8, 
	8, 10, 10, 11, 10, 10, 10, 10, 
	11, 10, 10, 10, 10, 12, 10, 10, 
	10, 10, 13, 10, 10, 4, 14, 14, 
	0, 4, 14, 14, 0, 4, 16, 15, 
	4, 0, 18, 0, 19, 0, 20, 0, 
	21, 0, 22, 0, 23, 0, 24, 0, 
	25, 0, 26, 0, 27, 0, 28, 0, 
	29, 0, 30, 0, 453, 0, 32, 0, 
	4, 16, 33, 4, 16, 33, 0, 0, 
	0, 0, 35, 36, 4, 36, 36, 34, 
	35, 35, 4, 36, 34, 36, 0, 38, 
	449, 0, 39, 0, 40, 0, 41, 0, 
	42, 0, 43, 0, 44, 0, 45, 0, 
	46, 0, 47, 0, 48, 0, 49, 0, 
	51, 50, 51, 50, 51, 51, 4, 52, 
	66, 4, 395, 400, 402, 432, 437, 447, 
	51, 50, 51, 53, 50, 51, 54, 50, 
	51, 55, 50, 51, 56, 50, 51, 57, 
	50, 51, 58, 50, 51, 59, 50, 51, 
	60, 50, 51, 61, 50, 51, 62, 50, 
	51, 63, 50, 51, 64, 50, 51, 65, 
	50, 51, 4, 50, 51, 67, 50, 4, 
	4, 5, 15, 17, 31, 34, 37, 68, 
	70, 95, 283, 288, 387, 389, 4, 0, 
	69, 0, 31, 0, 71, 0, 72, 0, 
	73, 0, 74, 0, 75, 0, 76, 0, 
	77, 0, 78, 0, 79, 0, 80, 0, 
	81, 0, 83, 82, 83, 82, 83, 83, 
	4, 84, 4, 83, 82, 85, 83, 82, 
	86, 83, 82, 83, 87, 82, 83, 88, 
	82, 83, 89, 82, 83, 90, 82, 91, 
	83, 82, 92, 83, 82, 83, 93, 82, 
	83, 94, 82, 83, 67, 82, 96, 189, 
	0, 97, 0, 98, 0, 99, 0, 100, 
	0, 101, 0, 102, 0, 103, 0, 104, 
	0, 105, 0, 106, 0, 107, 0, 109, 
	108, 109, 108, 109, 109, 4, 110, 124, 
	4, 125, 141, 143, 172, 177, 187, 109, 
	108, 109, 111, 108, 109, 112, 108, 109, 
	113, 108, 109, 114, 108, 109, 115, 108, 
	109, 116, 108, 109, 117, 108, 109, 118, 
	108, 109, 119, 108, 109, 120, 108, 109, 
	121, 108, 109, 122, 108, 109, 123, 108, 
	109, 4, 108, 109, 67, 108, 126, 109, 
	137, 108, 127, 109, 108, 128, 109, 108, 
	109, 129, 108, 109, 130, 108, 109, 131, 
	108, 132, 109, 108, 133, 109, 108, 134, 
	109, 108, 109, 135, 108, 109, 136, 108, 
	109, 67, 108, 138, 109, 108, 139, 109, 
	108, 140, 109, 108, 109, 124, 108, 109, 
	142, 108, 109, 124, 108, 144, 109, 154, 
	108, 145, 109, 108, 146, 109, 108, 109, 
	147, 108, 109, 148, 108, 109, 149, 108, 
	109, 150, 108, 151, 109, 108, 152, 109, 
	108, 153, 109, 108, 109, 136, 108, 109, 
	124, 155, 108, 109, 156, 108, 109, 157, 
	108, 109, 158, 108, 109, 159, 160, 108, 
	144, 109, 108, 161, 109, 108, 162, 109, 
	108, 109, 163, 108, 109, 164, 108, 109, 
	165, 108, 109, 166, 108, 109, 167, 108, 
	168, 109, 108, 169, 109, 108, 170, 109, 
	108, 109, 171, 108, 109, 136, 108, 109, 
	173, 108, 174, 109, 108, 175, 109, 108, 
	109, 176, 108, 109, 124, 108, 178, 109, 
	185, 108, 162, 179, 109, 108, 109, 180, 
	108, 109, 181, 108, 109, 182, 108, 109, 
	183, 108, 184, 109, 108, 170, 109, 108, 
	186, 109, 108, 124, 109, 108, 188, 109, 
	108, 124, 109, 108, 31, 190, 0, 191, 
	0, 192, 0, 193, 0, 194, 271, 0, 
	195, 0, 196, 0, 197, 0, 198, 0, 
	199, 0, 200, 0, 201, 0, 202, 0, 
	203, 0, 204, 0, 205, 0, 206, 0, 
	208, 207, 208, 207, 208, 208, 4, 209, 
	223, 4, 224, 229, 231, 244, 249, 269, 
	208, 207, 208, 210, 207, 208, 211, 207, 
	208, 212, 207, 208, 213, 207, 208, 214, 
	207, 208, 215, 207, 208, 216, 207, 208, 
	217, 207, 208, 218, 207, 208, 219, 207, 
	208, 220, 207, 208, 221, 207, 208, 222, 
	207, 208, 4, 207, 208, 67, 207, 208, 
	225, 207, 226, 208, 207, 227, 208, 207, 
	228, 208, 207, 208, 223, 207, 208, 230, 
	207, 208, 223, 207, 232, 208, 243, 207, 
	233, 208, 207, 234, 208, 207, 208, 235, 
	207, 208, 236, 207, 208, 237, 207, 208, 
	238, 207, 239, 208, 207, 240, 208, 207, 
	241, 208, 207, 208, 242, 207, 208, 67, 
	207, 208, 223, 207, 208, 245, 207, 246, 
	208, 207, 247, 208, 207, 208, 248, 207, 
	208, 223, 207, 250, 208, 267, 207, 251, 
	261, 208, 207, 208, 252, 207, 208, 253, 
	207, 208, 254, 207, 208, 255, 207, 208, 
	256, 207, 257, 208, 207, 258, 208, 207, 
	259, 208, 207, 208, 260, 207, 208, 242, 
	207, 208, 262, 207, 208, 263, 207, 208, 
	264, 207, 208, 265, 207, 266, 208, 207, 
	259, 208, 207, 268, 208, 207, 223, 208, 
	207, 270, 208, 207, 223, 208, 207, 272, 
	0, 273, 0, 274, 0, 275, 0, 276, 
	0, 277, 0, 278, 0, 279, 0, 280, 
	0, 281, 0, 282, 0, 205, 0, 284, 
	0, 285, 0, 286, 0, 287, 0, 31, 
	0, 289, 385, 0, 290, 300, 0, 291, 
	0, 292, 0, 293, 0, 294, 0, 295, 
	0, 296, 0, 297, 0, 298, 0, 299, 
	0, 106, 0, 301, 0, 302, 0, 303, 
	0, 304, 0, 305, 0, 306, 0, 307, 
	0, 308, 0, 309, 0, 311, 310, 311, 
	310, 311, 311, 4, 312, 4, 326, 338, 
	348, 377, 311, 310, 311, 313, 310, 311, 
	314, 310, 311, 315, 310, 311, 316, 310, 
	311, 317, 310, 311, 318, 310, 311, 319, 
	310, 311, 320, 310, 311, 321, 310, 311, 
	322, 310, 311, 323, 310, 311, 324, 310, 
	311, 325, 310, 311, 4, 310, 327, 311, 
	310, 328, 311, 310, 329, 311, 310, 311, 
	330, 310, 311, 331, 310, 311, 332, 310, 
	333, 311, 310, 334, 311, 310, 335, 311, 
	310, 311, 336, 310, 311, 337, 310, 311, 
	67, 310, 339, 311, 310, 340, 311, 310, 
	341, 311, 310, 311, 342, 310, 311, 343, 
	310, 311, 344, 310, 345, 311, 310, 346, 
	311, 310, 347, 311, 310, 311, 337, 310, 
	349, 311, 359, 310, 350, 311, 310, 351, 
	311, 310, 311, 352, 310, 311, 353, 310, 
	311, 354, 310, 311, 355, 310, 356, 311, 
	310, 357, 311, 310, 358, 311, 310, 311, 
	337, 310, 311, 360, 310, 311, 361, 310, 
	311, 362, 310, 311, 363, 310, 311, 364, 
	365, 310, 349, 311, 310, 366, 311, 310, 
	367, 311, 310, 311, 368, 310, 311, 369, 
	310, 311, 370, 310, 311, 371, 310, 311, 
	372, 310, 373, 311, 310, 374, 311, 310, 
	375, 311, 310, 311, 376, 310, 311, 337, 
	310, 378, 311, 310, 367, 379, 311, 310, 
	311, 380, 310, 311, 381, 310, 311, 382, 
	310, 311, 383, 310, 384, 311, 310, 375, 
	311, 310, 386, 0, 31, 0, 388, 0, 
	31, 0, 389, 390, 389, 0, 394, 393, 
	392, 390, 393, 391, 0, 392, 390, 391, 
	0, 392, 391, 394, 393, 392, 390, 393, 
	391, 394, 394, 5, 15, 17, 31, 34, 
	37, 68, 70, 95, 283, 288, 387, 389, 
	394, 0, 51, 396, 50, 397, 51, 50, 
	398, 51, 50, 399, 51, 50, 51, 66, 
	50, 51, 401, 50, 51, 66, 50, 403, 
	51, 414, 50, 404, 51, 50, 405, 51, 
	50, 51, 406, 50, 51, 407, 50, 51, 
	408, 50, 51, 409, 50, 410, 51, 50, 
	411, 51, 50, 412, 51, 50, 51, 413, 
	50, 51, 67, 50, 51, 66, 415, 50, 
	51, 416, 50, 51, 417, 50, 51, 418, 
	50, 51, 419, 420, 50, 403, 51, 50, 
	421, 51, 50, 422, 51, 50, 51, 423, 
	50, 51, 424, 50, 51, 425, 50, 51, 
	426, 50, 51, 427, 50, 428, 51, 50, 
	429, 51, 50, 430, 51, 50, 51, 431, 
	50, 51, 413, 50, 51, 433, 50, 434, 
	51, 50, 435, 51, 50, 51, 436, 50, 
	51, 66, 50, 438, 51, 445, 50, 422, 
	439, 51, 50, 51, 440, 50, 51, 441, 
	50, 51, 442, 50, 51, 443, 50, 444, 
	51, 50, 430, 51, 50, 446, 51, 50, 
	66, 51, 50, 448, 51, 50, 66, 51, 
	50, 450, 0, 451, 0, 452, 0, 31, 
	0, 0, 0
};

static const unsigned char _lexer_trans_actions[] = {
	0, 54, 0, 5, 1, 0, 29, 1, 
	29, 29, 29, 29, 29, 29, 29, 35, 
	0, 43, 0, 43, 0, 43, 54, 0, 
	5, 1, 0, 29, 1, 29, 29, 29, 
	29, 29, 29, 29, 35, 0, 43, 0, 
	43, 0, 43, 139, 48, 9, 106, 11, 
	0, 134, 45, 45, 45, 3, 122, 33, 
	33, 33, 0, 122, 33, 33, 33, 0, 
	122, 33, 0, 33, 0, 102, 7, 7, 
	43, 54, 0, 0, 43, 114, 25, 0, 
	54, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	149, 126, 57, 110, 23, 0, 43, 43, 
	43, 43, 0, 27, 118, 27, 27, 51, 
	27, 0, 54, 0, 1, 0, 43, 0, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 54, 0, 72, 33, 
	84, 72, 84, 84, 84, 84, 84, 84, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 15, 0, 54, 15, 0, 130, 
	31, 60, 57, 31, 63, 57, 63, 63, 
	63, 63, 63, 63, 63, 66, 31, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 144, 57, 54, 0, 54, 0, 
	81, 84, 81, 0, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 54, 21, 0, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 144, 
	57, 54, 0, 54, 0, 75, 33, 84, 
	75, 84, 84, 84, 84, 84, 84, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 17, 0, 54, 17, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 17, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 43, 0, 43, 0, 43, 
	144, 57, 54, 0, 54, 0, 78, 33, 
	84, 78, 84, 84, 84, 84, 84, 84, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 19, 0, 54, 19, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 19, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0, 43, 0, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 43, 0, 43, 144, 57, 54, 
	0, 54, 0, 69, 33, 69, 84, 84, 
	84, 84, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 13, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	13, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 54, 
	0, 0, 54, 0, 0, 54, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 54, 0, 0, 
	54, 0, 0, 43, 0, 43, 0, 43, 
	0, 43, 0, 0, 0, 43, 54, 37, 
	37, 87, 37, 37, 43, 0, 39, 0, 
	43, 0, 0, 54, 0, 0, 39, 0, 
	0, 54, 0, 93, 90, 41, 96, 90, 
	96, 96, 96, 96, 96, 96, 96, 99, 
	0, 43, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 54, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 15, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 54, 0, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 54, 0, 0, 
	54, 0, 0, 0, 54, 0, 0, 0, 
	0, 54, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 0, 
	54, 0, 0, 54, 0, 0, 54, 0, 
	0, 54, 0, 0, 54, 0, 0, 54, 
	0, 0, 43, 0, 43, 0, 43, 0, 
	43, 0, 0
};

static const unsigned char _lexer_eof_actions[] = {
	0, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43
};

static const int lexer_start = 1;
static const int lexer_first_final = 453;
static const int lexer_error = 0;

static const int lexer_en_main = 1;


#line 258 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"

static VALUE 
unindent(VALUE con, int start_col)
{
  VALUE re;
  // Gherkin will crash gracefully if the string representation of start_col pushes the pattern past 32 characters
  char pat[32]; 
  snprintf(pat, 32, "^[\t ]{0,%d}", start_col); 
  re = rb_reg_regcomp(rb_str_new2(pat));
  rb_funcall(con, rb_intern("gsub!"), 2, re, rb_str_new2(""));

  return Qnil;

}

static void 
store_kw_con(VALUE listener, const char * event_name, 
             const char * keyword_at, size_t keyword_length, 
             const char * at,         size_t length, 
             int current_line)
{
  VALUE con = Qnil, kw = Qnil;
  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);
  rb_funcall(con, rb_intern("strip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 3, kw, con, INT2FIX(current_line)); 
}

static void
store_multiline_kw_con(VALUE listener, const char * event_name,
                      const char * keyword_at, size_t keyword_length,
                      const char * at,         size_t length,
                      int current_line, int start_col)
{
  VALUE split;
  VALUE con = Qnil, kw = Qnil, name = Qnil, desc = Qnil;

  kw = ENCODED_STR_NEW(keyword_at, keyword_length);
  con = ENCODED_STR_NEW(at, length);

  unindent(con, start_col);
  
  split = rb_str_split(con, "\n");

  name = rb_funcall(split, rb_intern("shift"), 0);
  desc = rb_ary_join(split, rb_str_new2( "\n" ));

  if( name == Qnil ) 
  {
    name = rb_str_new2("");
  }
  if( rb_funcall(desc, rb_intern("size"), 0) == 0) 
  {
    desc = rb_str_new2("");
  }
  rb_funcall(name, rb_intern("strip!"), 0);
  rb_funcall(desc, rb_intern("rstrip!"), 0);
  rb_funcall(listener, rb_intern(event_name), 4, kw, name, desc, INT2FIX(current_line)); 
}

static void 
store_attr(VALUE listener, const char * attr_type,
           const char * at, size_t length, 
           int line)
{
  VALUE val = ENCODED_STR_NEW(at, length);
  rb_funcall(listener, rb_intern(attr_type), 2, val, INT2FIX(line));
}
static void 
store_docstring_content(VALUE listener, 
          int start_col, 
          const char *type_at, size_t type_length,
          const char *at, size_t length, 
          int current_line)
{
  VALUE re2;
  VALUE unescape_escaped_quotes;
  VALUE con = ENCODED_STR_NEW(at, length);
  VALUE con_type = ENCODED_STR_NEW(type_at, type_length);

  unindent(con, start_col);

  re2 = rb_reg_regcomp(rb_str_new2("\r\\Z"));
  unescape_escaped_quotes = rb_reg_regcomp(rb_str_new2("\\\\\"\\\\\"\\\\\""));
  rb_funcall(con, rb_intern("sub!"), 2, re2, rb_str_new2(""));
  rb_funcall(con_type, rb_intern("strip!"), 0);
  rb_funcall(con, rb_intern("gsub!"), 2, unescape_escaped_quotes, rb_str_new2("\"\"\""));
  rb_funcall(listener, rb_intern("doc_string"), 3, con_type, con, INT2FIX(current_line));
}
static void 
raise_lexer_error(const char * at, int line)
{ 
  rb_raise(rb_eGherkinLexingError, "Lexing error on line %d: '%s'. See http://wiki.github.com/cucumber/gherkin/lexingerror for more information.", line, at);
}

static void lexer_init(lexer_state *lexer) {
  lexer->content_start = 0;
  lexer->content_end = 0;
  lexer->content_len = 0;
  lexer->docstring_content_type_start = 0;
  lexer->docstring_content_type_end = 0;
  lexer->mark = 0;
  lexer->keyword_start = 0;
  lexer->keyword_end = 0;
  lexer->next_keyword_start = 0;
  lexer->line_number = 1;
  lexer->last_newline = 0;
  lexer->final_newline = 0;
  lexer->start_col = 0;
}

static VALUE CLexer_alloc(VALUE klass)
{
  VALUE obj;
  lexer_state *lxr = ALLOC(lexer_state);
  lexer_init(lxr);

  obj = Data_Wrap_Struct(klass, NULL, -1, lxr);

  return obj;
}

static VALUE CLexer_init(VALUE self, VALUE listener)
{
  lexer_state *lxr; 
  rb_iv_set(self, "@listener", listener);
  
  lxr = NULL;
  DATA_GET(self, lexer_state, lxr);
  lexer_init(lxr);
  
  return self;
}

static VALUE CLexer_scan(VALUE self, VALUE input)
{
  VALUE input_copy;
  char *data;
  size_t len;
  VALUE listener = rb_iv_get(self, "@listener");

  lexer_state *lexer;
  lexer = NULL;
  DATA_GET(self, lexer_state, lexer);

  input_copy = rb_str_dup(input);

  rb_str_append(input_copy, rb_str_new2("\n%_FEATURE_END_%"));
  data = RSTRING_PTR(input_copy);
  len = RSTRING_LEN(input_copy);
  
  if (len == 0) { 
    rb_raise(rb_eGherkinLexingError, "No content to lex.");
  } else {

    const char *p, *pe, *eof;
    int cs = 0;
    
    VALUE current_row = Qnil;

    p = data;
    pe = data + len;
    eof = pe;
    
    assert(*pe == '\0' && "pointer does not end on NULL");
    
    
#line 1062 "ext/gherkin_lexer_vi/gherkin_lexer_vi.c"
	{
	cs = lexer_start;
	}

#line 425 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
    
#line 1069 "ext/gherkin_lexer_vi/gherkin_lexer_vi.c"
	{
	int _klen;
	unsigned int _trans;
	const char *_acts;
	unsigned int _nacts;
	const char *_keys;

	if ( p == pe )
		goto _test_eof;
	if ( cs == 0 )
		goto _out;
_resume:
	_keys = _lexer_trans_keys + _lexer_key_offsets[cs];
	_trans = _lexer_index_offsets[cs];

	_klen = _lexer_single_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + _klen - 1;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( (*p) < *_mid )
				_upper = _mid - 1;
			else if ( (*p) > *_mid )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				goto _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _lexer_range_lengths[cs];
	if ( _klen > 0 ) {
		const char *_lower = _keys;
		const char *_mid;
		const char *_upper = _keys + (_klen<<1) - 2;
		while (1) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( (*p) < _mid[0] )
				_upper = _mid - 2;
			else if ( (*p) > _mid[1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				goto _match;
			}
		}
		_trans += _klen;
	}

_match:
	cs = _lexer_trans_targs[_trans];

	if ( _lexer_trans_actions[_trans] == 0 )
		goto _again;

	_acts = _lexer_actions + _lexer_trans_actions[_trans];
	_nacts = (unsigned int) *_acts++;
	while ( _nacts-- > 0 )
	{
		switch ( *_acts++ )
		{
	case 0:
#line 83 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
		MARK(content_start, p);
    lexer->current_line = lexer->line_number;
    lexer->start_col = lexer->content_start - lexer->last_newline - (lexer->keyword_end - lexer->keyword_start) + 2;
  }
	break;
	case 1:
#line 89 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    MARK(content_start, p);
  }
	break;
	case 2:
#line 93 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    lexer->current_line = lexer->line_number;
    lexer->start_col = p - data - lexer->last_newline;
  }
	break;
	case 3:
#line 98 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    int len = LEN(content_start, PTR_TO(final_newline));
    int type_len = LEN(docstring_content_type_start, PTR_TO(docstring_content_type_end));

    if (len < 0) len = 0;
    if (type_len < 0) len = 0;

    store_docstring_content(listener, lexer->start_col, PTR_TO(docstring_content_type_start), type_len, PTR_TO(content_start), len, lexer->current_line);
  }
	break;
	case 4:
#line 108 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{ 
    MARK(docstring_content_type_start, p);
  }
	break;
	case 5:
#line 112 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{ 
    MARK(docstring_content_type_end, p);
  }
	break;
	case 6:
#line 116 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    STORE_KW_END_CON(feature);
  }
	break;
	case 7:
#line 120 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    STORE_KW_END_CON(background);
  }
	break;
	case 8:
#line 124 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    STORE_KW_END_CON(scenario);
  }
	break;
	case 9:
#line 128 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    STORE_KW_END_CON(scenario_outline);
  }
	break;
	case 10:
#line 132 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    STORE_KW_END_CON(examples);
  }
	break;
	case 11:
#line 136 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    store_kw_con(listener, "step",
      PTR_TO(keyword_start), LEN(keyword_start, PTR_TO(keyword_end)),
      PTR_TO(content_start), LEN(content_start, p), 
      lexer->current_line);
  }
	break;
	case 12:
#line 143 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    STORE_ATTR(comment);
    lexer->mark = 0;
  }
	break;
	case 13:
#line 148 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    STORE_ATTR(tag);
    lexer->mark = 0;
  }
	break;
	case 14:
#line 153 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    lexer->line_number += 1;
    MARK(final_newline, p);
  }
	break;
	case 15:
#line 158 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    MARK(last_newline, p + 1);
  }
	break;
	case 16:
#line 162 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    if (lexer->mark == 0) {
      MARK(mark, p);
    }
  }
	break;
	case 17:
#line 168 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    MARK(keyword_end, p);
    MARK(keyword_start, PTR_TO(mark));
    MARK(content_start, p + 1);
    lexer->mark = 0;
  }
	break;
	case 18:
#line 175 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    MARK(content_end, p);
  }
	break;
	case 19:
#line 179 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    p = p - 1;
    lexer->current_line = lexer->line_number;
    current_row = rb_ary_new();
  }
	break;
	case 20:
#line 185 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
		MARK(content_start, p);
  }
	break;
	case 21:
#line 189 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    VALUE re_pipe, re_newline, re_backslash;
    VALUE con = ENCODED_STR_NEW(PTR_TO(content_start), LEN(content_start, p));
    rb_funcall(con, rb_intern("strip!"), 0);
    re_pipe      = rb_reg_regcomp(rb_str_new2("\\\\\\|"));
    re_newline   = rb_reg_regcomp(rb_str_new2("\\\\n"));
    re_backslash = rb_reg_regcomp(rb_str_new2("\\\\\\\\"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_pipe,      rb_str_new2("|"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_newline,   rb_str_new2("\n"));
    rb_funcall(con, rb_intern("gsub!"), 2, re_backslash, rb_str_new2("\\"));

    rb_ary_push(current_row, con);
  }
	break;
	case 22:
#line 203 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    rb_funcall(listener, rb_intern("row"), 2, current_row, INT2FIX(lexer->current_line));
  }
	break;
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1359 "ext/gherkin_lexer_vi/gherkin_lexer_vi.c"
		}
	}

_again:
	if ( cs == 0 )
		goto _out;
	if ( ++p != pe )
		goto _resume;
	_test_eof: {}
	if ( p == eof )
	{
	const char *__acts = _lexer_actions + _lexer_eof_actions[cs];
	unsigned int __nacts = (unsigned int) *__acts++;
	while ( __nacts-- > 0 ) {
		switch ( *__acts++ ) {
	case 23:
#line 207 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"
	{
    int line;
    if (cs < lexer_first_final) {
      size_t count = 0;
      VALUE newstr_val;
      char *newstr;
      int newstr_count = 0;        
      size_t len;
      const char *buff;
      if (lexer->last_newline != 0) {
        len = LEN(last_newline, eof);
        buff = PTR_TO(last_newline);
      } else {
        len = strlen(data);
        buff = data;
      }

      // Allocate as a ruby string so that it gets cleaned up by GC
      newstr_val = rb_str_new(buff, len);
      newstr = RSTRING_PTR(newstr_val);


      for (count = 0; count < len; count++) {
        if(buff[count] == 10) {
          newstr[newstr_count] = '\0'; // terminate new string at first newline found
          break;
        } else {
          if (buff[count] == '%') {
            newstr[newstr_count++] = buff[count];
            newstr[newstr_count] = buff[count];
          } else {
            newstr[newstr_count] = buff[count];
          }
        }
        newstr_count++;
      }

      line = lexer->line_number;
      lexer_init(lexer); // Re-initialize so we can scan again with the same lexer
      raise_lexer_error(newstr, line);
    } else {
      rb_funcall(listener, rb_intern("eof"), 0);
    }
  }
	break;
#line 1422 "ext/gherkin_lexer_vi/gherkin_lexer_vi.c"
		}
	}
	}

	_out: {}
	}

#line 426 "/Users/ahellesoy/github/gherkin/tasks/../ragel/i18n/vi.c.rl"

    assert(p <= pe && "data overflow after parsing execute");
    assert(lexer->content_start <= len && "content starts after data end");
    assert(lexer->mark < len && "mark is after data end");
    
    // Reset lexer by re-initializing the whole thing
    lexer_init(lexer);

    if (cs == lexer_error) {
      rb_raise(rb_eGherkinLexingError, "Invalid format, lexing fails.");
    } else {
      return Qtrue;
    }
  }
}

void Init_gherkin_lexer_vi()
{
  mGherkin = rb_define_module("Gherkin");
  mGherkinLexer = rb_define_module_under(mGherkin, "Lexer");
  rb_eGherkinLexingError = rb_const_get(mGherkinLexer, rb_intern("LexingError"));

  mCLexer = rb_define_module_under(mGherkin, "CLexer");
  cI18nLexer = rb_define_class_under(mCLexer, "Vi", rb_cObject);
  rb_define_alloc_func(cI18nLexer, CLexer_alloc);
  rb_define_method(cI18nLexer, "initialize", CLexer_init, 1);
  rb_define_method(cI18nLexer, "scan", CLexer_scan, 1);
}

