#include "../matrixutils/mask.h"
#include <rumba/arghandler.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrixio.h>
#include <rumba/jacobi.h>


using namespace RUMBA;
using RUMBA::Argument;

void usage()
{
	std::cerr << "Usage: threshold-mask -i infile -o outfile \n"
		"[[-u|--upper]  n1] [[-l|--lower] n2]\n"
		<< std::endl;
}


Argument myArgs[] = 
{
	Argument("vectors",RUMBA::ALPHA,'e',"",false),
	Argument()
};

int main(int argc,char** argv)
{
	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setRequiredDefaultArg("outfile");


	std::string infile,outfile,evecfile;
	try {
		RUMBA::ArgHandler argh ( argc , argv );

		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}

		argh.arg("infile",infile);
		argh.arg("outfile",outfile);
		argh.arg("vectors",evecfile);


	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}

	
	try 
	{
		RUMBA::ManifoldMatrix in = RUMBA::manifoldMatrixReadHack(infile.c_str());
		RUMBA::ManifoldMatrix eVec = RUMBA::jacobi(in);
		if (!evecfile.empty())
			manifoldMatrixWriteHack ( eVec, evecfile.c_str() );
	}
	catch (RUMBA::Exception& e)
	{
		std::cerr << "Fatal error: " << e.error() << std::endl;
		exit(2);
	}
	
	return 0;
}
