#include <iostream>
#include <rumba/arghandler.h>
#include <rumba/manifoldmatrix.h>
#include <rumba/matrixio.h>

using namespace RUMBA;

void usage()
{
	cerr << "Usage: glmfit -i infile -o outfile --design file [--resid file]\n";
}


Argument myArgs [] = {
	Argument ( "design", RUMBA::ALPHA, 'd', Splodge(), true ),
	Argument ( "resid", RUMBA::ALPHA, 'r', Splodge(), false ),
	Argument()
};

int main(int argc,char** argv)
{
	std::string infile , outfile , design , resid;

	ArgHandler::setRequiredDefaultArg("infile");

	try {
		ArgHandler argh ( argc , argv );
		if ( argh.arg("help") )
		{
		usage();
		exit(0);
		}
		argh.arg ( "infile" , infile );
		argh.arg ( "outfile" , outfile );
		argh.arg ( "design" , design );
		argh.arg ( "resid" , resid );
	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		cerr << "Invalid argument: " << s.error() << endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		cerr << "Duplicate argument: " << s.error() << endl;
	}
	catch (RUMBA::MissingArgumentException& s)
	{
		cerr << "Missing argument: " << s.error() << endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		cerr << "Error: " << s.error() << endl;
	}
	catch (Exception& s)
	{
		cerr << "Exception:" << s.error() << endl;
	}

	//ManifoldMatrix mDesign = readManifoldMatrix(design.c_str());	
	//ManifoldMatrix mDesignInverse = pseudoInvert( mDesign );
	ManifoldMatrix mDesign = makeMatrix(readManifoldMatrix(design.c_str()));	
	ManifoldMatrix mDesignInverse = pseudoInvert( mDesign.M );

	Manifold<double> M(infile.c_str());
	ManifoldMatrix mM ( makeMatrix ( M ) );
	ManifoldMatrix result = mDesignInverse * mM.transpose();

	if (outfile.empty()) {
		//writeManifoldMatrix( result );
		writeManifoldMatrix( result.M , cout );
	}
	else result.M.save(outfile.c_str());

	if ( !resid.empty() )
	{
	ManifoldMatrix rfm = identityMatrix(M.timepoints()) - mDesign * mDesignInverse;
	ManifoldMatrix residual = rfm * mM.transpose();
	residual.M.save( resid.c_str() );
	}
}
