#include <rumba/manifoldmatrix.h>
#include <rumba/arghandler.h>

#include "readmatrix.h"

using namespace RUMBA;

Argument myArgs [] = {
	Argument ( "design", RUMBA::ALPHA ),
	Argument()
};

ManifoldMatrix pseudoInverse(Manifold<double>& M)
{
	int rows = M.width() * M.height() * M.depth();
	Manifold<double> N = M.copy();
	ManifoldMatrix mN (M,M.begin(),rows,M.timepoints(),false);
	ManifoldMatrix mNt (M,M.begin(),rows,M.timepoints(),true);

	ManifoldMatrix tmp = mNt * mN;	
	ManifoldMatrix result = invert ( tmp ) * mNt;
	return result;
}

int main(int argc,char** argv)
{
	std::string infile, outfile, design;
	ArgHandler argh(argc,argv);
	argh.arg("infile",infile);
	argh.arg("outfile",outfile);
	argh.arg("design",design);

	if ( design.empty() )
	{
		cerr << "You didn't give a design matrix, naughty naughty persun\n";
		exit(1);
	}
	

	ManifoldMatrix mDesign = readManifoldMatrix(design.c_str());	
	Manifold<double> M(infile.c_str());

	ManifoldMatrix mPseudo = pseudoInverse( mDesign );
	ManifoldMatrix mM (M, M.width() * M.height() * M.depth(), M.timepoints(), false);

//-----------------------
	mDesign.transpose();
	mM.transpose();
//-----------------------

	ManifoldMatrix result = mPseudo * mDesign * mM;
//	ManifoldMatrix result = mPseudo * mDesign.transpose() * mM.transpose();

//	ManifoldMatrix 	residual = identityMatrix(M.timepoints()) - mDesign * mPseudo * mDesign.transpose();

	result.M.save(outfile.c_str());

	return 0;
}
