#include <iostream>
#include <fstream>
#include <string>
#include <sstream>

#include <rumba/manifold.h>
#include <rumba/point.hpp>

using std::string;
using std::ifstream;

bool hasDouble(std::string);

int countcolumns(const char* filename)
{
	std::string s;
	ifstream fin ( filename );
	int count=0;
	double tmp;

	while (!hasDouble(s))
		getline(fin,s);	
	std::istringstream in(s);

	while (in>>tmp)
		++count;

	return count;
}

bool hasDouble(std::string s)
{
	double tmp;
	std::istringstream in(s);
	if (in>>tmp)
		return true;
	else
		return false;
}

int countrows(const char* filename)
{
	int count=0;
	std::string s;
	ifstream fin(filename);
	while (getline(fin,s))
	{
		// ignore blank lines
		if ( hasDouble(s))
			++count;
	}
	return count;
}

template <class iterator>
bool readVector( iterator it, const char* filename, int nelts )
{
	double tmp;
	std::ifstream fin(filename);

	/*	Perform one pass for validation	*/
	for (int i=0; i<nelts; ++i)
		fin>>tmp;
	if(!fin)
		return false;

	/*	Now get the data	*/
	fin.seekg(0,std::ios::beg);
	for (int i=0; i<nelts; ++i)
		fin>>*it++;

	return true;
}

RUMBA::Manifold<double> readManifoldMatrix(const char* filename)
{
	bool ok;
	int columns = countcolumns(filename);
	int rows = countrows(filename);

	RUMBA::Manifold<double> M(intPoint( 1,1,1,columns*rows));
	ok = readVector (M.begin(),filename,columns*rows);

	return M;
}

#ifdef TEST_READ_MATRIX
int main()
{
	cout << countcolumns("test.txt") << endl;
	cout << countrows("test.txt") << endl;

	RUMBA::Manifold<double> M = readManifoldMatrix("test.txt");
	M.save("test.img");

	return 0;
}

#endif
