#ifndef RUMBA_STATS_H
#define RUMBA_STATS_H

#include <rumba/baseManifold.h>
#include <rumba/point.hpp>
#include <rumba/exception.h>

namespace RUMBA
{

class StatFunctor
{
public:
	StatFunctor() : ptr(0), sumsq(0),sum(0) {}
	StatFunctor(const RUMBA::BaseManifold* A) 
	: ptr(A), Origin(0,0,0,0), Extent(A->extent())
	{
		if (! Extent.x()*Extent.y()*Extent.z()*Extent.t())
		{
			throw RUMBA::Exception("zero extents in StatFunctor constructor");
		}
		compute();	
	}
	StatFunctor(
		const RUMBA::BaseManifold* A, const intPoint& o, const intPoint& e
	) 
	: ptr(A), Origin(o), Extent(e) 
	{
		compute();
	}

	void setManifold(const RUMBA::BaseManifold* A);
	void compute();
	double mean() const;
	double sumSquare() const;
	double variance() const;
	double sd() const;
	double max() const;
	double min() const;
	virtual ~StatFunctor(){}


private:
	const RUMBA::BaseManifold* ptr;
	double sumsq, sum;
	double Max, Min;
	intPoint Origin, Extent;

	StatFunctor(const StatFunctor&);
	StatFunctor& operator=(const StatFunctor&);


};

}
#endif
