#include "t_dist.h"
#include <rumba/numerics.h>

using namespace RUMBA;

namespace { double cf (double a,double b, double x); }

double RUMBA::t_to_p ( double t, double nu )
{
	return 1 - incomplete_beta(nu/2, 0.5, nu/(nu+t*t));
}

double RUMBA::f_to_p (double F, double nu1, double nu2 )
{
	return incomplete_beta(nu2/2,nu1/2,nu2/(nu1+nu2*F));
}


double RUMBA::incomplete_beta (double a, double b, double x)
{
	// c = x^a(1-x)^b / (B(a,b))
	double c = 
		exp(
				0 - gamma_log (b) - gamma_log(a) + gamma_log(a+b)
				+ a * log(x) + b * log(1.0-x)
			);

	if ( x < (a+1.0)/(a+b+2.0) )
		return  (c/a) * cf(a,b,x);
	else
		return 1.0-(c/b) * cf (b,a,1.0-x);

}
	
namespace 
{
	// nr p171
	double cf (double A, double B, double X)
	{
		const int maxcount = 100;
		const double epsilon = 1e-10;
		const double tiny = 10e-30;

		const double b = 1; //b_j
		double a;
		double c = 1;
		double d = 1-(A+B)*X/(A+1); d = 1/d;
		double delta = 2;
		double f = d; 
	
		int tmp;	
		for ( int j = 1; j < maxcount && fabs(delta-1)>epsilon; ++j )
		{

			a = j*(B-j)*X / ((A+2*j-1)*(A+2*j));

			d *= a; d += b;
			if ( d == 0 ) d = tiny;
			c = a/c; c += b;
			if ( c == 0 ) c = tiny;
			d = 1/d;
			delta = c*d;
			f *= delta;

			a = - (A+j)*(A+B+j)*X / ((A+2*j)*(A+2*j+1));

			// uggh! cut-and-paste
			d *= a; d += b;
			if ( d == 0 ) d = tiny;
			c = a/c; c += b;
			if ( c == 0 ) c = tiny;
			d = 1/d;
			delta = c*d;
			f *= delta;

		}
//		cerr << "Done, delta is: " << delta << endl;
		return f;
	}





}




