#include <string>
#include <iostream>
#include <rumba/matrixio.h>
#include "multutils.h"

using namespace RUMBA;

int main(int argc, char** argv)
{
	if ( argc < 3 )
		std::cerr << "must provide an input file and an output file" 
			<< std::endl;
	std::string infile = argv[1];
	std::string outfile = argv[2];
		
	RUMBA::ManifoldFile* f = ManifoldFile::construct (infile.c_str());

	ManifoldMatrix M(r_t_r(f));

	writeManifoldMatrix (M,outfile.c_str());
	return 0;
}
