#include "../matrixutils/mask.h"
#include <rumba/arghandler.h>


using namespace RUMBA;

void usage()
{
	std::cerr << "Usage: threshold-transform (--upper|-u) n1"
		" (--lower|-l) n2" << std::endl;
}


Argument myArgs [] = {
	Argument( "lower", RUMBA::NUMERIC, 'l' ),
	Argument( "upper", RUMBA::NUMERIC, 'u' ),
	Argument()

};


int main(int argc,char** argv)
{
	ArgHandler::setRequiredDefaultArg("infile");
	ArgHandler::setRequiredDefaultArg("outfile");
	double upper=0,lower=0;
	bool have_lower=true, have_upper=true;
	std::string infile,outfile;

	try {
		RUMBA::ArgHandler argh ( argc , argv, myArgs );
		if ( argh.arg("help") )
		{
			usage();
			exit(0);
		}

		argh.arg("infile",infile);
		argh.arg("outfile",outfile);

		try {
			argh.arg ( "upper", upper );
		}catch(...) { have_upper = false; } 
		try { 
			argh.arg ( "lower", lower);
		}catch(...) { have_lower = false; }

		if ( !have_lower && !have_upper )
		{
			std::cerr << "Need to provide a max or a min" << std::endl;
			exit(1);
		}

		if ( have_lower && have_upper && lower > upper )
		{
			std::cerr << 
				"Error: lower bound exceeds upper bound" << std::endl;
			exit(1);
		}

	}
	catch ( RUMBA::InvalidArgumentException& s)
	{
		std::cerr << "Invalid argument: " << s.error() << std::endl;
	}
    catch (RUMBA::DuplicateArgumentException& s)
    {
		std::cerr << "Duplicate argument: " << s.error() << std::endl;
	}
	catch (RUMBA::ArgHandlerException& s)
	{
		std::cerr << "Error: " << s.error() << std::endl;
	}
	catch (Exception& s)
	{
		std::cerr << "Exception:" << s.error() << std::endl;
	}


	RUMBA::ManifoldFile* mf = ManifoldFile::construct(infile.c_str());
	RUMBA::BaseManifold* M = mf->get(intPoint(0,0,0,0),mf->extent());
	delete mf;

	Threshold T( have_lower? &lower:0, have_upper? &upper:0, &lower,0, &upper);

	for ( int i = 0; i < M->size(); ++i ) 
		(*M)[i] = T((*M)[i]);

	M->save(outfile.c_str());

	delete M;

	return 0;
}
