/*
  expression.cc, copyright (c) 2006 by Vincent Fourmond: 
  Implementation of the Expression stuff.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/
#include <calc_internals.hh>

namespace SCalc {
  void Expression::dump(::std::ostream & stream) 
  {
    stream << "expr ";
  }

  /// The return value is undefined if you didn't bother
  /// to check that it was evaluable()...
  double Expression::evaluate()
  {
    double * vals = new double[session()->nb_vars_defined()];
    session()->fill_default(vals);
    double ret = evaluate(vals);
    delete[] vals;
    return ret;
  }

  /// The default behavior is to return a Null object, as it
  /// will be acceptable in many cases.
  Expression * Expression::derive(int id)
  {
    return new Null(session());
  }

  /// This function computes the expression nb times for the different
  /// variables, and put the results in target. The variables need to be
  /// in the follwing format:
  /// variables[0] = (all 'X' variables)
  /// variables[1] = (all 'Y' variables)
  /// and so on. It is trivial to implement the function that does
  /// store the variables the other way around. The implementation returns
  /// target.
  double * Expression::mass_evaluate(int nb, double * target, 
				     const double **variables) 
  {
    int nbVars = used_variables().size();
    double buf[nbVars];		// temporary variable on the stack
    for(int i = 0; i < nb; i++)
      {
	for(int j = 0; j < nbVars; j++)
	  buf[j] = variables[j][i];
	target[i] = evaluate(buf);
      }
    return target;
  }

  Expression * Expression::add(Expression * a, Expression * b) 
  {
    return new Plus(a->session(),a,b);
  }

  Expression * Expression::sub(Expression * a, Expression * b) 
  {
    return new Minus(a->session(),a,b);
  }

  Expression * Expression::mul(Expression * a, Expression * b) 
  {
    return new Times(a->session(),a,b);
  }
  Expression * Expression::div(Expression * a, Expression * b) 
  {
    return new Divides(a->session(),a,b);
  }

};
