/*
 *  Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 *  Copyright (C) 2009-2009 - DIGITEO - Bruno JOFRET
 * 
 *  This file must be used under the terms of the CeCILL.
 *  This source file is licensed as described in the file COPYING, which
 *  you should have received as part of this distribution.  The terms
 *  are also available at
 *  http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 * 
 */

package org.scilab.modules.hdf5;

/**
 * Constants that will be used in hdf5 file
 * as type name or attributes
 *
 */
public final class H5ScilabConstant {
    
   
    
    public static final String SCILAB_CLASS = "SCILAB_Class";
    public static final String SCILAB_CLASS_DOUBLE = "double";
    public static final String SCILAB_CLASS_LIST = "list";
    public static final String SCILAB_CLASS_TLIST = "tlist";
    public static final String SCILAB_CLASS_MLIST = "mlist";
    public static final String SCILAB_CLASS_STRING = "string";
    public static final String SCILAB_CLASS_INT = "integer";

    public static final String SCILAB_CLASS_ROWS = "SCILAB_rows";
    public static final String SCILAB_CLASS_COLS = "SCILAB_cols";
    public static final String SCILAB_CLASS_ITEMS = "SCILAB_items";
    
    public static final String SCILAB_EMPTY = "SCILAB_empty";
    public static final String SCILAB_EMPTY_TRUE = "true";
    
    public static final String SCILAB_COMPLEX = "SCILAB_complex";
    public static final String SCILAB_COMPLEX_TRUE = SCILAB_EMPTY_TRUE;
    public static final String SCILAB_CLASS_BOOLEAN = "boolean";
    public static final String SCILAB_CLASS_PREC = "SCILAB_precision";
    
    public static final String SCILAB_CLASS_INT8 = "8";
    public static final String SCILAB_CLASS_UINT8 = "u8";
    public static final String SCILAB_CLASS_INT16 = "16";
    public static final String SCILAB_CLASS_UINT16 = "u16";
    public static final String SCILAB_CLASS_INT32 = "32";
    public static final String SCILAB_CLASS_UINT32 = "u32";
    public static final String SCILAB_CLASS_INT64 = "64";
    public static final String SCILAB_CLASS_UINT64 = "u64";
    
    /**
     * Private Constructor for utility class.
     */
    private H5ScilabConstant() { };
}
