// =============================================================================
// Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2010 - DIGITEO - Vincent COUVERT <vincent.couvert@scilab.org>
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================

// <-- JVM NOT MANDATORY -->

// <-- Non-regression test for bug 3674 -->
//
// <-- Bugzilla URL -->
// http://bugzilla.scilab.org/show_bug.cgi?id=3674
//
// <-- Short Description -->
// Scilab 5.0.2 has issues with the new "MAT-file Format" (functions "savematfile" and "loadmatfile") : 
// - loading a same variable from different files: the existing variables are not erased.
// - saving file on a other one is always on an appending mode: the existing files are not erased.

//
// Test savematfile
//

// Create a matrix
M = rand(400,400);

// Save the variable
savematfile(TMPDIR + "/bug_3674.mat", "M", "-v6");

// Read file size
[x, ierr]=fileinfo(TMPDIR + "/bug_3674.mat");
sizeFileRef = x(1);

// Try to erase original file
savematfile(TMPDIR + "/bug_3674.mat", "M", "-v6");

// Compare size
[x, ierr]=fileinfo(TMPDIR + "/bug_3674.mat");
newSizeFile = x(1);

if newSizeFile<>sizeFileRef then pause;end


// Test loadmatfile

// Create a matrix
M=rand(400,400);

// Saving same var in 3 separate files
savematfile(TMPDIR + "/bug_3674_1.mat", "M", "-v6");
savematfile(TMPDIR + "/bug_3674_2.mat", "M", "-v6");
savematfile(TMPDIR + "/bug_3674_3.mat", "M", "-v6");

clear;

allVarNames = who("get");
if or(allVarNames=="M") then pause;end

execstr("loadmatfile(TMPDIR + ""/bug_3674_1.mat"");")
allVarNames = who("get");
if size(find(allVarNames=="M"), "*") > 1 then pause;end

execstr("loadmatfile(TMPDIR + ""/bug_3674_2.mat"");")
allVarNames = who("get");
if size(find(allVarNames=="M"), "*") > 1 then pause;end

execstr("loadmatfile(TMPDIR + ""/bug_3674_3.mat"");")
allVarNames = who("get");
if size(find(allVarNames=="M"), "*") > 1 then pause;end


