/* Scintilla source code edit control */
/** @file Scintilla.h
 ** Interface to the edit control.
 **/
/* Copyright 1998-2003 by Neil Hodgson <neilh@scintilla.org>
 * The License.txt file describes the conditions under which this software may be distributed. */

/* Most of this file is automatically generated from the Scintilla.iface interface definition
 * file which contains any comments about the definitions. HFacer.py does the generation. */

#ifndef SCINTILLA_H
#define SCINTILLA_H

#include "Sci_Position.h"

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_WIN32)
/* Return false on failure: */
int Scintilla_RegisterClasses(void *hInstance);
int Scintilla_ReleaseResources(void);
#endif
int Scintilla_LinkLexers(void);

#ifdef __cplusplus
}
#endif

/* Here should be placed typedefs for uptr_t, an unsigned integer type large enough to
 * hold a pointer and sptr_t, a signed integer large enough to hold a pointer.
 * May need to be changed for 64 bit platforms. */
#if defined(_WIN32)
#include <basetsd.h>
#endif
#ifdef MAXULONG_PTR
typedef ULONG_PTR uptr_t;
typedef LONG_PTR sptr_t;
#else
typedef unsigned long uptr_t;
typedef long sptr_t;
#endif

typedef sptr_t (*SciFnDirect)(sptr_t ptr, unsigned int iMessage, uptr_t wParam, sptr_t lParam);


/* These structures are defined to be exactly the same shape as the Win32
 * CHARRANGE, TEXTRANGE, FINDTEXTEX, FORMATRANGE, and NMHDR structs.
 * So older code that treats Scintilla as a RichEdit will work. */

#if defined(__cplusplus) && defined(SCI_NAMESPACE)
namespace Scintilla {
#endif

struct Sci_CharacterRange {
	Sci_PositionCR cpMin;
	Sci_PositionCR cpMax;
};

struct Sci_TextRange {
	struct Sci_CharacterRange chrg;
	char *lpstrText;
};

struct Sci_TextToFind {
	struct Sci_CharacterRange chrg;
	const char *lpstrText;
	struct Sci_CharacterRange chrgText;
};

#define CharacterRange Sci_CharacterRange
#define TextRange Sci_TextRange
#define TextToFind Sci_TextToFind

typedef void *Sci_SurfaceID;

struct Sci_Rectangle {
	int left;
	int top;
	int right;
	int bottom;
};

/* This structure is used in printing and requires some of the graphics types
 * from Platform.h.  Not needed by most client code. */

struct Sci_RangeToFormat {
	Sci_SurfaceID hdc;
	Sci_SurfaceID hdcTarget;
	struct Sci_Rectangle rc;
	struct Sci_Rectangle rcPage;
	struct Sci_CharacterRange chrg;
};

#define RangeToFormat Sci_RangeToFormat

#ifndef __cplusplus
/* For the GTK+ platform, g-ir-scanner needs to have these typedefs. This
 * is not required in C++ code and actually seems to break ScintillaEditPy */
typedef struct Sci_NotifyHeader Sci_NotifyHeader;
typedef struct SCNotification SCNotification;
#endif

struct Sci_NotifyHeader {
	/* Compatible with Windows NMHDR.
	 * hwndFrom is really an environment specific window handle or pointer
	 * but most clients of Scintilla.h do not have this type visible. */
	void *hwndFrom;
	uptr_t idFrom;
	unsigned int code;
};

#define NotifyHeader Sci_NotifyHeader

struct SCNotification {
	Sci_NotifyHeader nmhdr;
	Sci_Position position;
	/* SCN_STYLENEEDED, SCN_DOUBLECLICK, SCN_MODIFIED, SCN_MARGINCLICK, */
	/* SCN_NEEDSHOWN, SCN_DWELLSTART, SCN_DWELLEND, SCN_CALLTIPCLICK, */
	/* SCN_HOTSPOTCLICK, SCN_HOTSPOTDOUBLECLICK, SCN_HOTSPOTRELEASECLICK, */
	/* SCN_INDICATORCLICK, SCN_INDICATORRELEASE, */
	/* SCN_USERLISTSELECTION, SCN_AUTOCSELECTION */

	int ch;
	/* SCN_CHARADDED, SCN_KEY, SCN_AUTOCCOMPLETED, SCN_AUTOCSELECTION, */
	/* SCN_USERLISTSELECTION */
	int modifiers;
	/* SCN_KEY, SCN_DOUBLECLICK, SCN_HOTSPOTCLICK, SCN_HOTSPOTDOUBLECLICK, */
	/* SCN_HOTSPOTRELEASECLICK, SCN_INDICATORCLICK, SCN_INDICATORRELEASE, */

	int modificationType;	/* SCN_MODIFIED */
	const char *text;
	/* SCN_MODIFIED, SCN_USERLISTSELECTION, SCN_AUTOCSELECTION, SCN_URIDROPPED */

	Sci_Position length;		/* SCN_MODIFIED */
	Sci_Position linesAdded;	/* SCN_MODIFIED */
	int message;	/* SCN_MACRORECORD */
	uptr_t wParam;	/* SCN_MACRORECORD */
	sptr_t lParam;	/* SCN_MACRORECORD */
	Sci_Position line;		/* SCN_MODIFIED */
	int foldLevelNow;	/* SCN_MODIFIED */
	int foldLevelPrev;	/* SCN_MODIFIED */
	int margin;		/* SCN_MARGINCLICK */
	int listType;	/* SCN_USERLISTSELECTION */
	int x;			/* SCN_DWELLSTART, SCN_DWELLEND */
	int y;		/* SCN_DWELLSTART, SCN_DWELLEND */
	int token;		/* SCN_MODIFIED with SC_MOD_CONTAINER */
	Sci_Position annotationLinesAdded;	/* SCN_MODIFIED with SC_MOD_CHANGEANNOTATION */
	int updated;	/* SCN_UPDATEUI */
	int listCompletionMethod;
	/* SCN_AUTOCSELECTION, SCN_AUTOCCOMPLETED, SCN_USERLISTSELECTION, */
};

#if defined(__cplusplus) && defined(SCI_NAMESPACE)
}
#endif


#endif
