/*							-- DO NOT EDIT --
 * Generated by smidump version 0.4.3:
 *   smidump -f scli CISCO-DOT11-ASSOCIATION-MIB
 *
 * Derived from CISCO-DOT11-ASSOCIATION-MIB:
 *   This MIB module provides network management 
 *   information on IEEE 802.11 wireless device 
 *   association management and data packet forwarding 
 *   configuration and statistics.  This MIB is an
 *   extension to the IEEE802dot11-MIB and provides
 *   per client based information.  
 *   
 *   The IEEE802dot11-MIB is defined in the IEEE Std 
 *   802.11-Jan 14 1999, Wireless LAN Medium Access 
 *   Control and Physical Layer Specifications, by the
 *   LAN MAN Standards Committee of the IEEE Computer
 *   Society.
 *   
 *   
 *             GLOSSARY and ACRONYMS 
 *   
 *   Access point (AP)   
 *       Transmitter/receiver (transceiver) device
 *       that commonly connects and transports data 
 *       between a wireless network and a wired network.
 *   
 *   Association
 *       The service used to establish access point
 *       or station mapping and enable STA invocation
 *       of the distribution system serivces.
 *       (Wireless clients attempt to connect to 
 *       access points.)
 *   
 *   Bridge    
 *       Device that connects two or more segments 
 *       and reduces traffic by analyzing the 
 *       destination address, filtering the frame,
 *       and forwarding the frame to all connected 
 *       segments.
 *   
 *   Bridge AP 
 *       It is an AP that functions as a transparent 
 *       bridge between 2 wired LAN segments.  
 *   
 *   Bridge Host     
 *       This is also known as Work Group Bridge.  This
 *       is a non-root bridge that is connected to a
 *       remote LAN segment and will only communicate 
 *       with repeaters or root bridges.  It does not 
 *       accept association from other wireless devices.
 *   
 *   BSS	
 *       IEEE 802.11 Basic Service Set (Radio Cell).  The
 *       BSS of an AP comprises of the stations directly 
 *       associated with the AP.
 *   
 *   Client (Client Station)    
 *       A wireless device in a wireless network 
 *       associated with an access point.
 *   
 *   IEEE 802.11    
 *       Standard to encourage interoperability among 
 *       wireless networking equipment.
 *   
 *   MIC	
 *       Message Integrity Check.  A MIC can, optionally, 
 *       be added to WEP-encrypted 802.11 frames.
 *   
 *   Non-Root Bridge   
 *       This wireless bridge does not connect to the main
 *       wired LAN segment.  It connects to a remote wired 
 *       LAN segment and can associate to root bridges and
 *       other non-root bridges that accept client 
 *       associations.  It also can accept associations 
 *       from other non-root bridges, repeater access 
 *       points, and client devices.
 *   
 *   Repeater    
 *       Device that connects multiple segments, listening 
 *       to each and repeating signal on one to every other 
 *       connected one; regenerates each transmission 
 *       so that it can travel farther.
 *   
 *   Repeater or Non-root Access Point    
 *       The repeater access point is not connected 
 *       to the wired LAN.  The Repeater is a wireless 
 *       LAN transceiver that transfers data between 
 *       a client and another access point, another 
 *       repeater, or between two bridges.  The repeater 
 *       is placed within radio range of an access point 
 *       connected to the wired LAN, another repeater, or 
 *       an non-root bridge to extend the range of the 
 *       infrastructure.
 *   
 *   Root Access Point    
 *       This access point connects clients to the main 
 *       wired LAN.
 *   
 *   Root Wireless Bridge    
 *       This wireless bridge is connected to the main 
 *       wired LAN.  This wireless bridge can communicate
 *       with non-root wireless bridges, repeater access
 *       points, and client devices but not with another 
 *       wireless root bridge.  Only one wireless bridge
 *       in a wireless LAN can be set as the wireless 
 *       root bridge.  
 *   
 *   SSID
 *       Radio Service Set ID.  It is used for identification
 *       during association.
 *   
 *   STA (WSTA)	
 *       A non-AP 802.11 wireless station.
 *   
 *   WEP	
 *       Wired Equivalent Privacy.  'WEP' is generally used
 *       to refer to 802.11 encryption.
 *   
 *   Work Group Bridges (WGB)
 *       See bridge host.
 *
 * Revision 2003-07-27 00:00:
 *   Added new IEEE 802.11g radio type to 
 *   CDot11ClientRadioType and new AP device type to 
 *   CDot11ClientDevType.
 *
 * Revision 2003-04-11 00:00:
 *   Added new objects for client software version, IP 
 *   address, name, and association or autentication state.
 *
 * Revision 2003-01-29 00:00:
 *   Added new 5GHz radio type to CDot11ClientRadioType
 *   and new client types to CDot11ClientDevType.
 *
 * Revision 2002-07-15 00:00:
 *   Corrected the unit of cDot11ClientBytesReceived.
 *
 * Revision 2002-04-17 00:00:
 *   Added a new index cd11IfAuxSsid and a new object 
 *   cDot11ClientParentAddress to the 
 *   cDot11ClientConfigInfoTable.
 *
 * Revision 2002-03-06 00:00:
 *   Initial version of this MIB module.
 *
 * $Id: cisco-dot11-association-mib.h 1764 2006-01-18 09:40:08Z schoenw $
 */

#ifndef _CISCO_DOT11_ASSOCIATION_MIB_H_
#define _CISCO_DOT11_ASSOCIATION_MIB_H_

#include "gsnmp.h"

G_BEGIN_DECLS

/*
 * Tables to map enumerations to strings and vice versa.
 */

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPOWERSAVEMODE_ACTIVE    1
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPOWERSAVEMODE_POWERSAVE 2

extern GNetSnmpEnum const cisco_dot11_association_mib_enums_cDot11ClientPowerSaveMode[];

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE_INITIAL                1
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE_AUTHENNOTASSOCIATED    2
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE_ASSOCANDAUTHENTICATED  3
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE_ASSOCNOTANUTHENTICATED 4

extern GNetSnmpEnum const cisco_dot11_association_mib_enums_cDot11ClientAssociationState[];

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_CLIENTSTATION  0
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_REPEATER       1
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_ACCESSPOINT    2
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_BRIDGEHOST     3
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_BRIDGE         4
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_BRIDGEROOT     5
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE_ETHERNETCLIENT 6

extern GNetSnmpEnum const cisco_dot11_association_mib_enums_CDot11ClientRoleClassType[];

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_ETHERNETAP         76
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_ETHERNETBRIDGE     77
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC3000CLIENT       84
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_SERIALUC           85
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_ETHERNETUC         86
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC3500CLIENT       101
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC4500CLIENT       102
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_GENERIC80211CLIENT 104
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC4800CLIENT       109
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC3100CLIENT       110
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_MC                 111
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_ETHERNETCLIENT     112
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_PC4800BCLIENT      117
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_WGBNODIVERSITY     123
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_WGB                124
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_SERIES350CLIENT    127
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_SERIES370CLIENT    128
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_C1100SERIESAP      129
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_C1410SERIESBRIDGE  130
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_C1200SERIESAP      132
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_MP2XCLIENT         133
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE_C350SERIESAP       134

extern GNetSnmpEnum const cisco_dot11_association_mib_enums_CDot11ClientDevType[];

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC3500     3
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC3000     4
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC4500     6
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC4800     12
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_PC3100     13
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_SERIES340  33
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_SERIES350  34
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_SERIES370  35
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_BRIDGE1410 36
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE_MP2XSERIES 37

extern GNetSnmpEnum const cisco_dot11_association_mib_enums_CDot11ClientRadioType[];


/*
 * C type definitions for CISCO-DOT11-ASSOCIATION-MIB::cDot11AssociationGlobal.
 */

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11PARENTADDRESS (1 << 0) 

typedef struct {
    guchar   *cDot11ParentAddress;     /* ro SNMPv2-TC::MacAddress */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11PARENTADDRESSLENGTH 6
} cisco_dot11_association_mib_cDot11AssociationGlobal_t;

extern cisco_dot11_association_mib_cDot11AssociationGlobal_t *
cisco_dot11_association_mib_new_cDot11AssociationGlobal(void);

extern void
cisco_dot11_association_mib_get_cDot11AssociationGlobal(GNetSnmp *s, cisco_dot11_association_mib_cDot11AssociationGlobal_t **cDot11AssociationGlobal, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11AssociationGlobal(cisco_dot11_association_mib_cDot11AssociationGlobal_t *cDot11AssociationGlobal);

/*
 * C type definitions for CISCO-DOT11-ASSOCIATION-MIB::cDot11ActiveDevicesEntry.
 */

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ACTIVEWIRELESSCLIENTS (1 << 0) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ACTIVEBRIDGES         (1 << 1) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ACTIVEREPEATERS       (1 << 2) 

typedef struct {
    gint32   ifIndex;                          /* ro IF-MIB::InterfaceIndex */
    guint32  *cDot11ActiveWirelessClients;     /* ro [Device] */
    guint32  *cDot11ActiveBridges;             /* ro [Device] */
    guint32  *cDot11ActiveRepeaters;           /* ro [Device] */
} cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t;

extern void
cisco_dot11_association_mib_get_cDot11ActiveDevicesTable(GNetSnmp *s, cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t ***cDot11ActiveDevicesEntry, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11ActiveDevicesTable(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t **cDot11ActiveDevicesEntry);

extern cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *
cisco_dot11_association_mib_new_cDot11ActiveDevicesEntry(void);

extern void
cisco_dot11_association_mib_get_cDot11ActiveDevicesEntry(GNetSnmp *s, cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t **cDot11ActiveDevicesEntry, gint32 ifIndex, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11ActiveDevicesEntry(cisco_dot11_association_mib_cDot11ActiveDevicesEntry_t *cDot11ActiveDevicesEntry);

/*
 * C type definitions for CISCO-DOT11-ASSOCIATION-MIB::cDot11AssociationStatsEntry.
 */

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSASSOCIATED      (1 << 0) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSAUTHENTICATED   (1 << 1) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSROAMEDIN        (1 << 2) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSROAMEDAWAY      (1 << 3) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSDEAUTHENTICATED (1 << 4) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11ASSSTATSDISASSOCIATED   (1 << 5) 

typedef struct {
    gint32   ifIndex;                            /* ro IF-MIB::InterfaceIndex */
    guint32  *cDot11AssStatsAssociated;          /* ro SNMPv2-SMI::Counter32 [client] */
    guint32  *cDot11AssStatsAuthenticated;       /* ro SNMPv2-SMI::Counter32 [client] */
    guint32  *cDot11AssStatsRoamedIn;            /* ro SNMPv2-SMI::Counter32 [client] */
    guint32  *cDot11AssStatsRoamedAway;          /* ro SNMPv2-SMI::Counter32 [client] */
    guint32  *cDot11AssStatsDeauthenticated;     /* ro SNMPv2-SMI::Counter32 [client] */
    guint32  *cDot11AssStatsDisassociated;       /* ro SNMPv2-SMI::Counter32 [client] */
} cisco_dot11_association_mib_cDot11AssociationStatsEntry_t;

extern void
cisco_dot11_association_mib_get_cDot11AssociationStatsTable(GNetSnmp *s, cisco_dot11_association_mib_cDot11AssociationStatsEntry_t ***cDot11AssociationStatsEntry, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11AssociationStatsTable(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t **cDot11AssociationStatsEntry);

extern cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *
cisco_dot11_association_mib_new_cDot11AssociationStatsEntry(void);

extern void
cisco_dot11_association_mib_get_cDot11AssociationStatsEntry(GNetSnmp *s, cisco_dot11_association_mib_cDot11AssociationStatsEntry_t **cDot11AssociationStatsEntry, gint32 ifIndex, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11AssociationStatsEntry(cisco_dot11_association_mib_cDot11AssociationStatsEntry_t *cDot11AssociationStatsEntry);

/*
 * C type definitions for CISCO-DOT11-ASSOCIATION-MIB::cDot11ClientConfigInfoEntry.
 */

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPARENTADDRESS    (1 << 0) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTROLECLASSTYPE    (1 << 1) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDEVTYPE          (1 << 2) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTRADIOTYPE        (1 << 3) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTWEPENABLED       (1 << 4) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTWEPKEYMIXENABLED (1 << 5) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMICENABLED       (1 << 6) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPOWERSAVEMODE    (1 << 7) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTAID              (1 << 8) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDATARATESET      (1 << 9) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTSOFTWAREVERSION  (1 << 10) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTNAME             (1 << 11) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTASSOCIATIONSTATE (1 << 12) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTIPADDRESSTYPE    (1 << 13) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTIPADDRESS        (1 << 14) 

typedef struct {
    gint32   ifIndex;                           /* ro IF-MIB::InterfaceIndex */
    guchar   cd11IfAuxSsid[32];                 /* rw */
#define CISCO_DOT11_IF_MIB_CD11IFAUXSSIDMINLENGTH 0
#define CISCO_DOT11_IF_MIB_CD11IFAUXSSIDMAXLENGTH 32
    guint16  _cd11IfAuxSsidLength;
    guchar   cDot11ClientAddress[6];           /* na SNMPv2-TC::MacAddress */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTADDRESSLENGTH 6
    guchar   *cDot11ClientParentAddress;        /* ro SNMPv2-TC::MacAddress */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPARENTADDRESSLENGTH 6
    gint32   *cDot11ClientRoleClassType;        /* ro CISCO-DOT11-ASSOCIATION-MIB::CDot11ClientRoleClassType */
    gint32   *cDot11ClientDevType;              /* ro CISCO-DOT11-ASSOCIATION-MIB::CDot11ClientDevType */
    gint32   *cDot11ClientRadioType;            /* ro CISCO-DOT11-ASSOCIATION-MIB::CDot11ClientRadioType */
    gint32   *cDot11ClientWepEnabled;           /* ro SNMPv2-TC::TruthValue */
    gint32   *cDot11ClientWepKeyMixEnabled;     /* ro SNMPv2-TC::TruthValue */
    gint32   *cDot11ClientMicEnabled;           /* ro SNMPv2-TC::TruthValue */
    gint32   *cDot11ClientPowerSaveMode;        /* ro */
    guint32  *cDot11ClientAid;                  /* ro */
    guchar   *cDot11ClientDataRateSet;          /* ro */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDATARATESETMINLENGTH 1
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDATARATESETMAXLENGTH 126
    guint16  _cDot11ClientDataRateSetLength;
    guchar   *cDot11ClientSoftwareVersion;      /* ro SNMP-FRAMEWORK-MIB::SnmpAdminString */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTSOFTWAREVERSIONMINLENGTH 0
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTSOFTWAREVERSIONMAXLENGTH 255
    guint16  _cDot11ClientSoftwareVersionLength;
    guchar   *cDot11ClientName;                 /* ro SNMP-FRAMEWORK-MIB::SnmpAdminString */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTNAMEMINLENGTH 0
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTNAMEMAXLENGTH 255
    guint16  _cDot11ClientNameLength;
    gint32   *cDot11ClientAssociationState;     /* ro */
    gint32   *cDot11ClientIpAddressType;        /* ro INET-ADDRESS-MIB::InetAddressType */
    guchar   *cDot11ClientIpAddress;            /* ro INET-ADDRESS-MIB::InetAddress */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTIPADDRESSMINLENGTH 0
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTIPADDRESSMAXLENGTH 255
    guint16  _cDot11ClientIpAddressLength;
} cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t;

extern void
cisco_dot11_association_mib_get_cDot11ClientConfigInfoTable(GNetSnmp *s, cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t ***cDot11ClientConfigInfoEntry, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11ClientConfigInfoTable(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t **cDot11ClientConfigInfoEntry);

extern cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *
cisco_dot11_association_mib_new_cDot11ClientConfigInfoEntry(void);

extern void
cisco_dot11_association_mib_get_cDot11ClientConfigInfoEntry(GNetSnmp *s, cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t **cDot11ClientConfigInfoEntry, gint32 ifIndex, guchar *cd11IfAuxSsid, guint16 _cd11IfAuxSsidLength, guchar *cDot11ClientAddress, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11ClientConfigInfoEntry(cisco_dot11_association_mib_cDot11ClientConfigInfoEntry_t *cDot11ClientConfigInfoEntry);

/*
 * C type definitions for CISCO-DOT11-ASSOCIATION-MIB::cDot11ClientStatisticEntry.
 */

#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTCURRENTTXRATESET (1 << 0) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTUPTIME           (1 << 1) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTSIGNALSTRENGTH   (1 << 2) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTSIGQUALITY       (1 << 3) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTAGINGLEFT        (1 << 4) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPACKETSRECEIVED  (1 << 5) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTBYTESRECEIVED    (1 << 6) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTPACKETSSENT      (1 << 7) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTBYTESSENT        (1 << 8) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTDUPLICATES       (1 << 9) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMSDURETRIES      (1 << 10) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMSDUFAILS        (1 << 11) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTWEPERRORS        (1 << 12) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMICERRORS        (1 << 13) 
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTMICMISSINGFRAMES (1 << 14) 

typedef struct {
    gint32   ifIndex;                           /* ro IF-MIB::InterfaceIndex */
    guchar   cd11IfAuxSsid[32];                 /* rw */
#define CISCO_DOT11_IF_MIB_CD11IFAUXSSIDMINLENGTH 0
#define CISCO_DOT11_IF_MIB_CD11IFAUXSSIDMAXLENGTH 32
    guint16  _cd11IfAuxSsidLength;
    guchar   cDot11ClientAddress[6];           /* na SNMPv2-TC::MacAddress */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTADDRESSLENGTH 6
    guchar   *cDot11ClientCurrentTxRateSet;     /* ro */
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTCURRENTTXRATESETMINLENGTH 1
#define CISCO_DOT11_ASSOCIATION_MIB_CDOT11CLIENTCURRENTTXRATESETMAXLENGTH 126
    guint16  _cDot11ClientCurrentTxRateSetLength;
    guint32  *cDot11ClientUpTime;               /* ro Unsigned32 [second] */
    gint32   *cDot11ClientSignalStrength;       /* ro [dBm] */
    guint32  *cDot11ClientSigQuality;           /* ro [percentage] */
    guint32  *cDot11ClientAgingLeft;            /* ro SNMPv2-SMI::Gauge32 [second] */
    guint32  *cDot11ClientPacketsReceived;      /* ro SNMPv2-SMI::Counter32 [packet] */
    guint32  *cDot11ClientBytesReceived;        /* ro SNMPv2-SMI::Counter32 [byte] */
    guint32  *cDot11ClientPacketsSent;          /* ro SNMPv2-SMI::Counter32 [packet] */
    guint32  *cDot11ClientBytesSent;            /* ro SNMPv2-SMI::Counter32 [byte] */
    guint32  *cDot11ClientDuplicates;           /* ro SNMPv2-SMI::Counter32 [packet] */
    guint32  *cDot11ClientMsduRetries;          /* ro SNMPv2-SMI::Counter32 [packet] */
    guint32  *cDot11ClientMsduFails;            /* ro SNMPv2-SMI::Counter32 [packet] */
    guint32  *cDot11ClientWepErrors;            /* ro SNMPv2-SMI::Counter32 [packet] */
    guint32  *cDot11ClientMicErrors;            /* ro SNMPv2-SMI::Counter32 [error] */
    guint32  *cDot11ClientMicMissingFrames;     /* ro SNMPv2-SMI::Counter32 [packet] */
} cisco_dot11_association_mib_cDot11ClientStatisticEntry_t;

extern void
cisco_dot11_association_mib_get_cDot11ClientStatisticTable(GNetSnmp *s, cisco_dot11_association_mib_cDot11ClientStatisticEntry_t ***cDot11ClientStatisticEntry, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11ClientStatisticTable(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t **cDot11ClientStatisticEntry);

extern cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *
cisco_dot11_association_mib_new_cDot11ClientStatisticEntry(void);

extern void
cisco_dot11_association_mib_get_cDot11ClientStatisticEntry(GNetSnmp *s, cisco_dot11_association_mib_cDot11ClientStatisticEntry_t **cDot11ClientStatisticEntry, gint32 ifIndex, guchar *cd11IfAuxSsid, guint16 _cd11IfAuxSsidLength, guchar *cDot11ClientAddress, gint64 mask);

extern void
cisco_dot11_association_mib_free_cDot11ClientStatisticEntry(cisco_dot11_association_mib_cDot11ClientStatisticEntry_t *cDot11ClientStatisticEntry);


G_END_DECLS

#endif /* _CISCO_DOT11_ASSOCIATION_MIB_H_ */
