 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_GRAPH_MSA_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_MSA_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BlastLib_

struct BlastLib_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(54)

//____________________________________________________________________________
// FractionalScore_

struct FractionalScore_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(50)

//____________________________________________________________________________
// FrequencyCounting_

struct FrequencyCounting_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(58)

//____________________________________________________________________________
// GlobalPairwise_Library_

struct GlobalPairwise_Library_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(50)

//____________________________________________________________________________
// KmerDistance_

struct KmerDistance_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(48)

//____________________________________________________________________________
// Kmer_Library_

struct Kmer_Library_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(67)

//____________________________________________________________________________
// Lcs_Library_

struct Lcs_Library_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(76)

//____________________________________________________________________________
// LibraryDistance_

struct LibraryDistance_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(40)

//____________________________________________________________________________
// LocalPairwise_Library_

struct LocalPairwise_Library_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(59)

//____________________________________________________________________________
// MsaOptions

template <typename TAlphabet, typename TScore> struct MsaOptions;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(28)

//____________________________________________________________________________
// MummerLib_

struct MummerLib_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(64)

//____________________________________________________________________________
// NewickFormat_

struct NewickFormat_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(75)

//____________________________________________________________________________
// ProfileProfileScore

template <typename T> struct ProfileProfileScore;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(72)

//____________________________________________________________________________
// ReScore_

struct ReScore_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(65)

//____________________________________________________________________________
// TCoffeeLib_

struct TCoffeeLib_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(44)

//____________________________________________________________________________
// UpgmaAvg_

struct UpgmaAvg_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(297)

//____________________________________________________________________________
// UpgmaMax_

struct UpgmaMax_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(287)

//____________________________________________________________________________
// UpgmaMin_

struct UpgmaMin_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(277)

//____________________________________________________________________________
// UpgmaWeightAvg_

struct UpgmaWeightAvg_;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(307)

//____________________________________________________________________________
// __EdgeCargo

template <typename TVertexDescriptor, typename TCargo> struct __EdgeCargo;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(245)

//____________________________________________________________________________
// __LessEdgeCargo

template <typename TVertexDescriptor, typename TCargo> struct __LessEdgeCargo;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(263)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// BlastLib

typedef Tag<BlastLib_> const BlastLib;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(55)

//____________________________________________________________________________
// FractionalScore

typedef Tag<FractionalScore_> const FractionalScore;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(51)

//____________________________________________________________________________
// FrequencyCounting

typedef Tag<FrequencyCounting_> const FrequencyCounting;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(59)

//____________________________________________________________________________
// GlobalPairwise_Library

typedef Tag<GlobalPairwise_Library_> const GlobalPairwise_Library;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(51)

//____________________________________________________________________________
// KmerDistance

typedef Tag<KmerDistance_> const KmerDistance;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(49)

//____________________________________________________________________________
// Kmer_Library

typedef Tag<Kmer_Library_> const Kmer_Library;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(68)

//____________________________________________________________________________
// Lcs_Library

typedef Tag<Lcs_Library_> const Lcs_Library;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(77)

//____________________________________________________________________________
// LibraryDistance

typedef Tag<LibraryDistance_> const LibraryDistance;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(41)

//____________________________________________________________________________
// LocalPairwise_Library

typedef Tag<LocalPairwise_Library_> const LocalPairwise_Library;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(60)

//____________________________________________________________________________
// MummerLib

typedef Tag<MummerLib_> const MummerLib;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(65)

//____________________________________________________________________________
// NewickFormat

typedef Tag<NewickFormat_> const NewickFormat;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(76)

//____________________________________________________________________________
// ReScore

typedef Tag<ReScore_> const ReScore;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(66)

//____________________________________________________________________________
// TCoffeeLib

typedef Tag<TCoffeeLib_> const TCoffeeLib;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(45)

//____________________________________________________________________________
// UpgmaAvg

typedef Tag<UpgmaAvg_> const UpgmaAvg;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(298)

//____________________________________________________________________________
// UpgmaMax

typedef Tag<UpgmaMax_> const UpgmaMax;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(288)

//____________________________________________________________________________
// UpgmaMin

typedef Tag<UpgmaMin_> const UpgmaMin;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(278)

//____________________________________________________________________________
// UpgmaWeightAvg

typedef Tag<UpgmaWeightAvg_> const UpgmaWeightAvg;       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(308)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// __appendNewMatch

template <typename TPos, typename TSpec2, typename TSpec1, typename TScores, typename TId, typename TSize> inline void __appendNewMatch(String<Fragment<TPos, ExactReversableFragment<TSpec2> >, TSpec1>& matches, TScores& scores, TId seq1Id, TId seq2Id, TSize beg1, TSize beg2, TSize len, bool);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(709)
template <typename TPos, typename TSpec2, typename TSpec1, typename TScores, typename TId, typename TSize> inline void __appendNewMatch(String<Fragment<TPos, ExactFragment<TSpec2> >, TSpec1>& matches, TScores& scores, TId seq1Id, TId seq2Id, TSize beg1, TSize beg2, TSize len, bool reversed);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(727)

//____________________________________________________________________________
// __appendSegmentMatches

template <typename TStrSpec, typename TSpec, typename TList, typename TScore, typename TSegmentMatches, typename TScores> inline void __appendSegmentMatches(StringSet<String<AminoAcid, TStrSpec>, Dependent<TSpec> > const& str, TList const& pList, TScore const&, TSegmentMatches& matches, TScores& scores);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(171)
template <typename TValue, typename TStrSpec, typename TSpec, typename TList, typename TScore, typename TSegmentMatches, typename TScores> inline void __appendSegmentMatches(StringSet<String<TValue, TStrSpec>, Dependent<TSpec> > const& str, TList const& pList, TScore const& score_type, TSegmentMatches& matches, TScores& scores);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(185)

//____________________________________________________________________________
// __includeFragment

template <typename TSizeSpec, typename TSpec1, typename TSpec2, typename TSize> inline void __includeFragment(String<Fragment<TSizeSpec, ExactReversableFragment<TSpec1> >, TSpec2>& matches, TSize seq1Id, TSize beg1, TSize seq2Id, TSize beg2, TSize len, bool reversed);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(509)
template <typename TSizeSpec, typename TSpec1, typename TSpec2, typename TSize> inline void __includeFragment(String<Fragment<TSizeSpec, ExactFragment<TSpec1> >, TSpec2>& matches, TSize seq1Id, TSize beg1, TSize seq2Id, TSize beg2, TSize len, bool reversed);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(526)

//____________________________________________________________________________
// __matchScore

template <typename TScore, typename TSc> inline void __matchScore(TScore&, TSc);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(33)
template <typename TValue, typename TSc> inline void __matchScore(Score<TValue, Simple>& sc, TSc msc);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(53)

//____________________________________________________________________________
// __mismatchScore

template <typename TScore, typename TSc> inline void __mismatchScore(TScore&, TSc);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(43)
template <typename TValue, typename TSc> inline void __mismatchScore(Score<TValue, Simple>& sc, TSc mmsc);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(63)

//____________________________________________________________________________
// __resizeWithRespectToDistance

template <typename TValue, typename TSpec, typename TSize> inline void __resizeWithRespectToDistance(String<TValue, TSpec>& dist, TSize nseq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(358)
template <typename TCargo, typename TSpec, typename TSize> inline void __resizeWithRespectToDistance(Graph<Undirected<TCargo, TSpec> >& dist, TSize nseq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(368)
template <typename TSize> inline void __resizeWithRespectToDistance(Nothing&, TSize);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(380)

//____________________________________________________________________________
// __setDistanceValue

template <typename TFragment, typename TSpec1, typename TString, typename TSpec2, typename TValue, typename TSpec, typename TSize> inline void __setDistanceValue(String<TFragment, TSpec1>& matches, StringSet<TString, TSpec2>& pairSet, String<TValue, TSpec>& dist, TSize i, TSize j, TSize nseq, TSize from);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(395)
template <typename TFragment, typename TSpec1, typename TString, typename TSpec2, typename TCargo, typename TSpec, typename TSize> inline void __setDistanceValue(String<TFragment, TSpec1>& matches, StringSet<TString, TSpec2>& pairSet, Graph<Undirected<TCargo, TSpec> >& dist, TSize i, TSize j, TSize, TSize from);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(421)
template <typename TFragment, typename TSpec, typename TString, typename TSpec2, typename TSize> inline void __setDistanceValue(String<TFragment, TSpec>&, StringSet<TString, TSpec2>&, Nothing&, TSize, TSize, TSize, TSize);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(448)

//____________________________________________________________________________
// _buildLeafString

template <typename TStringSet, typename TCargo, typename TSpec, typename TPosition, typename TSequence> inline void _buildLeafString(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TPosition const pos, TSequence& alignSeq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(38)

//____________________________________________________________________________
// _buildNewickString

template <typename TCargo, typename TSpec, typename TNames, typename TNewickString, typename TVertexDescriptor> void _buildNewickString(Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, TNewickString& str, TVertexDescriptor v, bool collapseRoot);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(926)

//____________________________________________________________________________
// _collectSegmentMatches

template <typename TValue, typename TSpec2, typename TFragment, typename TSpec, typename TScores, typename TSize> void _collectSegmentMatches(String<TValue, TSpec2> const& mat, String<TFragment, TSpec>& matches, TScores& scores, TSize nseq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(379)

//____________________________________________________________________________
// _createAlignmentGraph

template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TOutGraph> inline void _createAlignmentGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString& alignSeq, TOutGraph& gOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(72)

//____________________________________________________________________________
// _createMatchingGraph

template <typename TStringSet, typename TCargo, typename TSpec, typename TSegmentString, typename TEdgeMap, typename TOutGraph> inline void _createMatchingGraph(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TSegmentString& alignSeq, TEdgeMap& edgeMap, TOutGraph& gOut, TEdgeMap& edgeMapOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(189)

//____________________________________________________________________________
// _debugMatches

template <typename TStringSet, typename TMatches> void _debugMatches(TStringSet& str, TMatches& matches);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(388)

//____________________________________________________________________________
// _debugRefinedMatches

template <typename TGraph> void _debugRefinedMatches(TGraph& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(425)

//____________________________________________________________________________
// _getTupelString

template <typename TString, typename TTupelString, typename TKTup, typename TAlphabet> inline void _getTupelString(TString const& str, TTupelString& tupelString, TKTup const ktup, TAlphabet);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_kmer.h"(39)

//____________________________________________________________________________
// _msaRefinement

template <typename TValue, typename TSpec, typename TSize, typename TAlphabet, typename TScore> inline void _msaRefinement(String<TValue, TSpec>& mat, TSize nseq, TSize splitPos, TScore& sc, TAlphabet);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(274)

//____________________________________________________________________________
// _recursiveProgressiveMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TVertexDescriptor, typename TSequence> inline void _recursiveProgressiveMatching(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TVertexDescriptor const root, TSequence& alignSeq);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(416)

//____________________________________________________________________________
// _scoreMatches

template <typename TString, typename TSpec, typename TScoreType, typename TSize, typename TSpec2, typename TScoreString, typename TScoreValue> inline void _scoreMatches(StringSet<TString, TSpec> const& seqSet, TScoreType const& scType, String<Fragment<TSize, ExactFragment<> >, TSpec2> const& matches, TScoreString& scores, TScoreValue offset);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(171)
template <typename TString, typename TSpec, typename TScoreType, typename TFragment, typename TSpec2, typename TScoreString> inline void _scoreMatches(StringSet<TString, TSpec> const& seqSet, TScoreType const& scType, String<TFragment, TSpec2> const& matches, TScoreString& scores);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(210)

//____________________________________________________________________________
// _subTreeSearch

template <typename TGuideTree, typename TSeqGroups, typename TGroupRoot, typename TSize> inline void _subTreeSearch(TGuideTree& guideTree, TSeqGroups& seqGroups, TGroupRoot& groupRoot, TSize minMembers);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(353)

//____________________________________________________________________________
// _upgmaTreeMerge

template <typename TMatrix, typename TActive, typename TSize> inline void _upgmaTreeMerge(TMatrix& mat, TActive& active, TSize index_i, TSize index_j, TSize nseq, UpgmaWeightAvg);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(322)
template <typename TMatrix, typename TActive, typename TSize> inline void _upgmaTreeMerge(TMatrix& mat, TActive& active, TSize index_i, TSize index_j, TSize nseq, UpgmaAvg);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(352)
template <typename TMatrix, typename TActive, typename TSize> inline void _upgmaTreeMerge(TMatrix& mat, TActive& active, TSize index_i, TSize index_j, TSize nseq, UpgmaMin);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(378)
template <typename TMatrix, typename TActive, typename TSize> inline void _upgmaTreeMerge(TMatrix& mat, TActive& active, TSize index_i, TSize index_j, TSize nseq, UpgmaMax);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(403)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaMax);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(426)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaMin);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(460)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const& active, TEdgeDescriptor best, UpgmaWeightAvg);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(493)
template <typename TCargo, typename TSpec, typename TActive, typename TEdgeDescriptor> inline void _upgmaTreeMerge(Graph<Undirected<TCargo, TSpec> >& pairGraph, TActive const&, TEdgeDescriptor best, UpgmaAvg);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(529)

//____________________________________________________________________________
// alignmentEvaluation

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore, typename TSize> inline typename Value<TScore>::Type alignmentEvaluation(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type, TSize& gapExCount, TSize& gapCount, TSize& pairCount, String<TSize>& numPairs, TSize& len);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(862)

//____________________________________________________________________________
// appendSegmentMatches

template <typename TString, typename TSpec, typename TSize2, typename TSpec2, typename TSegmentMatches, typename TScores> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, String<TSize2, TSpec2> const& pList, TSegmentMatches& matches, TScores& scores, Lcs_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(192)
template <typename TString, typename TSpec, typename TSegmentMatches, typename TScores, typename TAlphabet, typename TSize> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, TSegmentMatches& matches, TScores& scores, TSize ktup, TAlphabet, Kmer_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(241)
template <typename TString, typename TSpec, typename TSegmentMatches, typename TScores, typename TSize> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, TSegmentMatches& matches, TScores& scores, TSize ktup, Kmer_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(300)
template <typename TString, typename TSpec, typename TSegmentMatches, typename TScores> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, TSegmentMatches& matches, TScores& scores, Kmer_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(313)
template <typename TString, typename TSpec, typename TSize2, typename TSpec2, typename TScore, typename TSegmentMatches, typename TScores> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, String<TSize2, TSpec2> const& pList, TScore const& score_type, TSegmentMatches& matches, TScores& scores, LocalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(329)
template <typename TString, typename TSpec, typename TSize2, typename TSpec2, typename TScore, typename TSegmentMatches, typename TScoreValues, typename TDistance, typename TAlignConfig> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, String<TSize2, TSpec2> const& pList, TScore const& score_type, TSegmentMatches& matches, TScoreValues& scores, TDistance& dist, TAlignConfig const& ac, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(464)
template <typename TString, typename TSpec, typename TSize2, typename TSpec2, typename TScore, typename TSegmentMatches, typename TScoreValues, typename TDistance> inline void appendSegmentMatches(StringSet<TString, Dependent<TSpec> > const& str, String<TSize2, TSpec2> const& pList, TScore const& score_type, TSegmentMatches& matches, TScoreValues& scores, TDistance& dist, GlobalPairwise_Library);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(517)

//____________________________________________________________________________
// buildAlignmentGraph

template <typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TStringSet, typename TCargo, typename TSpec> inline void buildAlignmentGraph(String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>& scores, Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, FractionalScore);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(82)
template <typename TFragment, typename TSpec1, typename TStringSet, typename TCargo, typename TSpec> inline void buildAlignmentGraph(String<TFragment, TSpec1>& matches, Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, FrequencyCounting);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(136)
template <typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TStringSet, typename TCargo, typename TSpec> inline void buildAlignmentGraph(String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>&, Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, FrequencyCounting);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(158)
template <typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void buildAlignmentGraph(String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>& scores, Graph<Alignment<TStringSet, TCargo, TSpec> >& outGraph, TScore const& scType, ReScore);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(225)

//____________________________________________________________________________
// convertAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TSource, typename TSpec2> inline bool convertAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> > const& gAlign, Align<TSource, TSpec2>& align);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(933)
template <typename TSource, typename TSpec2, typename TStringSet, typename TCargo, typename TSpec> inline bool convertAlignment(Align<TSource, TSpec2> const& align, Graph<Alignment<TStringSet, TCargo, TSpec> >& gAlign);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(983)

//____________________________________________________________________________
// evaluateAlignment

template <typename TAlphabet, typename TScore> inline void evaluateAlignment(MsaOptions<TAlphabet, TScore> const& msaOpt);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(74)

//____________________________________________________________________________
// getAlignmentStatistics

template <typename TFragment, typename TSpec1, typename TStringSet, typename TPos, typename TSize1> inline void getAlignmentStatistics(String<TFragment, TSpec1> const& matches, TStringSet& str, TPos const from, TPos const to, TSize1& matchLength, TSize1& overlapLength, TSize1& alignLength);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(127)

//____________________________________________________________________________
// getDistanceMatrix

template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, LibraryDistance);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(67)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix, typename TSize, typename TAlphabet> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, TSize ktup, TAlphabet, KmerDistance);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(129)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix, typename TSize> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, TSize ktup, KmerDistance);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(151)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix, KmerDistance);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(163)
template <typename TStringSet, typename TCargo, typename TSpec, typename TMatrix> inline void getDistanceMatrix(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TMatrix& distanceMatrix);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_distance.h"(197)

//____________________________________________________________________________
// getKmerSimilarityMatrix

template <typename TString, typename TSpec, typename THitMatrix, typename TSize, typename TAlphabet> inline void getKmerSimilarityMatrix(StringSet<TString, TSpec> const& strSet, THitMatrix& mat, TSize ktup, TAlphabet);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_kmer.h"(81)

//____________________________________________________________________________
// globalMsaAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TStringSet1, typename TNames, typename TAlphabet, typename TScore> inline void globalMsaAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& gAlign, TStringSet1& sequenceSet, TNames& sequenceNames, MsaOptions<TAlphabet, TScore> const& msaOpt);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(198)
template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void globalMsaAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& gAlign, TScore const& scoreObject);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(349)
template <typename TSource, typename TSpec, typename TScore> inline void globalMsaAlignment(Align<TSource, TSpec>& align, TScore const& scoreObject);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_msa.h"(369)

//____________________________________________________________________________
// graphBasedTripletLibraryExtension

template <typename TStringSet, typename TCargo, typename TSpec> inline void graphBasedTripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(582)

//____________________________________________________________________________
// heaviestMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TString, typename TOutString> inline TCargo heaviestMatching(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TString const& str1, TString const& str2, TOutString& align);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(232)

//____________________________________________________________________________
// msaRefinement

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline void msaRefinement(Graph<Alignment<TStringSet, TCargo, TSpec> >& gAlign, TScore& sc);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(489)

//____________________________________________________________________________
// njTree

template <typename TValue, typename TStringSpec, typename TCargo, typename TSpec> inline void njTree(String<TValue, TStringSpec>& mat, Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(59)

//____________________________________________________________________________
// progressiveAlignment

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TOutGraph> inline void progressiveAlignment(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TOutGraph& gOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(123)

//____________________________________________________________________________
// progressiveMatching

template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TEdgeMap, typename TOutGraph> inline void progressiveMatching(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& tree, TEdgeMap& edgeMap, TOutGraph& gOut, TEdgeMap& edgeMapOut);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_progressive.h"(458)

//____________________________________________________________________________
// read

template <typename TFile, typename TFragment, typename TSpec, typename TScoreValue, typename TSpec2, typename TNames> void read(TFile & file, String<TFragment, TSpec>& matches, String<TScoreValue, TSpec2>& scores, TNames const& names, TCoffeeLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(97)
template <typename TFile, typename TString, typename TSpec, typename TNames> void read(TFile & file, StringSet<TString, TSpec>& oriStr, TNames& names, TCoffeeLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(219)
template <typename TFile, typename TString, typename TSpec, typename TNames> void read(TFile & file, StringSet<TString, TSpec>& oriStr, TNames& names, FastaAlign);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(339)
template <typename TFile, typename TFragment, typename TSpec, typename TScoreValue, typename TSpec2, typename TNames> void read(TFile & file, String<TFragment, TSpec>& matches, String<TScoreValue, TSpec2>& scores, TNames const& origNames, FastaAlign);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(443)
template <typename TFile, typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TNames> inline void read(TFile & file, String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>& scores, TNames& names, BlastLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(541)
template <typename TFile, typename TFragment, typename TSpec1, typename TScoreValue, typename TSpec2, typename TStringSet, typename TNames> inline void read(TFile & file, String<TFragment, TSpec1>& matches, String<TScoreValue, TSpec2>& scores, TStringSet const& strSet, TNames const& names, MummerLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(745)
template <typename TFile, typename TCargo, typename TSpec, typename TNames> void read(TFile & file, Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, NewickFormat);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(810)

//____________________________________________________________________________
// score

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue score(Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1 pos1, TPos2 pos2, TSeq1 const &seq1, TSeq2 const &seq2);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(230)

//____________________________________________________________________________
// scoreGapExtendHorizontal

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendHorizontal( Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1 pos1, TPos2, TSeq1 const& seq1, TSeq2 const&);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(123)

//____________________________________________________________________________
// scoreGapExtendVertical

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapExtendVertical( Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1, TPos2 pos2, TSeq1 const &, TSeq2 const & seq2);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(177)

//____________________________________________________________________________
// scoreGapOpenHorizontal

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenHorizontal( Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1 pos1, TPos2, TSeq1 const & seq1, TSeq2 const &);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(149)

//____________________________________________________________________________
// scoreGapOpenVertical

template <typename TValue, typename TScoreMember, typename TPos1, typename TPos2, typename TSeq1, typename TSeq2> inline TValue scoreGapOpenVertical( Score<TValue, ProfileProfileScore<TScoreMember> > const & me, TPos1, TPos2 pos2, TSeq1 const &, TSeq2 const & seq2);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_refinement.h"(203)

//____________________________________________________________________________
// selectPairs

template <typename TString, typename TSpec, typename TSize2, typename TSpec2> inline void selectPairs(StringSet<TString, TSpec> const& str, String<TSize2, TSpec2>& pList);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_library.h"(94)

//____________________________________________________________________________
// sumOfPairsScore

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline typename Value<TScore>::Type sumOfPairsScore(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(744)

//____________________________________________________________________________
// sumOfPairsScoreInd

template <typename TStringSet, typename TCargo, typename TSpec, typename TScore> inline typename Value<TScore>::Type sumOfPairsScoreInd(Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TScore const& score_type);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(800)

//____________________________________________________________________________
// tripletLibraryExtension

template <typename TStringSet, typename TCargo, typename TSpec> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(290)
template <typename TStringSet, typename TCargo, typename TSpec, typename TGuideTree, typename TSize> inline void tripletLibraryExtension(Graph<Alignment<TStringSet, TCargo, TSpec> >& g, TGuideTree& guideTree, TSize minMembers);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_base.h"(488)

//____________________________________________________________________________
// upgmaTree

template <typename TStringValue, typename TStringSpec, typename TCargo, typename TSpec, typename TTag> inline void upgmaTree(String<TStringValue, TStringSpec>& mat, Graph<Tree<TCargo, TSpec> >& g, TTag);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(564)
template <typename TValue, typename TSpec1, typename TCargo, typename TSpec2, typename TTag> inline void upgmaTree(Graph<Undirected<TValue, TSpec1> >& pairGraph, Graph<Tree<TCargo, TSpec2> >& g, TTag);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(680)
template <typename TDistance, typename TCargo, typename TSpec> inline void upgmaTree(TDistance& dist, Graph<Tree<TCargo, TSpec> >& g);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_guidetree.h"(855)

//____________________________________________________________________________
// write

template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, TCoffeeLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(255)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames, typename TEdgeMap> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, TEdgeMap& edgeMap, BlastLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(616)
template <typename TFile, typename TStringSet, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Alignment<TStringSet, TCargo, TSpec> > const& g, TNames& names, BlastLib);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(683)
template <typename TFile, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, bool collapseRoot, NewickFormat);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(1000)
template <typename TFile, typename TCargo, typename TSpec, typename TNames> void write(TFile & file, Graph<Tree<TCargo, TSpec> >& guideTree, TNames& names, NewickFormat);       	// "projects/library/seqan/graph_msa/graph_align_tcoffee_io.h"(1020)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

