 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_MODIFIER_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_MODIFIER_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// FunctorComplement

template <typename TValue> struct FunctorComplement;       	// "projects/library/seqan/modifier/modifier_functors.h"(110)

//____________________________________________________________________________
// FunctorConvert

template <typename InType, typename OutType> struct FunctorConvert;       	// "projects/library/seqan/modifier/modifier_functors.h"(88)

//____________________________________________________________________________
// FunctorLowcase

template <typename InType, typename Result > struct FunctorLowcase;       	// "projects/library/seqan/modifier/modifier_functors.h"(64)

//____________________________________________________________________________
// FunctorUpcase

template <typename InType, typename Result > struct FunctorUpcase;       	// "projects/library/seqan/modifier/modifier_functors.h"(46)

//____________________________________________________________________________
// ModExpand

template <char CHAR, typename TSpec > struct ModExpand;       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(47)

//____________________________________________________________________________
// ModReverse

struct ModReverse;       	// "projects/library/seqan/modifier/modifier_reverse.h"(42)

//____________________________________________________________________________
// ModView

template <typename TFunctor> struct ModView;       	// "projects/library/seqan/modifier/modifier_view.h"(46)

//____________________________________________________________________________
// ModViewCargo

template <typename TFunctor> struct ModViewCargo;       	// "projects/library/seqan/modifier/modifier_view.h"(49)

//____________________________________________________________________________
// ModifiedAlphabet

template <typename THost, typename TSpec> class ModifiedAlphabet;       	// "projects/library/seqan/modifier/modifier_alphabet.h"(41)

//____________________________________________________________________________
// ModifiedIterator

template <typename THost, typename TSpec > class ModifiedIterator;       	// "projects/library/seqan/modifier/modifier_iterator.h"(44)

//____________________________________________________________________________
// ModifiedString

template <typename THost, typename TSpec > class ModifiedString;       	// "projects/library/seqan/modifier/modifier_string.h"(44)
template <typename THost, typename TSpec> class ModifiedString;       	// "projects/library/seqan/modifier/modifier_iterator.h"(161)

//____________________________________________________________________________
// _AlphabetConversionTable

template <typename TTarget, typename TSource> struct _AlphabetConversionTable;       	// "projects/library/seqan/modifier/modifier_alphabet.h"(684)

//____________________________________________________________________________
// _CompareType_ModExpand_Impl

template <typename TModExpand, typename THost, typename TRight, typename TCompareHostRight> struct _CompareType_ModExpand_Impl;       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(345)

//____________________________________________________________________________
// _ConvertImpl_ModExpand

template <int SIZE_OF_SOURCE> struct _ConvertImpl_ModExpand;       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(203)

//____________________________________________________________________________
// _Translate_Table_Dna5_2_Dna5Complement

template <typename T > struct _Translate_Table_Dna5_2_Dna5Complement;       	// "projects/library/seqan/modifier/modifier_functors.h"(116)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// Dna5StringComplement

typedef ModifiedString<Dna5String, ModView< FunctorComplement<Dna5> > > Dna5StringComplement;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(35)

//____________________________________________________________________________
// Dna5StringReverse

typedef ModifiedString<Dna5String, ModReverse> Dna5StringReverse;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(40)

//____________________________________________________________________________
// Dna5StringReverseComplement

typedef ModifiedString< ModifiedString< Dna5String, ModView< FunctorComplement<Dna5> > >, ModReverse > Dna5StringReverseComplement;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(56)

//____________________________________________________________________________
// DnaStringComplement

typedef ModifiedString<DnaString, ModView< FunctorComplement<Dna> > > DnaStringComplement;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(34)

//____________________________________________________________________________
// DnaStringReverse

typedef ModifiedString<DnaString, ModReverse> DnaStringReverse;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(39)

//____________________________________________________________________________
// DnaStringReverseComplement

typedef ModifiedString< ModifiedString<DnaString, ModView< FunctorComplement<Dna> > >, ModReverse > DnaStringReverseComplement;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(51)

//____________________________________________________________________________
// ModComplementDna

typedef ModView< FunctorComplement<Dna> > ModComplementDna;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(29)

//____________________________________________________________________________
// ModComplementDna5

typedef ModView< FunctorComplement<Dna5> > ModComplementDna5;       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(30)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _copyCargo

template <typename TDest, typename TSource> inline void _copyCargo(TDest & me, TSource & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(231)

//____________________________________________________________________________
// _copyCargoImpl

template <typename TDest, typename TSource> inline void _copyCargoImpl(TDest &, TSource &, False const);       	// "projects/library/seqan/modifier/modifier_string.h"(223)
template <typename TDest, typename TSource> inline void _copyCargoImpl(TDest & me, TSource & _origin, True const);       	// "projects/library/seqan/modifier/modifier_string.h"(226)

//____________________________________________________________________________
// _dataHost

template <typename THost, typename TSpec> inline Holder<THost> & _dataHost(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(189)
template <typename THost, typename TSpec> inline Holder<THost> const & _dataHost(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(197)
template <typename THost, typename TSpec> inline Holder<THost, Simple> & _dataHost(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(183)
template <typename THost, typename TSpec> inline Holder<THost, Simple> const & _dataHost(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(191)

//____________________________________________________________________________
// _initializeAlphabetConversionTable

template <typename THost, char CHAR, typename TSpec, typename TSource> inline void _initializeAlphabetConversionTable(ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > * buf, TSource const &);       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(182)
template <typename TTarget, typename THost, char CHAR, typename TSpec> inline void _initializeAlphabetConversionTable(TTarget * buf, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const &);       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(274)
template <typename TTarget, typename TSource> inline void _initializeAlphabetConversionTable(TTarget *, TSource const &);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(677)

//____________________________________________________________________________
// assign

template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, ModifiedString<THost2, TSpec> & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(240)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, ModifiedString<THost2, TSpec> const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(248)
template <typename THost, typename TSpec, typename T> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, T & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(256)
template <typename THost, typename TSpec, typename T> inline ModifiedString<THost, TSpec> const & assign(ModifiedString<THost, TSpec> & me, T const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(263)
template <typename THost, typename TSpec, typename THost2> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, ModifiedIterator<THost2, TSpec> & _origin);       	// "projects/library/seqan/modifier/modifier_iterator.h"(283)
template <typename THost, typename TSpec, typename THost2> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, ModifiedIterator<THost2, TSpec> const & _origin);       	// "projects/library/seqan/modifier/modifier_iterator.h"(291)
template <typename THost, typename TSpec, typename T> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, T & _origin);       	// "projects/library/seqan/modifier/modifier_iterator.h"(299)
template <typename THost, typename TSpec, typename T> inline ModifiedIterator<THost, TSpec> const & assign(ModifiedIterator<THost, TSpec> & me, T const & _origin);       	// "projects/library/seqan/modifier/modifier_iterator.h"(306)

//____________________________________________________________________________
// assignModViewFunctor

template <typename THost, typename TFunctor> inline void assignModViewFunctor(ModifiedIterator<THost, ModView<TFunctor> > & me, TFunctor const & _func);       	// "projects/library/seqan/modifier/modifier_view.h"(186)
template <typename THost, typename TFunctor> inline void assignModViewFunctor(ModifiedString<THost, ModView<TFunctor> > & me, TFunctor const & _func);       	// "projects/library/seqan/modifier/modifier_view.h"(327)

//____________________________________________________________________________
// atBegin

template <typename THost, typename TSpec, typename TContainer> inline bool atBegin(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(567)
template <typename THost, typename TSpec, typename TContainer> inline bool atBegin(ModifiedIterator<THost, TSpec> const & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(577)
template <typename THost, typename TSpec> inline bool atBegin(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(585)
template <typename THost, typename TSpec> inline bool atBegin(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(594)
template <typename THost, typename TContainer> inline bool atBegin(ModifiedIterator<THost, ModReverse> const & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_reverse.h"(265)
template <typename THost> inline bool atBegin(ModifiedIterator<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(273)

//____________________________________________________________________________
// atEnd

template <typename THost, typename TSpec, typename TContainer> inline bool atEnd(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(607)
template <typename THost, typename TSpec, typename TContainer> inline bool atEnd(ModifiedIterator<THost, TSpec> const & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(617)
template <typename THost, typename TSpec> inline bool atEnd(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(625)
template <typename THost, typename TSpec> inline bool atEnd(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(634)
template <typename THost, typename TContainer> inline bool atEnd(ModifiedIterator<THost, ModReverse> const & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_reverse.h"(286)
template <typename THost> inline bool atEnd(ModifiedIterator<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(294)

//____________________________________________________________________________
// begin

template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> const >::Type begin(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(374)
template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> >::Type begin(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(382)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec> const, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, TSpec> const & me, Tag<TTagSpec> const tag_);       	// "projects/library/seqan/modifier/modifier_string.h"(390)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec>, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, TSpec> & me, Tag<TTagSpec> const tag_);       	// "projects/library/seqan/modifier/modifier_string.h"(401)
template <typename THost, typename TTag > inline typename Iterator< ModifiedString<THost, ModReverse> const >::Type begin(ModifiedString<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(412)
template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> >::Type begin(ModifiedString<THost, ModReverse> & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(421)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse> const, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, ModReverse> const & me, Tag<TTagSpec> const);       	// "projects/library/seqan/modifier/modifier_reverse.h"(430)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse>, Tag<TTagSpec> const >::Type begin(ModifiedString<THost, ModReverse> & me, Tag<TTagSpec> const);       	// "projects/library/seqan/modifier/modifier_reverse.h"(439)

//____________________________________________________________________________
// cargo

template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedString<THost, TSpec> >::Type >::Type cargo(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(205)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedString<THost, TSpec> const>::Type >::Type cargo(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(213)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedIterator<THost, TSpec> >::Type >::Type cargo(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(199)
template <typename THost, typename TSpec> inline typename Reference< typename Cargo<ModifiedIterator<THost, TSpec> const>::Type >::Type cargo(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(207)

//____________________________________________________________________________
// complementInPlace

template <typename TSequence > inline void complementInPlace(TSequence & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(63)
template <typename TSequence > inline void complementInPlace(TSequence const & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(69)
template <typename TSequence, typename TSpec > inline void complementInPlace(StringSet<TSequence, TSpec> & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(75)
template <typename TSequence, typename TSpec > inline void complementInPlace(StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(83)

//____________________________________________________________________________
// container

template <typename THost, typename TSpec> inline typename Container<ModifiedIterator<THost, TSpec> >::Type container(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(219)
template <typename THost, typename TSpec> inline typename Container<ModifiedIterator<THost, TSpec> const>::Type container(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(230)

//____________________________________________________________________________
// convertImpl

template <typename THost, char CHAR, typename TSpec, typename T, typename TSource> inline typename Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, TSource>::Type convertImpl(Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, T> const convert_, TSource const & source_);       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(240)
template <typename THost, char CHAR, typename TSpec, typename T, typename TSourceValue, typename TSourceSpec> inline typename Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, SimpleType<TSourceValue, TSourceSpec> >::Type convertImpl(Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, T> const, SimpleType<TSourceValue, TSourceSpec> const & source_);       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(249)
template <typename THost, char CHAR, typename TSpec, typename T, typename TSpec2> inline typename Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, Proxy<TSpec2> >::Type convertImpl(Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, T> const, Proxy<TSpec2> const & source_);       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(261)
template <typename TTarget, typename T, typename THost, char CHAR, typename TSpec> inline typename Convert<TTarget, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > >::Type convertImpl(Convert<TTarget, T> const, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const & source_);       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(295)
template <typename THost, char CHAR, typename TSpec, typename T> inline ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > convertImpl(Convert<ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> >, T> const, ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const & source_);       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(325)
template <typename TTarget, typename T, typename THost, typename TSpec> inline typename Convert<TTarget, THost>::Type convertImpl(Convert<TTarget, T> const convert_, ModifiedAlphabet<THost, TSpec> const & source_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(68)

//____________________________________________________________________________
// convertInPlace

template <typename TSequence, typename TFunctor > inline void convertInPlace(TSequence & sequence, TFunctor const &F);       	// "projects/library/seqan/modifier/modifier_view.h"(343)
template <typename TSequence, typename TFunctor > inline void convertInPlace(TSequence const & sequence, TFunctor const &F);       	// "projects/library/seqan/modifier/modifier_view.h"(355)

//____________________________________________________________________________
// end

template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> const >::Type end(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(416)
template <typename THost, typename TSpec > inline typename Iterator< ModifiedString<THost, TSpec> >::Type end(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(424)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec> const, Tag<TTagSpec> const >::Type end(ModifiedString<THost, TSpec> const & me, Tag<TTagSpec> const tag_);       	// "projects/library/seqan/modifier/modifier_string.h"(432)
template <typename THost, typename TSpec, typename TTagSpec > inline typename Iterator< ModifiedString<THost, TSpec>, Tag<TTagSpec> const >::Type end(ModifiedString<THost, TSpec> & me, Tag<TTagSpec> const tag_);       	// "projects/library/seqan/modifier/modifier_string.h"(440)
template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> const >::Type end(ModifiedString<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(452)
template <typename THost > inline typename Iterator< ModifiedString<THost, ModReverse> >::Type end(ModifiedString<THost, ModReverse> & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(461)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse> const, Tag<TTagSpec> const >::Type end(ModifiedString<THost, ModReverse> const & me, Tag<TTagSpec> const);       	// "projects/library/seqan/modifier/modifier_reverse.h"(470)
template <typename THost, typename TTagSpec > inline typename Iterator< ModifiedString<THost, ModReverse>, Tag<TTagSpec> const >::Type end(ModifiedString<THost, ModReverse> & me, Tag<TTagSpec> const);       	// "projects/library/seqan/modifier/modifier_reverse.h"(479)

//____________________________________________________________________________
// getValue

template <typename THost, typename TFunctor> inline typename GetValue<ModifiedIterator<THost, ModView<TFunctor> > >::Type getValue(ModifiedIterator<THost, ModView<TFunctor> > & me);       	// "projects/library/seqan/modifier/modifier_view.h"(165)
template <typename THost, typename TFunctor> inline typename GetValue<ModifiedIterator<THost, ModView<TFunctor> > const>::Type getValue(ModifiedIterator<THost, ModView<TFunctor> > const & me);       	// "projects/library/seqan/modifier/modifier_view.h"(173)
template <typename THost, typename TFunctor, typename TPos> inline typename GetValue<ModifiedString<THost, ModView<TFunctor> > >::Type getValue(ModifiedString<THost, ModView<TFunctor> > & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_view.h"(306)
template <typename THost, typename TFunctor, typename TPos> inline typename GetValue<ModifiedString<THost, ModView<TFunctor> > const>::Type getValue(ModifiedString<THost, ModView<TFunctor> > const & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_view.h"(314)

//____________________________________________________________________________
// goBegin

template <typename THost, typename TSpec, typename TContainer> inline void goBegin(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(469)
template <typename THost, typename TSpec> inline void goBegin(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(477)

//____________________________________________________________________________
// goEnd

template <typename THost, typename TSpec, typename TContainer> inline void goEnd(ModifiedIterator<THost, TSpec> & me, TContainer const & container);       	// "projects/library/seqan/modifier/modifier_iterator.h"(490)
template <typename THost, typename TSpec> inline void goEnd(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(498)

//____________________________________________________________________________
// goNext

template <typename THost, typename TSpec> inline void goNext(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(358)
template <typename THost> inline void goNext(ModifiedIterator<THost, ModReverse> & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(107)

//____________________________________________________________________________
// goPrevious

template <typename THost, typename TSpec> inline void goPrevious(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(390)
template <typename THost> inline void goPrevious(ModifiedIterator<THost, ModReverse> & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(122)

//____________________________________________________________________________
// id

template <typename THost, typename TSpec> inline void const * id(ModifiedString<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_string.h"(475)
template <typename THost, typename TSpec> inline void const * id(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(482)

//____________________________________________________________________________
// length

template <typename THost, typename TSpec > inline typename Size< ModifiedString<THost, TSpec> >::Type length(ModifiedString<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_string.h"(364)

//____________________________________________________________________________
// operator!=

template <typename THost, typename TSpec, typename TRight> inline bool operator!= (ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(197)
template <typename TLeft, typename THost, typename TSpec> inline bool operator!= (TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(208)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator!= (ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(219)
template <typename THost, typename TSpec> inline bool operator!= (ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(231)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator!= (SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(242)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator!= (ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(253)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator!= (Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(267)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator!= (ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(278)
template <typename THost, typename TSpec> inline bool operator!= (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(538)

//____________________________________________________________________________
// operator*

template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> >::Type operator* (ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(336)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> const>::Type operator* (ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(344)

//____________________________________________________________________________
// operator+

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> operator+ (ModifiedIterator<THost, TSpec> const & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_iterator.h"(428)

//____________________________________________________________________________
// operator++

template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> const & operator++ (ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(366)
template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> operator++ (ModifiedIterator<THost, TSpec> & me, int);       	// "projects/library/seqan/modifier/modifier_iterator.h"(375)

//____________________________________________________________________________
// operator+=

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> & operator+= (ModifiedIterator<THost, TSpec> & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_iterator.h"(421)
template <typename THost, typename TDelta> inline ModifiedIterator<THost, ModReverse> & operator+= (ModifiedIterator<THost, ModReverse> & me, TDelta delta_);       	// "projects/library/seqan/modifier/modifier_reverse.h"(137)

//____________________________________________________________________________
// operator-

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> operator- (ModifiedIterator<THost, TSpec> const & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_iterator.h"(448)
template <typename THost, typename TSpec> inline typename Difference< ModifiedIterator<THost, TSpec> >::Type operator- (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(457)
template <typename THost> inline typename Difference< ModifiedIterator<THost, ModReverse> >::Type operator- (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "projects/library/seqan/modifier/modifier_reverse.h"(190)

//____________________________________________________________________________
// operator--

template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> const & operator-- (ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(398)
template <typename THost, typename TSpec> inline ModifiedIterator<THost, TSpec> operator-- (ModifiedIterator<THost, TSpec> & me, int);       	// "projects/library/seqan/modifier/modifier_iterator.h"(407)

//____________________________________________________________________________
// operator-=

template <typename THost, typename TSpec, typename TDelta> inline ModifiedIterator<THost, TSpec> & operator-= (ModifiedIterator<THost, TSpec> & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_iterator.h"(441)
template <typename THost, typename TDelta> inline ModifiedIterator<THost, ModReverse> & operator-= (ModifiedIterator<THost, ModReverse> & me, TDelta delta);       	// "projects/library/seqan/modifier/modifier_reverse.h"(171)

//____________________________________________________________________________
// operator<

template <typename THost, typename TSpec, typename TRight> inline bool operator< (ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(389)
template <typename TLeft, typename THost, typename TSpec> inline bool operator< (TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(400)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator< (ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(411)
template <typename THost, typename TSpec> inline bool operator< (ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(423)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator< (SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(434)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator< (ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(445)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator< (Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(459)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator< (ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(470)
template <typename THost, typename TSpec> inline bool operator< (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(549)
template <typename THost> inline bool operator< (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "projects/library/seqan/modifier/modifier_reverse.h"(252)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename THost, typename TSpec > inline TStream & operator<< (TStream & target, ModifiedString<THost, TSpec> const & source);       	// "projects/library/seqan/modifier/modifier_string.h"(453)

//____________________________________________________________________________
// operator<=

template <typename THost, typename TSpec, typename TRight> inline bool operator<= (ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(293)
template <typename TLeft, typename THost, typename TSpec> inline bool operator<= (TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(304)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator<= (ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(315)
template <typename THost, typename TSpec> inline bool operator<= (ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(327)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator<= (SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(338)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator<= (ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(349)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator<= (Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(363)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator<= (ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(374)

//____________________________________________________________________________
// operator==

template <typename THost, typename TSpec, typename TRight> inline bool operator== (ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(101)
template <typename TLeft, typename THost, typename TSpec> inline bool operator== (TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(112)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator== (ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(123)
template <typename THost, typename TSpec> inline bool operator== (ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(135)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator== (SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(146)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator== (ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(157)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator== (Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(171)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator== (ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(182)
template <typename THost, typename TSpec> inline bool operator== (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(532)
template <typename THost> inline bool operator== (ModifiedIterator<THost, ModReverse> const & a, ModifiedIterator<THost, ModReverse> const & b);       	// "projects/library/seqan/modifier/modifier_reverse.h"(241)

//____________________________________________________________________________
// operator>

template <typename THost, typename TSpec, typename TRight> inline bool operator> (ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(581)
template <typename TLeft, typename THost, typename TSpec> inline bool operator> (TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(592)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator> (ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(603)
template <typename THost, typename TSpec> inline bool operator> (ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(615)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator> (SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(626)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator> (ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(637)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator> (Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(651)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator> (ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(662)
template <typename THost, typename TSpec> inline bool operator> (ModifiedIterator<THost, TSpec> const & a, ModifiedIterator<THost, TSpec> const & b);       	// "projects/library/seqan/modifier/modifier_iterator.h"(555)

//____________________________________________________________________________
// operator>=

template <typename THost, typename TSpec, typename TRight> inline bool operator>= (ModifiedAlphabet<THost, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(485)
template <typename TLeft, typename THost, typename TSpec> inline bool operator>= (TLeft const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(496)
template <typename TLeftHost, typename TLeftSpec, typename TRightHost, typename TRightSpec> inline bool operator>= (ModifiedAlphabet<TLeftHost, TLeftSpec> const & left_, ModifiedAlphabet<TRightHost, TRightSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(507)
template <typename THost, typename TSpec> inline bool operator>= (ModifiedAlphabet<THost, TSpec> const & left_, ModifiedAlphabet<THost, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(519)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator>= (SimpleType<TValue, TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(530)
template <typename TValue, typename TSpec, typename THost, typename TSpec2> inline bool operator>= (ModifiedAlphabet<THost, TSpec2> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(541)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator>= (Proxy<TSpec> const & left_, ModifiedAlphabet<THost, TSpec2> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(555)
template <typename TSpec, typename THost, typename TSpec2> inline bool operator>= (ModifiedAlphabet<THost, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(566)

//____________________________________________________________________________
// operator>>

template <typename TStream, typename THost, typename TSpec > inline TStream & operator>> (TStream & source, ModifiedString<THost, TSpec> & target);       	// "projects/library/seqan/modifier/modifier_string.h"(464)

//____________________________________________________________________________
// ordValue

template <typename THost, char CHAR, typename TSpec> inline unsigned ordValue(ModifiedAlphabet<THost, ModExpand<CHAR, TSpec> > const & c);       	// "projects/library/seqan/modifier/modifier_alphabet_expansion.h"(335)
template <typename THost, typename TSpec> inline unsigned ordValue(ModifiedAlphabet<THost,TSpec> const &c);       	// "projects/library/seqan/modifier/modifier_alphabet.h"(76)

//____________________________________________________________________________
// position

template <typename THost, typename TSpec> inline typename Position<ModifiedIterator<THost, TSpec> const>::Type position(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(511)
template <typename THost, typename TSpec, typename TContainer> inline typename Position<ModifiedIterator<THost, TSpec> const>::Type position(ModifiedIterator<THost, TSpec> const & me, TContainer const &cont);       	// "projects/library/seqan/modifier/modifier_iterator.h"(520)
template <typename THost> inline typename Position<ModifiedIterator<THost, ModReverse> const>::Type position(ModifiedIterator<THost, ModReverse> const & me);       	// "projects/library/seqan/modifier/modifier_reverse.h"(204)
template <typename THost, typename TContainer> inline typename Position<ModifiedIterator<THost, ModReverse> const>::Type position(ModifiedIterator<THost, ModReverse> const & me, TContainer const &cont);       	// "projects/library/seqan/modifier/modifier_reverse.h"(215)

//____________________________________________________________________________
// reverseComplementInPlace

template <typename TSequence > inline void reverseComplementInPlace(TSequence & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(91)
template <typename TSequence > inline void reverseComplementInPlace(TSequence const & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(98)
template <typename TSequence, typename TSpec > inline void reverseComplementInPlace(StringSet<TSequence, TSpec> & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(105)
template <typename TSequence, typename TSpec > inline void reverseComplementInPlace(StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(113)

//____________________________________________________________________________
// reverseInPlace

template <typename TSequence > inline void reverseInPlace(TSequence & sequence);       	// "projects/library/seqan/modifier/modifier_reverse.h"(497)
template <typename TSequence, typename TSpec > inline void reverseInPlace(StringSet<TSequence, TSpec> & stringSet);       	// "projects/library/seqan/modifier/modifier_reverse.h"(515)
template <typename TSequence, typename TSpec > inline void reverseInPlace(StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/modifier/modifier_reverse.h"(524)

//____________________________________________________________________________
// reverseString

template <typename THost> inline ModifiedString<THost, ModReverse> reverseString(THost const & host);       	// "projects/library/seqan/modifier/modifier_reverse.h"(536)

//____________________________________________________________________________
// setContainer

template <typename TIteratorHost, typename TSpec, typename TStringHost> inline void setContainer( ModifiedIterator<TIteratorHost, TSpec> & me, ModifiedString<TStringHost, TSpec> & cont);       	// "projects/library/seqan/modifier/modifier_iterator.h"(245)
template <typename TIteratorHost, typename TSpec, typename TStringHost> inline void setContainer( ModifiedIterator<TIteratorHost, TSpec> & me, ModifiedString<TStringHost, TSpec> const & cont);       	// "projects/library/seqan/modifier/modifier_iterator.h"(255)
template <typename THost, typename TSpec, typename TContainer> inline void setContainer(ModifiedIterator<THost, TSpec> & me, TContainer & cont);       	// "projects/library/seqan/modifier/modifier_iterator.h"(263)

//____________________________________________________________________________
// setPosition

template <typename THost, typename TPosition> inline void setPosition(ModifiedIterator<THost, ModReverse> const & me, TPosition pos);       	// "projects/library/seqan/modifier/modifier_reverse.h"(230)

//____________________________________________________________________________
// setValue

template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, ModifiedString<THost, TSpec> const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(293)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, ModifiedString<THost, TSpec> & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(301)
template <typename THost, typename THostSpec, typename TSpec, typename THost2> inline ModifiedString< ModifiedString<THost, THostSpec>, TSpec> const & setValue( ModifiedString< ModifiedString<THost, THostSpec>, TSpec> & me, THost2 const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(313)
template <typename THost, typename THostSpec, typename TSpec, typename THost2> inline ModifiedString< ModifiedString<THost, THostSpec>, TSpec> const & setValue( ModifiedString< ModifiedString<THost, THostSpec>, TSpec> & me, THost2 & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(323)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(331)
template <typename THost, typename TSpec> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(338)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost2 & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(346)
template <typename THost, typename TSpec, typename THost2> inline ModifiedString<THost, TSpec> const & setValue(ModifiedString<THost, TSpec> & me, THost2 const & _origin);       	// "projects/library/seqan/modifier/modifier_string.h"(353)

//____________________________________________________________________________
// toLowerInPlace

template <typename TSequence > inline void toLowerInPlace(TSequence & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(123)
template <typename TSequence > inline void toLowerInPlace(TSequence const & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(129)
template <typename TSequence, typename TSpec > inline void toLowerInPlace(StringSet<TSequence, TSpec> & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(135)
template <typename TSequence, typename TSpec > inline void toLowerInPlace(StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(143)

//____________________________________________________________________________
// toUpperInPlace

template <typename TSequence > inline void toUpperInPlace(TSequence & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(151)
template <typename TSequence > inline void toUpperInPlace(TSequence const & sequence);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(157)
template <typename TSequence, typename TSpec > inline void toUpperInPlace(StringSet<TSequence, TSpec> & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(163)
template <typename TSequence, typename TSpec > inline void toUpperInPlace(StringSet<TSequence, TSpec> const & stringSet);       	// "projects/library/seqan/modifier/modifier_shortcuts.h"(171)

//____________________________________________________________________________
// value

template <typename THost, typename TSpec, typename TPos> inline typename Reference<ModifiedString<THost, TSpec> >::Type value(ModifiedString<THost, TSpec> & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_string.h"(275)
template <typename THost, typename TSpec, typename TPos> inline typename Reference<ModifiedString<THost, TSpec> const >::Type value(ModifiedString<THost, TSpec> const & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_string.h"(282)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> >::Type value(ModifiedIterator<THost, TSpec> & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(319)
template <typename THost, typename TSpec> inline typename Reference<ModifiedIterator<THost, TSpec> const>::Type value(ModifiedIterator<THost, TSpec> const & me);       	// "projects/library/seqan/modifier/modifier_iterator.h"(328)
template <typename THost, typename TPos> inline typename Reference<ModifiedString<THost, ModReverse> >::Type value(ModifiedString<THost, ModReverse> & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_reverse.h"(393)
template <typename THost, typename TPos> inline typename Reference<ModifiedString<THost, ModReverse> const>::Type value(ModifiedString<THost, ModReverse> const & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_reverse.h"(401)
template <typename THost, typename TFunctor> inline typename Reference<ModifiedIterator<THost, ModView<TFunctor> > >::Type value(ModifiedIterator<THost, ModView<TFunctor> > & me);       	// "projects/library/seqan/modifier/modifier_view.h"(142)
template <typename THost, typename TFunctor> inline typename Reference<ModifiedIterator<THost, ModView<TFunctor> > const>::Type value(ModifiedIterator<THost, ModView<TFunctor> > const & me);       	// "projects/library/seqan/modifier/modifier_view.h"(151)
template <typename THost, typename TFunctor, typename TPos> inline typename Reference<ModifiedString<THost, ModView<TFunctor> > >::Type value(ModifiedString<THost, ModView<TFunctor> > & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_view.h"(283)
template <typename THost, typename TFunctor, typename TPos> inline typename Reference<ModifiedString<THost, ModView<TFunctor> > const>::Type value(ModifiedString<THost, ModView<TFunctor> > const & me, TPos pos);       	// "projects/library/seqan/modifier/modifier_view.h"(292)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

