// -*-c++-*-
/* $Id: str2file.C,v 1.8 1999/11/26 07:53:18 dm Exp $ */

/*
 *
 * Copyright (C) 1998 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include "amisc.h"

bool
str2file (str file, str s, int perm, bool excl)
{
  if (!file.len () || file.len () < strlen (file)) {
    errno = EINVAL;
    return false;
  }
  if (file[file.len () - 1] == '/') {
    errno = EISDIR;
    return false;
  }

  str tmpfile = file << "~";
  unlink (tmpfile);
  int fd = open (tmpfile, O_CREAT|O_EXCL|O_WRONLY, perm);
  if (fd < 0)
    return false;

  if (write (fd, s.cstr (), s.len ()) != int (s.len ()) || fsync (fd) < 0) {
    close (fd);
    unlink (tmpfile);
    return false;
  }
  if (s.len () && s[s.len () - 1] != '\n')
    write (fd, "\n", 1);
  if (close (fd) < 0 || (excl && link (tmpfile, file) < 0)
      || (!excl && rename (tmpfile, file) < 0)) {
    unlink (tmpfile);
    return false;
  }
  if (excl)
    unlink (tmpfile);
  return true;
}

str
file2str (str file)
{
  int fd = open (file, O_RDONLY, 0);
  if (fd < 0)
    return NULL;

  struct stat sb;
  if (fstat (fd, &sb) < 0) {
    close (fd);
    return NULL;
  }
  if (!S_ISREG (sb.st_mode)) {
    warn << file << ": not a regular file\n";
    close (fd);
    errno = EINVAL;
    return NULL;
  }
  mstr m (sb.st_size);
  errno = EAGAIN;
  ssize_t n = read (fd, m, sb.st_size);
  int saved_errno = errno;
  close (fd);
  errno = saved_errno;
  if (n < 0)
    return NULL;
  m.setlen (n);
  return m;
}
