#ifndef gui_tab_panel_h
#define gui_tab_panel_h

#include "../../ifc/gui_action_creator.h"
#include "../../simimg.h"

class bild_besch_t;

/**
 * Eine Klasse fr Registerkartenartige Aufteilung von gui_komponente_t
 * Objekten.
 *
 * @author Hj. Malthaner
 */
class gui_tab_panel_t : public gui_komponente_action_creator_t
{
public:
    enum { HEADER_VSIZE = 18};

    gui_tab_panel_t();

    /**
     * Fgt eine neue Registerkarte hinzu.
     * @param c die Komponente fr die Rgisterkarte
     * @param name der Name der Registerkarte fr die Komponente
     * @author Hj. Malthaner
     */
    void add_tab(gui_komponente_t *c, const char *name, const bild_besch_t *b=NULL, const char *tooltip=NULL );

    /**
     * Gibt die aktuell angezeigte Komponente zurck.
     * @author Hj. Malthaner
     */
    gui_komponente_t* gib_aktives_tab() const { return tabs.at(active_tab).component; }

    int get_active_tab_index() { return active_tab; }

    /**
     * Events werden hiermit an die GUI-Komponenten
     * gemeldet
     * @author Hj. Malthaner
     */
    void infowin_event(const event_t *ev);

    /**
     * Zeichnet die Registerkarten
     * @author Hj. Malthaner
     */
    void zeichnen(koord offset);

    /**
     * Resizing must be propagated!
     * @author Volker Meyer
     * @date  18.06.2003
     */
    void setze_groesse(koord groesse);

	private:
		struct tab
		{
			tab(gui_komponente_t* c, const char *name, const bild_besch_t *b, const char *tool) : component(c), title(name), img(b), tooltip(tool) {}

			gui_komponente_t* component;
			const char *title;
			const bild_besch_t *img;
			const char *tooltip;
		};

		slist_tpl<tab> tabs;
		int active_tab;
};

#endif
