#ifndef _netload_h
#define _netload_h

#include <string>
#include <sys/time.h>

#define IFACESIZE 11

struct Netload
{
  char iface[IFACESIZE];
  float rxbytes;
  float txbytes;

  float rxpkt;
  float txpkt;
};


class NetloadMeter
{
private:
  float nlget_elapsed_time();
  struct timeval oldtime;

  char iface[IFACESIZE];

  unsigned long lastrxbytes;
  unsigned long lastrxpkt;
  unsigned long lasttxbytes;
  unsigned long lasttxpkt;

  const char * selectNetIface();


public:
  NetloadMeter(const std::string _iface ="");

  bool getNetload(Netload & netload);
};

#endif
