# Copyright (c) 2008, 2009, 2010 David Sugar, Tycho Softworks.
# This file is free software; as a special exception the author gives
# unlimited permission to copy and/or distribute it, with or without
# modifications, as long as this notice is preserved.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY, to the extent permitted by law; without
# even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE.

Name: sipwitch
Summary: A secure peer-to-peer VoIP server for the SIP protocol
Version: 1.6.1
Release: 0%{?dist}
License: GPLv3+
URL: http://www.gnu.org/software/sipwitch
Group: Applications/Communications
Source: http://www.gnutelephony.org/dist/tarballs/sipwitch-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: ucommon-devel >= 6.0.0
BuildRequires: libeXosip2-devel >= 3.0.0
BuildRequires: avahi-devel
BuildRequires: openssl-devel
Requires(post): systemd
Requires(preun): systemd
Requires(postun): systemd
Requires: %{name}-runtime = %{version}-%{release}

%package runtime
Group: Development/Libraries
Summary: Runtime library support for sipwitch

%package devel
Requires: ucommon-devel >= 6.0.0
Requires: %{name}-runtime = %{version}-%{release}
Group: Development/Libraries
Summary: Headers for building sipwitch plugins

%package cgi
Requires: %{name} = %{version}-%{release}
Group: Applications/CGI
Summary: cgi web interface to control sipwitch server

%package plugin-zeroconf
Requires: %{name} = %{version}-%{release}
Summary: Zeroconf plugin for sipwitch

%package plugin-scripting
Requires: %{name} = %{version}-%{release}
Summary: Scripting plugin for sipwitch

%package plugin-forward
Requires: %{name} = %{version}-%{release}
Summary: Forward registration and routing plugin

%package plugin-subscriber
Requires: %{name} = %{version}-%{release}
Summary: Subscriber gateway plugin for sipwitch

%description
GNU SIP Witch is a secure peer-to-peer VoIP server.  Calls can be made even
behind NAT firewalls, and without needing a service provider.  SIP Witch can
be used on the desktop to create bottom-up secure calling networks as a
free software alternative to Skype.  SIP Witch can also be used as a stand-
alone SIP-based office telephone server, or to create secure VoIP networks
for an existing IP-PBX such as Asterisk, FreeSWITCH, or Yate.

%description devel
Header files for building plugins that interface with sipwitch. This might be
used for externally creating sipwitch modules, though normally modules are
found or added to the core distribution directly.  This may also be for
developing external application services which need to communicate with a
running sipwitch daemon instance.

%description runtime
Runtime library required for sipwitch development and for using the server.
This is available as a separate package so that one building sipwitch plugins
with the required devel package does not also require installing a server
image.

%description cgi
This package offers a means to perform remote management of a sipwitch
server using the cgi interface of an installed web server.  The primary
service this offers is xmlrpc access to sipwitch shared memory and
control interfaces in a manner analgolous to the sipwitch command utility.

%description plugin-zeroconf
This plugin activates zeroconf network services for sipwitch and publishes
sipwitch as a sip server.

%description plugin-scripting
This plugin enables shell scripting in connection with specific sipwitch
events.

%description plugin-forward
This plugin enables forwarding of registration requests and destination routes
for unknown numbers so that one can create a "secure" peer to peer media
domain managed by sipwitch and still access an "insecure" b2bua based ip-pbx.

%description plugin-subscriber
This module is meant to eventually offer generic support for premise
routers when used by providers to offer sip/voip service to a subscriber.
It offers rtp proxying and routing based on the assumption that all calls
will be handed off to an external voip provider and automatic rtp
proxy bridging between a subscribers local subnet and an isp.  In theory
this would be deployed in an isp supplied premise router to enable a
local user to subscribe a series of local softphone/sip devices with a
remote voip service provider.

%prep
%setup -q
%build
%configure --with-pkg-config --disable-static --with-initrddir=none

%{__make} %{?_smp_mflags}

%install
%{__rm} -rf %{buildroot}
%{__make} DESTDIR=%{buildroot} INSTALL="install -p" install
%{__rm} -f %{buildroot}/%{_libdir}/*.la
%{__rm} -f %{buildroot}/%{_libdir}/sipwitch/*.la
echo "PLUGINS=auto" >>%{buildroot}/%{_sysconfdir}/sysconfig/sipwitch

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root,-)
%doc README COPYING NEWS FEATURES SUPPORT TODO NOTES AUTHORS MODULES ChangeLog
%{_mandir}/man1/sipwitch.1*
%{_mandir}/man1/sippasswd.1*
%{_mandir}/man1/sipquery.1*
%{_mandir}/man8/sipw.8*
%{_sbindir}/sipw
%{_bindir}/sipquery
%{_bindir}/sipwitch
%attr(04755,root,root) %{_bindir}/sippasswd
%dir %{_libdir}/sipwitch
%config(noreplace) %{_sysconfdir}/logrotate.d/sipwitch
%attr(0755,root,root) %{_libdir}/systemd/system/sipwitch.service
%attr(0755,root,root) %{_sysconfdir}/cron.hourly/sipwitch
%attr(0770,root,root) %dir %{_sysconfdir}/sipwitch.d
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sipwitch.conf
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sysconfig/sipwitch
%attr(0660,root,root) %config(noreplace) %{_sysconfdir}/sipwitch.d/*.xml*

%files cgi
%defattr(-,root,root,-)
%{_mandir}/man8/sipwitch-cgi.8*
%{_bindir}/sipwitch-cgi
%{_libdir}/cgi-bin/sipwitch

%files runtime
%defattr(-,root,root,-)
%{_libdir}/*.so.*

%files plugin-zeroconf
%defattr(-,root,root,-)
%{_libdir}/sipwitch/zeroconf.so

%files plugin-forward
%defattr(-,root,root,-)
%{_libdir}/sipwitch/forward.so

%files plugin-scripting
%defattr(-,root,root,-)
%{_libdir}/sipwitch/scripting.so

%files plugin-subscriber
%defattr(-,root,root,-)
%{_libdir}/sipwitch/subscriber.so

%files devel
%defattr(-,root,root,-)
%{_libdir}/*.so
%{_includedir}/sipwitch/
%{_libdir}/pkgconfig/*.pc
%{_bindir}/sipwitch-config
%{_mandir}/man1/sipwitch-config.*

%post runtime
/sbin/ldconfig

%post
%systemd_post sipwitch.service

%preun
%systemd_preun sipwitch.service

%postun
%systemd_postun_with_restart sipwitch.service 

%postun runtime
/sbin/ldconfig

%changelog
* Sun Mar 14 2010 David Sugar <dyfet@gnutelephony.org> - 0.7.4-0
- fixed sippasswd to send digest rather than realm to running server.
- separated packaging and install of cgi webservice.
- new runtime server debug and monitoring operations.

* Fri Feb 12 2010 David Sugar <dyfet@gnutelephony.org> - 0.7.1-0
- Moved lab.xml to lab.xml-example so not part of default config.
- Removed config conflict when started in pure user mode.

* Sun Feb 07 2010 David Sugar <dyfet@gnutelephony.org> - 0.7.0-0
- NAT media functionality and internodal remote.
- merger of domain and realm server definitions.
- clearer source aliasing of remote calls between network domains.

* Sat Jan 23 2010 David Sugar <dyfet@gnutelephony.org> - 0.6.2-0
- use uuid for unset authentication realms.
- saner default configuration file.

* Wed Jan 20 2010 David Sugar <dyfet@gnutelephony.org> - 0.6.1-0
- user account integration with sip accounts.
- exec hook for packaging systems that done use fakeroot.

* Sun Jan 17 2010 David Sugar <dyfet@gnutelephony.org> - 0.5.13-0
- sip realm fully externalized and new siprealm utility added.

* Wed Dec 09 2009 David Sugar <dyfet@gnutelephony.org> - 0.5.12-0
- redefined internal user & service permissions and profiles.
- fixed anonymous inbound.
- added missing manpages.

* Thu Nov 18 2009 David Sugar <dyfet@gnutelephony.org> - 0.5.9-0
- removed snmp/mib from this package
- removed unused swig support and complex packaging it required.

* Fri Aug 14 2009 David Sugar <duyfet@gnutelephony.org> - 0.5.7-1
- memory corruption issue in allocating subnet access objects fixed

* Mon Jul 13 2009 Remi Collet <Fedora@FamilleCollet.com> - 0.5.6-1
- rebuild for new PHP 5.3.0 ABI (20090626)
- add PHP ABI check
- add php configuration file (/etc/php.d/sipwitch.ini)

* Sat Jul 04 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.6-0
- split runtime from server to build plugins without requiring server.
- removed separate rtp proxy, functionality will be integrated into server.

* Wed Jun 10 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.5-0
- upstream fixed in rel 0.5.5, no patches now needed for rpm distros.

* Sun May 10 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-3
- new generic init script layout as a patch until next upstream release.

* Fri May 08 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-2
- some fixups until upstream is changed, and new init scriptlets.

* Wed May 06 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-1
- temporary patch file added until upstream catches up, other cleanup.

* Sat May 02 2009 - David Sugar <dyfet@gnutelephony.org> - 0.5.4-0
- spec file updated for redhat/fedora submission.

* Fri Jul 25 2008 - David Sugar <dyfet@gnutelephony.org> - 0.2.0-0
- spec file updated for plugins and new library naming.

* Mon Jul 21 2008 - David Sugar <dyfet@gnutelephony.org> - 0.1.0-0
- initial spec file distribution.

