/*
 * Copyright (c) 1994  Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * Author:  Makoto Ishisone, Software Research Associates, Inc., Japan
 */
#include <stdio.h>
#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/Xfuncs.h>
#include "imbuf.h"

static void allocIMBuf( IMBuffer *ibp, int len )
{
  int newsize ;

  if( ibp->size >= len )
    return ;
  newsize = ibp->size * 2 ;
  if( newsize < len )
    newsize = len ;
  if( ibp->buf == ibp->internal ){
    ibp->buf = malloc( newsize ) ;
    memcpy( ibp->buf, ibp->internal, ibp->size ) ;
  } else {
    ibp->buf = realloc( ibp->buf, newsize ) ;
  }
  ibp->size = newsize ;
  return ;
}

void IMBufInit( IMBuffer *ibp )
{
  ibp->buf = ibp->internal ;
  IMBufClear( ibp ) ;
  return ;
}

void IMBufClear( IMBuffer *ibp )
{
  if( ibp->buf != NULL && ibp->buf != ibp->internal )
    free( ibp->buf ) ;
  ibp->buf = ibp->internal ;
  ibp->size = sizeof( ibp->internal ) ;
  ibp->start = ibp->end = 0 ;
  return ;
}

void IMBufAdd
( IMBuffer *ibp, char *data, int len )
{
  allocIMBuf( ibp, ibp->end + len ) ;
  memcpy( ibp->buf + ibp->end, data, len ) ;
  ibp->end += len ;
  return ;
}

void IMBufOverwrite
( IMBuffer *ibp, int offset, char *data, int len )
{
  int dend ;

  dend = ibp->start + offset + len ;
  allocIMBuf( ibp, dend ) ;
  memcpy( ibp->buf + ibp->start + offset, data, len ) ;
  if( ibp->end < dend )
    ibp->end = dend ;
  return ;
}

char *IMBufAlloc( IMBuffer *ibp, int len )
{
  char *p ;

  allocIMBuf( ibp, ibp->end + len ) ;
  p = ibp->buf + ibp->end ;
  ibp->end += len ;
  return p ;
}

void IMBufDiscard( IMBuffer *ibp, int len )
{
  if( len > 0 ){
    /* discard top of the data */
    ibp->start += len ;
  } else {
    /* discard end of the data */
    ibp->end += len ;
  }
  if( ibp->start >= ibp->end )
    IMBufClear( ibp ) ;
  return ;
}

void IMBufDiscardNUL( IMBuffer *ibp )
{
  while( ibp->start < ibp->end ){
    if( ( ibp->buf )[ ibp->start ] != 0 )
      break ;
    ibp->start++ ;
  }
  if( ibp->start >= ibp->end )
    IMBufClear( ibp ) ;
  return ;
}

void IMBufCompact( IMBuffer *ibp )
{
  if( ibp->buf != ibp->internal ){
    int length = IMBUFLEN( ibp ) ;

    if( length <= sizeof( ibp->internal ) ){
      memcpy( ibp->internal, ibp->buf + ibp->start, length ) ;
      free( ibp->buf ) ;
      ibp->buf = ibp->internal ;
      ibp->size = sizeof( ibp->internal ) ;
    } else {
      memcpy( ibp->buf, ibp->buf + ibp->start, length ) ;
    }
    ibp->start = 0 ;
    ibp->end = length ;
  } else if( ibp->start != 0 ){
    int length = IMBUFLEN( ibp ) ;

    memcpy( ibp->buf, ibp->buf + ibp->start, length ) ;
    ibp->start = 0 ;
    ibp->end = length ;
  }
  return ;
}
