#!@@PERL@@
#
# This program can be used to send Status update messages to the Spong Server 
# from shell scripts or other external programs. 
#
# $Id: spong-status.pl,v 1.7 2000/10/16 15:34:32 sljohnson Exp $

use POSIX;
use Getopt::Long;
use FileHandle;

use lib "@@LIBDIR@@";

use Spong::Status;
use Spong::Log;

# Load our configuration variables, including the user specified configuration
# information (spong.conf, spong.hosts, and spong.groups files).

$|++;
$conf_file   = "@@ETCDIR@@/spong.conf";

&load_config_files();  # Loads the user specified configuration information
init_logging();        # Initialize the logging for the command

# Get the user options and spit back a usage message if they do something silly

%opt;
@options = ( "help", "host=s", "service=s", "color|status=s", "summary=s",
             "cmd=s", "message=s", "ttl=i", "file=s" );

Getopt::Long::Configure("pass_through");
if( ! GetOptions( \%opt, @options ) ) { warn "Incorrect usage:\n\n"; &help(); }

&help if defined $opt{'help'};

#$opt{'cmd'} = 'status' if ! defined $opt{'cmd'};
#if ( $opt{'cmd'} !~ /^(status)$/) { warn "Invalid --cmd\n\n;" &help(); }
#if ( ! defined $opt{'host'} ) { warn "--host is required\n\n"; &help(); }
#if ( ! defined $opt{'service'} ) { warn "--service is required\n\n"; &help(); }
#if ( $opt{'color'} !~ /(red|yellow|green)/ ) {
#   warn "Invalid status color. Must be red, yellow or green.\n\n"; &help(); }
#if ( ! defined $opt{'summary'} ) { warn "--summary is required."; &help(); }

my($cmd, $host, $service, $color, $summary, $ttl) = @ARGV;

if (! $cmd && defined $opt{'cmd'}) { $cmd = $opt{'cmd'}; }
if ( $cmd !~ m/status|event|page/ ) { warn "Invalid cmd\n\n"; &help(); }
if ( ! $host && defined $opt{'host'} ) { $host = $opt{'host'}; }
if ( ! $host ) { warn "Host is required\n\n"; &help(); }
if ( ! $service && defined $opt{'service'} ) { $service = $opt{'service'}; }
if ( ! $service ) { warn "Service name is required\n\n"; &help(); }
if ( ! $color && defined $opt{'color'} ) { $color = $opt{'color'}; }
if ( $color !~ /red|yellow|green/ ) {
   warn "Invalid status color. Must be green, yellow, or red.\n\n";
}
if ( ! $summary && defined $opt{'summary'} ) { $summary = $opt{'summary'}; }
if ( ! $summary ) { warn "Summary text is required\n\n"; &help(); }
if ( ! defined $opt{'message'} && ! defined $opt{'file'} ) {
   warn "--message or --file is required\n\n"; &help(); }
if ( defined $opt{'message'} && defined $opt{'file'} ) {
   warn "Only one of --message or --file can be specified\n\n"; &help(); }

$ttl = defined $opt{'ttl'} ? $opt{'ttl'} : 0;

# Handle message file processing if necessary
my ( $message ) = "";
if ( $opt{'message'} ) { $message = $opt{'message'}; }
elsif ( $opt{'file'} eq '-' ) { while (<STDIN>) { $message .= $_; } }
else {
   my($fh) = File::Handle->new($opt{'file'});
   if (! defined $fh ) {
      warn "Could not open file " . $opt{'file'} . "\n\n";
      exit 1;
   }
   while (<$fh>) { $message .= $_; }
   undef $fh;
}

if ( $cmd eq 'status' ) {
   Spong::Status::status( $SPONGSERVER, $host, $service, $color, $summary,
                          $message, $ttl );
} elsif ( $cmd eq 'event') {
   Spong::Status::event( $SPONGSERVER, $host, $service, $color, $summary,
                          $message, $ttl );
} elsif ( $cmd eq 'page') {
   Spong::Status::page( $SPONGSERVER, $host, $service, $color, $summary,
                          $message, $ttl );
}



exit 0;

sub help {
   print <<'_EOF_';
Usage: spong-status [--help]
       spong-status [--ttl #] (--file name | --message "message text") CMD HOST
                    SERVICE COLOR "SUMMARY TEXT"
       spong-status [--cmd cmd] --host name --service name --color color 
                    --summary text [--message text | -f filename] 
                    [--ttl seconds]
                   

Where "options" are:
   --help               Print this help text.
   --cmd     status             Command type being sent to Spong Server. 
                                Defaults to 'status'.
   --host    name               Name of the host being reported.
   --service name               Name of the service being reported.
   --color   green|yellow|red   Status color being reported.
   --summary text               Summary text to be reported.
   --ttl     #seconds           Time to live of status report in seconds.

   --message text               Detailed message text being reported.
   --file    filename           Detailed message info read from file.
                                If file is '-', info is read from stdin.

Note: --message and --file are mutually exclusive. Only one my be specified.

_EOF_

   exit 0;
}

# This function just loads in all the configuration information from the 
# spong.conf.  The spong.hosts and spong.group files are not needed - all the
# hosts and groups smarts take place on the spong-server.

sub load_config_files {
   my( $evalme, $inhosts );

   require $conf_file || die "Can't load $conf_file: $!";
   if( -f "$conf_file.$HOST" ) {
      require "$conf_file.$HOST" || die "Can't load $conf_file.$HOST: $!";
   } else {
      my $tmp = (split( /\./, $HOST ))[0];
      if( -f "$conf_file.$tmp" ) { # for lazy typist
	 require "$conf_file.$tmp" || die "Can't load $conf_file.$tmp: $!";
      }
   }
}

# Output functions

sub error { print STDERR scalar localtime,": $_\n"; }

