/* Copyright (C) 2000, 2001  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
inherit "/net/coal/login";
inherit "/kernel/socket";

#include <macros.h>

#define RPC_LOG(s) werror(s+"\n");

static string      call_data = "";
static mapping         header = 0;

static mapping parse_header(string data)
{
    array h = data / "\r\n\r\n";
    string         header, body;
    mapping               mhead;
    
    RPC_LOG("Parsing:\n"+sprintf("%O\n",h));
    if ( sizeof(h) != 2 )
	return 0;

    [header, body] = h;
    mhead = ([ "rest": body, ]);
    
    array lines = header / "\r\n";
    string url, key, val;
    sscanf(lines[0], "%*s %s HTTP/%*s", url);
    mhead["url"] = url;
    for ( int i = sizeof(lines) - 1; i >= 1; i-- )
	if ( sscanf(lines[i], "%s: %s", key, val) == 2 )
	    mhead[lower_case(key)] = val;
    RPC_LOG("Parsed header:\n"+sprintf("%O\n", mhead));
    return mhead;
}

static void rpc_call(string data)
{
    //object c = Protocols.XMLRPC.decode_call(data);
    //RPC_LOG("CALL:\n"+sprintf("%O",c));
    
}

static void read_callback(mixed id, string data)
{
    RPC_LOG("Got:"+data);
    call_data += data;
    if ( !mappingp(header) ) {
	header = parse_header(call_data);
    }
    if ( mappingp(header) ) {
	if ( stringp(header["rest"]) )
	    call_data = header["rest"];
	m_delete(header, "rest");
	if ( strlen(call_data) >= (int)header["content-length"] ) {
	    rpc_call(call_data[..(int)header["content-length"]]);
	    call_data = call_data[(int)header["content_length"]+1..];
	    header = 0;
	}
    }
}


