#ifndef __KEY_STACK__
#define __KEY_STACK__
#include "sufary.h"

#define is_EUC(x)   (*(x) & 0x80)
#define is_kanaH(x) (*(x) == 0xA4)
#define is_kanaK(x) (*(x) == 0xA5)
#define is_TEN(x)   (*(x) == 0xA1 && *(x+1) > 0xA1 && *(x+1) < 0xA6)
#define is_Br(x)    (*(x) == 0xA1 && *(x+1) > 0xC9 && *(x+1) < 0xDC)
#define is_Space(x) (*(x) == 0xA1 && *(x+1) == 0xA1)
#define is_Line(x)  (*(x) == 0xA1 && *(x+1) == 0xBD)
#define is_Tyou(x)  (*(x) == 0xa1 && *(x+1) == 0xbc)
#define is_Alpha(x) (*(x) == 0xA3 && *(x+1) >= 0xC1 && *(x+1) <= 0xFA)

#define is_kigou(x) ((*(x) > 0x00 && *(x) <= 0x20) || *(x) == 0x22 || *(x) == 0x27 || *(x) == 0x2c)
#define is_space(x) (*(x) == ' ' || *(x) == '\t' || *(x) == '\n')

#define EUC	0x0001
#define HIRA	0x0003
#define KATA	0x0005
#define TYOU	0x0007
#define KANJI	0x0009
#define SEP	0x0010
#define NL	0x8030
#define ASCII	0x8000

typedef struct {
    int    num;
    int    max;
    unsigned char** str;
    int*   len;
} KeyBuffer;

void init_key_buf (KeyBuffer* keys);
void clear_key (KeyBuffer* keys);
void push_key (KeyBuffer* keys, unsigned char* start, unsigned char* end);


int chartype (unsigned char* s);
int parse_by_chartype (KeyBuffer* keys, unsigned char* str);
int parse_by_ngram (KeyBuffer* keys, unsigned char* str, int N);
int parse_by_mozdic (KeyBuffer* keys, unsigned char* str, SUFARY* sa);

#endif
