/*
 * systlog.h - convenience header for <syslog.h>
 * $Id: systlog.h,v 1.1 2003/01/26 09:11:31 rdenisc Exp $
 * 
 * Feel free to use in your own GPL programs.
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Pulic License   *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifndef __TCPREEN_SYSLOG_H

# define __TCPREEN_SYSLOG_H

# if HAVE_SYSLOG_H
#  include <syslog.h>
# endif

# if !HAVE_SYSLOG
#  ifdef __cplusplus
extern "C" {
#  endif

void openlog (const char *ident, int option, int facility);
void syslog (int priority, const char *fmt, ...);
void closelog (void);

#  define LOG_CONS	0x02
#  define LOG_NDELAY	0x08
#  define LOG_NOWAIT	0x10
#  define LOG_ODELAY	0x04
#  define LOG_PERROR	0x20
#  define LOG_PID	0x01

#  define LOG_AUTH	0040
#  define LOG_AUTHPRIV	0120
#  define LOG_CRON	0110
#  define LOG_DAEMON	0030
#  define LOG_FTP	0130
#  define LOG_LOCAL0	0200
#  define LOG_LOCAL1	0210
#  define LOG_LOCAL2	0220
#  define LOG_LOCAL3	0230
#  define LOG_LOCAL4	0240
#  define LOG_LOCAL5	0250
#  define LOG_LOCAL6	0260
#  define LOG_LOCAL7	0270
#  define LOG_LPR	0060
#  define LOG_MAIL	0020
#  define LOG_NEWS	0070
#  define LOG_SYSLOG	0050
#  define LOG_USER	0010
#  define LOG_UUCP	0100

#  define LOG_EMERG	0
#  define LOG_ALERT	1
#  define LOG_CRIT	2
#  define LOG_ERR	3
#  define LOG_WARNING	4
#  define LOG_NOTICE	5
#  define LOG_INFO	6
#  define LOG_DEBUG	7

#  ifdef __cplusplus
}
#  endif
# endif /* not HAVE_SYSLOG */
#endif /* not defined __TCPREEN_SYSLOG_H */

