/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

const char aa1[] = "ARNDCQEGHILKMFPSTWYV";
const char aa3[] = "ALAARGASNASPCYSGLNGLUGLYHISILELEULYSMETPHEPROSERTHRTRPTYRVAL";
const char aan1[] = "ARNDCQEGHILKMFPSTWYVACGTTACGTT";
const char aan3[] = "ALAARGASNASPCYSGLNGLUGLYHISILELEULYSMETPHEPROSERTHRTRPTYRVAL  A  C  G  T  UADECYTGUATHYURA";
const char ss1[] = "GHTBESC ";

/* These are all in nats, *not* bits */

const double aafreq_blosum50[20] = 
{
    0.077728, 0.051421, 0.041057, 0.052374, 0.024305,
    0.034190, 0.058888, 0.083353, 0.024669, 0.061626,
    0.091523, 0.055505, 0.023998, 0.043753, 0.042841,
    0.058601, 0.054652, 0.013777, 0.034064, 0.071673,
};


/* Andreas Prlic, Francisco S. Domingues, and Manfred J. Sippl
   Structure-derived substitution matrices for alignment of distantly related sequences
   Protein Eng. 2000 13: 545-550 
   http://peds.oxfordjournals.org/cgi/content/abstract/13/8/545
*/
const double s_dssp8[8][8] = 
{
    /*     G         H         T         B         E         S         C         X */
    { 5.4620,  -0.5337,   1.4210,  -1.0120,  -5.8987,   0.1594,  -0.8041,  -1.8230},
    {-0.5337,   1.5873,  -1.1784,  -5.7046, -12.9965,  -3.4796,  -4.3252,  -4.0341},
    { 1.4210,  -1.1784,   3.7361,  -1.5457,  -3.4727,   1.2962,  -0.7902,  -1.2546},
    {-1.0120,  -5.7046,  -1.5457,   6.9037,   0.5268,   0.7347,   1.0467,  -2.1210},
    {-5.8987, -12.9965,  -3.4727,   0.5268,   2.1557,  -1.6428,  -0.6030,  -5.3303},
    { 0.1594,  -3.4796,   1.2962,   0.7347,  -1.6428,   3.7915,   1.2130,  -1.4487},
    {-0.8041,  -4.3252,  -0.7902,   1.0467,  -0.6030,   1.2130,   2.7934,  -1.5942},
    {-1.8230,  -4.0341,  -1.2546,  -2.1210,  -5.3303,  -1.4487,  -1.5942,  -3.6667},
};


const double s_simple[20][20] = 
{
    {  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0, -1.0},
    { -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0,  1.0},
};

const double s_simpler[20][20] = 
{
    {  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0,  1.0},
    {  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  1.0,  2.0},
};

const double s_hsdm[20][20] = 
{
    { 0.7625, -0.3105, -0.2454, -0.3299,  0.0624, -0.2994, -0.0652,  0.0873, -0.4173, -0.2384, -0.1511, -0.1691,  0.0222, -0.3355, -0.1539,  0.1761,  0.0832, -0.3618, -0.5850,  0.0222},
    {-0.3105,  1.1908,  0.0333, -0.0457, -0.8720, -0.1026,  0.3923, -0.4700,  0.0970, -0.5448, -0.3923,  0.5393, -0.1982, -0.6044,  0.1816, -0.0693,  0.0471,  0.1414, -0.1400, -0.5268},
    {-0.2454,  0.0333,  1.3863,  0.5642, -0.9053,  0.1969, -0.0541,  0.1608,  0.2454, -0.8013, -0.7819,  0.2274, -0.6474, -0.8623, -0.4478,  0.2135,  0.1580, -0.8720, -0.1289, -0.7833},
    {-0.3299, -0.0457,  0.5642,  1.5263, -0.9676,  0.1525,  0.3341, -0.5420,  0.0444, -0.8567, -1.0272,  0.2121, -1.0924, -0.7015,  0.1123,  0.3244, -0.1885, -0.7805, -0.5337, -0.8456},
    { 0.0624, -0.8720, -0.9053, -0.9676,  2.6409, -0.3424, -0.6516, -0.7902, -0.8248, -0.0180, -0.1137, -0.9219,  0.4852,  0.2384, -0.9288,  0.1497, -0.2620, -0.4173, -0.0610,  0.1830},
    {-0.2994, -0.1026,  0.1969,  0.1525, -0.3424,  1.0882,  0.4381, -0.0333, -0.3105, -0.4519, -0.6322,  0.4492, -0.2440, -0.7680,  0.1802,  0.3591,  0.1497, -0.5961, -0.2398, -0.6890},
    {-0.0652,  0.3923, -0.0541,  0.3341, -0.6516,  0.4381,  1.1686, -0.2495, -0.1788, -0.8165, -0.7791,  0.4270, -0.5462, -0.6155, -0.0596,  0.0582, -0.0846, -0.8706, -0.6238, -0.5864},
    { 0.0873, -0.4700,  0.1608, -0.5420, -0.7902, -0.0333, -0.2495,  1.6136, -0.1719, -1.1894, -0.9080, -0.2523, -0.7333, -1.0342, -0.2481,  0.0873, -0.3105, -0.6613, -0.6017, -0.7375},
    {-0.4173,  0.0970,  0.2454,  0.0444, -0.8248, -0.3105, -0.1788, -0.1719,  2.1793, -0.6155, -0.3452, -0.0236, -0.5074,  0.0347, -0.4921, -0.3299, -0.1580, -0.7916,  0.1622, -0.2260},
    {-0.2384, -0.5448, -0.8013, -0.8567, -0.0180, -0.4519, -0.8165, -1.1894, -0.6155,  0.9344,  0.5351, -0.6682,  0.4076,  0.3188, -0.5601, -0.6474, -0.4200, -0.0360, -0.0111,  0.7250},
    {-0.1511, -0.3923, -0.7819, -1.0272, -0.1137, -0.6322, -0.7791, -0.9080, -0.3452,  0.5351,  0.8845, -0.8193,  0.5989,  0.5407, -0.3993, -0.8623, -0.3327, -0.0804,  0.2509,  0.3161},
    {-0.1691,  0.5393,  0.2274,  0.2121, -0.9219,  0.4492,  0.4270, -0.2523, -0.0236, -0.6682, -0.8193,  1.1409, -0.7583, -0.8581, -0.1677, -0.0374, -0.0513, -0.7555, -0.5587, -0.4949},
    { 0.0222, -0.1982, -0.6474, -1.0924,  0.4852, -0.2440, -0.5462, -0.7333, -0.5074,  0.4076,  0.5989, -0.7583,  1.4154,  0.3688, -0.2800, -0.5434, -0.7181,  0.5933, -0.6862,  0.1636},
    {-0.3355, -0.6044, -0.8623, -0.7015,  0.2384, -0.7680, -0.6155, -1.0342,  0.0347,  0.3188,  0.5407, -0.8581,  0.3688,  1.2671, -0.4103, -0.6973, -0.5545,  0.8997,  0.7458,  0.0721},
    {-0.1539,  0.1816, -0.4478,  0.1123, -0.9288,  0.1802, -0.0596, -0.2481, -0.4921, -0.5601, -0.3993, -0.1677, -0.2800, -0.4103,  1.8465, -0.1774,  0.3383, -1.5887, -1.0272, -0.3202},
    { 0.1761, -0.0693,  0.2135,  0.3244,  0.1497,  0.3591,  0.0582,  0.0873, -0.3299, -0.6474, -0.8623, -0.0374, -0.5434, -0.6973, -0.1774,  0.8803,  0.4284, -0.6155, -0.5781, -0.3729},
    { 0.0832,  0.0471,  0.1580, -0.1885, -0.2620,  0.1497, -0.0846, -0.3105, -0.1580, -0.4200, -0.3327, -0.0513, -0.7181, -0.5545,  0.3383,  0.4284,  0.8775, -0.4921, -0.4048, -0.0319},
    {-0.3618,  0.1414, -0.8720, -0.7805, -0.4173, -0.5961, -0.8706, -0.6613, -0.7916, -0.0360, -0.0804, -0.7555,  0.5933,  0.8997, -1.5887, -0.6155, -0.4921,  2.5064,  0.9413, -0.2953},
    {-0.5850, -0.1400, -0.1289, -0.5337, -0.0610, -0.2398, -0.6238, -0.6017,  0.1622, -0.0111,  0.2509, -0.5587, -0.6862,  0.7458, -1.0272, -0.5781, -0.4048,  0.9413,  1.5138,  0.0915},
    { 0.0222, -0.5268, -0.7833, -0.8456,  0.1830, -0.6890, -0.5864, -0.7375, -0.2260,  0.7250,  0.3161, -0.4949,  0.1636,  0.0721, -0.3202, -0.3729, -0.0319, -0.2953,  0.0915,  0.7320},
};

const double s_blosum30[20][20] = 
{
    { 0.5433, -0.1314, -0.0386,  0.0665, -0.3513,  0.1260, -0.0648, -0.0597, -0.2770, -0.0568, -0.2036, -0.0308,  0.0746, -0.2087, -0.1370,  0.1345,  0.1145, -0.6291, -0.5876,  0.1343 },
    {-0.1314,  1.1549, -0.2940, -0.1896, -0.3037,  0.3897, -0.1658, -0.2929, -0.1807, -0.4233, -0.3324,  0.1919, -0.0399, -0.1163, -0.1840, -0.0740, -0.3685, -0.0681,  0.0659, -0.2027 },
    {-0.0386, -0.2940,  1.1097,  0.1576, -0.1447, -0.0869, -0.0876,  0.0323, -0.1020, -0.0308, -0.2137,  0.0469, -0.0426, -0.1363, -0.4173,  0.0191,  0.1487, -0.9424, -0.6158, -0.2364 },
    { 0.0665, -0.1896,  0.1576,  1.1829, -0.3491, -0.0728,  0.0995, -0.1196, -0.3437, -0.5465, -0.1496, -0.0225, -0.3789, -0.7501, -0.1100, -0.0166, -0.0829, -0.5745, -0.1862, -0.2637 },
    {-0.3513, -0.3037, -0.1447, -0.3491,  2.3581, -0.3032,  0.0908, -0.5320, -0.6970, -0.2345, -0.0379, -0.4363, -0.3365, -0.3566, -0.4699, -0.2585, -0.2999, -0.2131, -0.8437, -0.3219 },
    { 0.1260,  0.3897, -0.0869, -0.0728, -0.3032,  1.0875,  0.2253, -0.2788, -0.0228, -0.2350, -0.2261, -0.0218, -0.1340, -0.4820, -0.0265, -0.1192, -0.0587, -0.1813, -0.1613, -0.4239 },
    {-0.0648, -0.1658, -0.0876,  0.0995,  0.0908,  0.2253,  0.8822, -0.2743,  0.0082, -0.4481, -0.1226,  0.3394, -0.1056, -0.5413,  0.1018, -0.0628, -0.2563, -0.1124, -0.3179, -0.4269 },
    {-0.0597, -0.2929,  0.0323, -0.1196, -0.5320, -0.2788, -0.2743,  1.1701, -0.3506, -0.1548, -0.2881, -0.1347, -0.2398, -0.4090, -0.0723,  0.0622, -0.2151,  0.1646, -0.4557, -0.3522 },
    {-0.2770, -0.1807, -0.1020, -0.3437, -0.6970, -0.0228,  0.0082, -0.3506,  2.0014, -0.3065, -0.1897, -0.2993,  0.2929, -0.4614,  0.1266, -0.1070, -0.3364, -0.6692, -0.0055, -0.4565 },
    {-0.0568, -0.4233, -0.0308, -0.5465, -0.2345, -0.2350, -0.4481, -0.1548, -0.3065,  0.8034,  0.2355, -0.2633,  0.1105,  0.0555, -0.3934, -0.1101, -0.0154, -0.4603, -0.0950,  0.5325 },
    {-0.2036, -0.3324, -0.2137, -0.1496, -0.0379, -0.2261, -0.1226, -0.2881, -0.1897,  0.2355,  0.4904, -0.2295,  0.3073,  0.2834, -0.3850, -0.2406,  0.0437, -0.2177,  0.3511,  0.2056 },
    {-0.0308,  0.1919,  0.0469, -0.0225, -0.4363, -0.0218,  0.3394, -0.1347, -0.2993, -0.2633, -0.2295,  0.5495,  0.2743, -0.1640,  0.0918,  0.0680, -0.1314, -0.2594, -0.1966, -0.2794 },
    { 0.0746, -0.0399, -0.0426, -0.3789, -0.3365, -0.1340, -0.1056, -0.2398,  0.2929,  0.1105,  0.3073,  0.2743,  0.8893, -0.2326, -0.5482, -0.3394, -0.0539, -0.3873, -0.0770,  0.0677 },
    {-0.2087, -0.1163, -0.1363, -0.7501, -0.3566, -0.4820, -0.5413, -0.4090, -0.4614,  0.0555,  0.2834, -0.1640, -0.2326,  1.3488, -0.5983, -0.0896, -0.3083,  0.1812,  0.4264,  0.0977 },
    {-0.1370, -0.1840, -0.4173, -0.1100, -0.4699, -0.0265,  0.1018, -0.0723,  0.1266, -0.3934, -0.3850,  0.0918, -0.5482, -0.5983,  1.5762, -0.1664, -0.0323, -0.4268, -0.2939, -0.4887 },
    { 0.1345, -0.0740,  0.0191, -0.0166, -0.2585, -0.1192, -0.0628,  0.0622, -0.1070, -0.1101, -0.2406,  0.0680, -0.3394, -0.0896, -0.1664,  0.5799,  0.2773, -0.4507, -0.2934, -0.1533 },
    { 0.1145, -0.3685,  0.1487, -0.0829, -0.2999, -0.0587, -0.2563, -0.2151, -0.3364, -0.0154,  0.0437, -0.1314, -0.0539, -0.3083, -0.0323,  0.2773,  0.7166, -0.6304, -0.1494,  0.1497 },
    {-0.6291, -0.0681, -0.9424, -0.5745, -0.2131, -0.1813, -0.1124,  0.1646, -0.6692, -0.4603, -0.2177, -0.2594, -0.3873,  0.1812, -0.4268, -0.4507, -0.6304,  2.8399,  0.7212, -0.4021 },
    {-0.5876,  0.0659, -0.6158, -0.1862, -0.8437, -0.1613, -0.3179, -0.4557, -0.0055, -0.0950,  0.3511, -0.1966, -0.0770,  0.4264, -0.2939, -0.2934, -0.1494,  0.7212,  1.3087,  0.0699 },
    { 0.1343, -0.2027, -0.2364, -0.2637, -0.3219, -0.4239, -0.4269, -0.3522, -0.4565,  0.5325,  0.2056, -0.2794,  0.0677,  0.0977, -0.4887, -0.1533,  0.1497, -0.4021,  0.0699,  0.6756 },
};

const double s_blosum35[20][20] = 
{
    { 0.7833, -0.1606, -0.1137, -0.1445, -0.2784, -0.0346, -0.1445,  0.0675, -0.3109, -0.1532, -0.2885, -0.0733, -0.0111, -0.3555, -0.2820,  0.1645,  0.0425, -0.3155, -0.2229,  0.0539},
    {-0.1606,  1.3240, -0.1634, -0.1867, -0.4878,  0.3270, -0.1608, -0.3771, -0.1614, -0.4456, -0.3184,  0.3143, -0.0125, -0.2021, -0.3783, -0.1094, -0.2962, -0.0399, -0.0828, -0.1901},
    {-0.1137, -0.1634,  1.1636,  0.2584, -0.2463,  0.0963, -0.1646,  0.1648,  0.1705, -0.1388, -0.4248,  0.0039, -0.1388, -0.2542, -0.3168, -0.0279, -0.0132, -0.4225, -0.3855, -0.4299},
    {-0.1445, -0.1867,  0.2584,  1.4269, -0.5229, -0.1333,  0.2827, -0.2646, -0.0857, -0.5490, -0.3848, -0.1000, -0.5569, -0.5613, -0.2038, -0.1258, -0.2424, -0.4815, -0.4170, -0.3912},
    {-0.2784, -0.4878, -0.2463, -0.5229,  2.5797, -0.6053, -0.1433, -0.5720, -0.6724, -0.6354, -0.3592, -0.3248, -0.6098, -0.6392, -0.7442, -0.4836, -0.1646, -0.7799, -0.8463, -0.4266},
    {-0.0346,  0.3270,  0.0963, -0.1333, -0.6053,  1.2021,  0.4084, -0.2732, -0.0960, -0.4155, -0.3270,  0.0482, -0.1469, -0.6402, -0.0550,  0.0829, -0.0799, -0.2246, -0.0365, -0.4735},
    {-0.1445, -0.1608, -0.1646,  0.2827, -0.1433,  0.4084,  1.0220, -0.3919, -0.1416, -0.4974, -0.2240,  0.2285, -0.3353, -0.4844, -0.0532, -0.0527, -0.1461, -0.0954, -0.2533, -0.3422},
    { 0.0675, -0.3771,  0.1648, -0.2646, -0.5720, -0.2732, -0.3919,  1.2847, -0.3386, -0.5020, -0.5162, -0.1601, -0.2264, -0.5211, -0.2702,  0.1535, -0.3548, -0.1548, -0.2824, -0.5316},
    {-0.3109, -0.1614,  0.1705, -0.0857, -0.6724, -0.0960, -0.1416, -0.3386,  2.1416, -0.4507, -0.2967, -0.3606,  0.2122, -0.4910, -0.1882, -0.1094, -0.2609, -0.6178, -0.0250, -0.6224},
    {-0.1532, -0.4456, -0.1388, -0.5490, -0.6354, -0.4155, -0.4974, -0.5020, -0.4507,  0.9256,  0.3920, -0.3244,  0.2115,  0.1200, -0.2447, -0.2647, -0.0883, -0.2058,  0.0270,  0.6462},
    {-0.2885, -0.3184, -0.4248, -0.3848, -0.3592, -0.3270, -0.2240, -0.5162, -0.2967,  0.3920,  0.8417, -0.3509,  0.4501,  0.2915, -0.5194, -0.3219, -0.0528, -0.0340,  0.0774,  0.2822},
    {-0.0733,  0.3143,  0.0039, -0.1000, -0.3248,  0.0482,  0.2285, -0.1601, -0.3606, -0.3244, -0.3509,  0.8330, -0.0131, -0.2048, -0.0498, -0.0340, -0.0127, -0.0494, -0.2015, -0.3174},
    {-0.0111, -0.0125, -0.1388, -0.5569, -0.6098, -0.1469, -0.3353, -0.2264,  0.2122,  0.2115,  0.4501, -0.0131,  1.0168, -0.0816, -0.5606, -0.2144, -0.0585,  0.1230,  0.0775,  0.1212},
    {-0.3555, -0.2021, -0.2542, -0.5613, -0.6392, -0.6402, -0.4844, -0.5211, -0.4910,  0.1200,  0.2915, -0.2048, -0.0816,  1.4657, -0.7482, -0.2228, -0.2028,  0.1677,  0.5990,  0.1038},
    {-0.2820, -0.3783, -0.3168, -0.2038, -0.7442, -0.0550, -0.0532, -0.2702, -0.1882, -0.2447, -0.5194, -0.0498, -0.5606, -0.7482,  1.7951, -0.3401, -0.0044, -0.6539, -0.4623, -0.4425},
    { 0.1645, -0.1094, -0.0279, -0.1258, -0.4836,  0.0829, -0.0527,  0.1535, -0.1094, -0.2647, -0.3219, -0.0340, -0.2144, -0.2228, -0.3401,  0.7758,  0.3036, -0.3983, -0.2454, -0.1957},
    { 0.0425, -0.2962, -0.0132, -0.2424, -0.1646, -0.0799, -0.1461, -0.3548, -0.2609, -0.0883, -0.0528, -0.0127, -0.0585, -0.2028, -0.0044,  0.3036,  0.8533, -0.2664, -0.3026,  0.1558},
    {-0.3155, -0.0399, -0.4225, -0.4815, -0.7799, -0.2246, -0.0954, -0.1548, -0.6178, -0.2058, -0.0340, -0.0494,  0.1230,  0.1677, -0.6539, -0.3983, -0.2664,  2.7062,  0.5337, -0.4124},
    {-0.2229, -0.0828, -0.3855, -0.4170, -0.8463, -0.0365, -0.2533, -0.2824, -0.0250,  0.0270,  0.0774, -0.2015,  0.0775,  0.5990, -0.4623, -0.2454, -0.3026,  0.5337,  1.3735, -0.0395},
    { 0.0539, -0.1901, -0.4299, -0.3912, -0.4266, -0.4735, -0.3422, -0.5316, -0.6224,  0.6462,  0.2822, -0.3174,  0.1212,  0.1038, -0.4425, -0.1957,  0.1558, -0.4124, -0.0395,  0.8074},
};

const double s_blosum40[20][20] = 
{
    { 0.9119, -0.2743, -0.1296, -0.2441, -0.2707, -0.0494, -0.1384,  0.0932, -0.3821, -0.2251, -0.3190, -0.1296, -0.0902, -0.4743, -0.2940,  0.2366,  0.0049, -0.4468, -0.3354,  0.0417},
    {-0.2743,  1.4840, -0.0848, -0.2115, -0.5700,  0.3116, -0.1169, -0.5246, -0.0817, -0.5653, -0.3921,  0.5393, -0.1280, -0.3942, -0.5004, -0.1993, -0.2881, -0.3091, -0.1090, -0.3643},
    {-0.1296, -0.0848,  1.3424,  0.3100, -0.3608,  0.1206, -0.0930,  0.0641,  0.1804, -0.3787, -0.5709,  0.0453, -0.3103, -0.4551, -0.3522,  0.1574, -0.0110, -0.7014, -0.4214, -0.5228},
    {-0.2441, -0.2115,  0.3100,  1.4976, -0.4091, -0.1528,  0.4090, -0.2712, -0.0273, -0.6521, -0.5689, -0.0570, -0.5513, -0.6409, -0.2710, -0.0674, -0.1076, -0.8068, -0.5075, -0.5015},
    {-0.2707, -0.5700, -0.3608, -0.4091,  2.6935, -0.7012, -0.3809, -0.4912, -0.7047, -0.6270, -0.3999, -0.4372, -0.5404, -0.4285, -0.7822, -0.1897, -0.1616, -0.9961, -0.7560, -0.3571},
    {-0.0494,  0.3116,  0.1206, -0.1528, -0.7012,  1.3398,  0.3970, -0.3333,  0.0464, -0.5654, -0.3077,  0.1860, -0.1456, -0.6940, -0.2615,  0.1912, -0.2165, -0.2499, -0.2047, -0.5285},
    {-0.1384, -0.1169, -0.0930,  0.4090, -0.3809,  0.3970,  1.2032, -0.4893, -0.0283, -0.6681, -0.3811,  0.2294, -0.3727, -0.5826, -0.0370, -0.0588, -0.1940, -0.4213, -0.3737, -0.4764},
    { 0.0932, -0.5246,  0.0641, -0.2712, -0.4912, -0.3333, -0.4893,  1.4586, -0.4110, -0.6595, -0.7042, -0.2859, -0.3724, -0.5529, -0.2356,  0.0862, -0.3292, -0.3161, -0.4768, -0.6181},
    {-0.3821, -0.0817,  0.1804, -0.0273, -0.7047,  0.0464, -0.0283, -0.4110,  2.1702, -0.5922, -0.2956, -0.1769,  0.1055, -0.3298, -0.3740, -0.2178, -0.3771, -0.8174,  0.2967, -0.7444},
    {-0.2251, -0.5653, -0.3787, -0.6521, -0.6270, -0.5654, -0.6681, -0.6595, -0.5922,  1.0817,  0.4286, -0.4630,  0.2418,  0.1256, -0.3423, -0.3906, -0.0963, -0.5446, -0.0557,  0.7273},
    {-0.3190, -0.3921, -0.5709, -0.5689, -0.3999, -0.3077, -0.3811, -0.7042, -0.2956,  0.4286,  0.9660, -0.3805,  0.5538,  0.2931, -0.6502, -0.4679, -0.1469, -0.2320, -0.0009,  0.3125},
    {-0.1296,  0.5393,  0.0453, -0.0570, -0.4372,  0.1860,  0.2294, -0.2859, -0.1769, -0.4630, -0.3805,  1.0074, -0.1801, -0.4512, -0.1810, -0.0796, -0.0586, -0.4157, -0.2214, -0.3959},
    {-0.0902, -0.1280, -0.3103, -0.5513, -0.5404, -0.1456, -0.3727, -0.3724,  0.1055,  0.2418,  0.5538, -0.1801,  1.1883,  0.0351, -0.4082, -0.2954, -0.1199, -0.3292,  0.1474,  0.1217},
    {-0.4743, -0.3942, -0.4551, -0.6409, -0.4285, -0.6940, -0.5826, -0.5529, -0.3298,  0.1256,  0.2931, -0.4512,  0.0351,  1.5888, -0.7317, -0.4187, -0.2280,  0.2048,  0.6753, -0.0049},
    {-0.2940, -0.5004, -0.3522, -0.2710, -0.7822, -0.2615, -0.0370, -0.2356, -0.3740, -0.3423, -0.6502, -0.1810, -0.4082, -0.7317,  1.9620, -0.2274, -0.0749, -0.6790, -0.5705, -0.5599},
    { 0.2366, -0.1993,  0.1574, -0.0674, -0.1897,  0.1912, -0.0588,  0.0862, -0.2178, -0.3906, -0.4679, -0.0796, -0.2954, -0.4187, -0.2274,  0.8707,  0.3169, -0.8290, -0.3426, -0.2499},
    { 0.0049, -0.2881, -0.0110, -0.1076, -0.1616, -0.2165, -0.1940, -0.3292, -0.3771, -0.0963, -0.1469, -0.0586, -0.1199, -0.2280, -0.0749,  0.3169,  0.9860, -0.7326, -0.2540,  0.1581},
    {-0.4468, -0.3091, -0.7014, -0.8068, -0.9961, -0.2499, -0.4213, -0.3161, -0.8174, -0.5446, -0.2320, -0.4157, -0.3292,  0.2048, -0.6790, -0.8290, -0.7326,  3.2139,  0.5554, -0.6012},
    {-0.3354, -0.1090, -0.4214, -0.5075, -0.7560, -0.2047, -0.3737, -0.4768,  0.2967, -0.0557, -0.0009, -0.2214,  0.1474,  0.6753, -0.5705, -0.3426, -0.2540,  0.5554,  1.5977, -0.1600},
    { 0.0417, -0.3643, -0.5228, -0.5015, -0.3571, -0.5285, -0.4764, -0.6181, -0.7444,  0.7273,  0.3125, -0.3959,  0.1217, -0.0049, -0.5599, -0.2499,  0.1581, -0.6012, -0.1600,  0.9123},
};

const double s_blosum50[20][20] = 
{
    { 1.1859, -0.4029, -0.3292, -0.4160, -0.1192, -0.1986, -0.2265,  0.0965, -0.4444, -0.3353, -0.4201, -0.2908, -0.1585, -0.6046, -0.3358,  0.3101, -0.0332, -0.7688, -0.5168, -0.0186},
    {-0.4029,  1.6823, -0.1581, -0.3878, -0.8490,  0.3055, -0.0239, -0.6597, -0.0186, -0.8317, -0.5906,  0.7250, -0.3886, -0.7727, -0.6565, -0.2175, -0.3058, -0.6371, -0.3186, -0.6685},
    {-0.3292, -0.1581,  1.6649,  0.4433, -0.5091,  0.0344, -0.0837, -0.0315,  0.3322, -0.7966, -0.8851,  0.0586, -0.4918, -0.8239, -0.5037,  0.2024,  0.1033, -0.9790, -0.4837, -0.7695},
    {-0.4160, -0.3878,  0.4433,  1.8102, -0.8492, -0.0335,  0.5055, -0.2951, -0.1235, -0.9938, -0.9863, -0.1162, -0.8324, -1.0869, -0.3430, -0.0818, -0.1921, -1.1808, -0.6842, -0.8400},
    {-0.1192, -0.8490, -0.5091, -0.8492,  2.9031, -0.7313, -0.7852, -0.6456, -0.6589, -0.5324, -0.4307, -0.7768, -0.3843, -0.5709, -0.9086, -0.1865, -0.2010, -1.1643, -0.6186, -0.2124},
    {-0.1986,  0.3055,  0.0344, -0.0335, -0.7313,  1.5470,  0.5136, -0.4441,  0.1899, -0.6879, -0.5746,  0.3496, -0.0409, -0.8748, -0.2870,  0.0665, -0.2103, -0.3359, -0.2983, -0.5845},
    {-0.2265, -0.0239, -0.0837,  0.5055, -0.7852,  0.5136,  1.4901, -0.6163, -0.0927, -0.8781, -0.7372,  0.2860, -0.5024, -0.7851, -0.1758, -0.1255, -0.1996, -0.6014, -0.4282, -0.7359},
    { 0.0965, -0.6597, -0.0315, -0.2951, -0.6456, -0.4441, -0.6163,  1.7565, -0.5087, -0.9933, -0.9757, -0.4233, -0.6550, -0.8820, -0.4778, -0.0008, -0.4521, -0.6834, -0.7609, -0.9095},
    {-0.4444, -0.0186,  0.3322, -0.1235, -0.6589,  0.1899, -0.0927, -0.5087,  2.3465, -0.8879, -0.6025, -0.0560, -0.2743, -0.2814, -0.5414, -0.1953, -0.4267, -0.7444,  0.4511, -0.8828},
    {-0.3353, -0.8317, -0.7966, -0.9938, -0.5324, -0.6879, -0.8781, -0.9933, -0.8879,  1.2270,  0.5287, -0.7586,  0.3633, -0.0103, -0.6710, -0.6058, -0.1500, -0.6491, -0.1910,  0.8384},
    {-0.4201, -0.5906, -0.8851, -0.9863, -0.4307, -0.5746, -0.7372, -0.9757, -0.6025,  0.5287,  1.2024, -0.7356,  0.5822,  0.2325, -0.8126, -0.6721, -0.2755, -0.5083, -0.1527,  0.2809},
    {-0.2908,  0.7250,  0.0586, -0.1162, -0.7768,  0.3496,  0.2860, -0.4233, -0.0560, -0.7586, -0.7356,  1.3561, -0.3780, -0.8097, -0.2696, -0.1132, -0.1686, -0.7731, -0.4038, -0.6486},
    {-0.1585, -0.3886, -0.4918, -0.8324, -0.3843, -0.0409, -0.5024, -0.6550, -0.2743,  0.3633,  0.5822, -0.3780,  1.5718,  0.0503, -0.6073, -0.3823, -0.1252, -0.2724, -0.0857,  0.1933},
    {-0.6046, -0.7727, -0.8239, -1.0869, -0.5709, -0.8748, -0.7851, -0.8820, -0.2814, -0.0103,  0.2325, -0.8097,  0.0503,  1.8926, -0.9789, -0.5924, -0.5615,  0.2987,  0.8856, -0.1512},
    {-0.3358, -0.6565, -0.5037, -0.3430, -0.9086, -0.2870, -0.1758, -0.4778, -0.5414, -0.6710, -0.8126, -0.2696, -0.6073, -0.9789,  2.3227, -0.2752, -0.2896, -0.8673, -0.7589, -0.6455},
    { 0.3101, -0.2175,  0.2024, -0.0818, -0.1865,  0.0665, -0.1255, -0.0008, -0.1953, -0.6058, -0.6721, -0.1132, -0.3823, -0.5924, -0.2752,  1.1451,  0.4036, -0.9357, -0.4292, -0.3876},
    {-0.0332, -0.3058,  0.1033, -0.1921, -0.2010, -0.2103, -0.1996, -0.4521, -0.4267, -0.1500, -0.2755, -0.1686, -0.1252, -0.5615, -0.2896,  0.4036,  1.2678, -0.6878, -0.3700,  0.0582},
    {-0.7688, -0.6371, -0.9790, -1.1808, -1.1643, -0.3359, -0.6014, -0.6834, -0.7444, -0.6491, -0.5083, -0.7731, -0.2724,  0.2987, -0.8673, -0.9357, -0.6878,  3.4456,  0.5682, -0.7239},
    {-0.5168, -0.3186, -0.4837, -0.6842, -0.6186, -0.2983, -0.4282, -0.7609,  0.4511, -0.1910, -0.1527, -0.4038, -0.0857,  0.8856, -0.7589, -0.4292, -0.3700,  0.5682,  1.9305, -0.3184},
    {-0.0186, -0.6685, -0.7695, -0.8400, -0.2124, -0.5845, -0.7359, -0.9095, -0.8828,  0.8384,  0.2809, -0.6486,  0.1933, -0.1512, -0.6455, -0.3876,  0.0582, -0.7239, -0.3184,  1.1370},
};

const double s_blosum62[20][20] = 
{
    { 1.3618, -0.4899, -0.5305, -0.6077, -0.1416, -0.2786, -0.2994,  0.0553, -0.5633, -0.4581, -0.5076, -0.2544, -0.3241, -0.7659, -0.2822,  0.3867, -0.0157, -0.8757, -0.6114, -0.0656 },
    {-0.4899,  1.8969, -0.1524, -0.5565, -1.1746,  0.3406, -0.0400, -0.7986, -0.0866, -1.0363, -0.7467,  0.7309, -0.4738, -0.9657, -0.7308, -0.2651, -0.3890, -0.9286, -0.5870, -0.8673 },
    {-0.5305, -0.1524,  1.9592,  0.4407, -0.9218,  0.0006, -0.0929, -0.1465,  0.2005, -1.1149, -1.1711, -0.0620, -0.7454, -1.0376, -0.6933,  0.2083, -0.0159, -1.2809, -0.7215, -0.9969 },
    {-0.6077, -0.5565,  0.4407,  2.0012, -1.1991, -0.1086,  0.5235, -0.4553, -0.3878, -1.0817, -1.2496, -0.2432, -1.0600, -1.2074, -0.5130, -0.0905, -0.3642, -1.4606, -1.0622, -1.0891 },
    {-0.1416, -1.1746, -0.9218, -1.1991,  2.9744, -1.0057, -1.2520, -0.8666, -1.0355, -0.4255, -0.4427, -1.0523, -0.4921, -0.8233, -0.9687, -0.3033, -0.3003, -0.7986, -0.8343, -0.2799 },
    {-0.2786,  0.3406,  0.0006, -0.1086, -1.0057,  1.8317,  0.6428, -0.6187,  0.1553, -0.9599, -0.7396,  0.4410, -0.1459, -1.0967, -0.4443, -0.0351, -0.2341, -0.6746, -0.4925, -0.7619 },
    {-0.2994, -0.0400, -0.0929,  0.5235, -1.2520,  0.6428,  1.6992, -0.7313, -0.0408, -1.1071, -0.9865,  0.2687, -0.6925, -1.1064, -0.3868, -0.0509, -0.2992, -0.9827, -0.7002, -0.8464 },
    { 0.0553, -0.7986, -0.1465, -0.4553, -0.8666, -0.6187, -0.7313,  1.9281, -0.7073, -1.2909, -1.2570, -0.5296, -0.9276, -1.0769, -0.7394, -0.1013, -0.5460, -0.8635, -1.0535, -1.0878 },
    {-0.5633, -0.0866,  0.2005, -0.3878, -1.0355,  0.1553, -0.0408, -0.7073,  2.6031, -1.1200, -0.9658, -0.2499, -0.5376, -0.4277, -0.7489, -0.3055, -0.5843, -0.8117,  0.5866, -1.0804 },
    {-0.4581, -1.0363, -1.1149, -1.0817, -0.4255, -0.9599, -1.1071, -1.2909, -1.1200,  1.3858,  0.5273, -0.9254,  0.3905, -0.0557, -0.9554, -0.8138, -0.2487, -0.8944, -0.4614,  0.8827 },
    {-0.5076, -0.7467, -1.1711, -1.2496, -0.4427, -0.7396, -0.9865, -1.2570, -0.9658,  0.5273,  1.3341, -0.8480,  0.6903,  0.1438, -0.9912, -0.8465, -0.4150, -0.5655, -0.3681,  0.2732 },
    {-0.2544,  0.7309, -0.0620, -0.2432, -1.0523,  0.4410,  0.2687, -0.5296, -0.2499, -0.9254, -0.8480,  1.5612, -0.4695, -1.0670, -0.3513, -0.0705, -0.2321, -1.0246, -0.6308, -0.7841 },
    {-0.3241, -0.4738, -0.7454, -1.0600, -0.4921, -0.1459, -0.6925, -0.9276, -0.5376,  0.3905,  0.6903, -0.4695,  1.8689,  0.0044, -0.8583, -0.5132, -0.2309, -0.4938, -0.3448,  0.2382 },
    {-0.7659, -0.9657, -1.0376, -1.2074, -0.8233, -1.0967, -1.1064, -1.0769, -0.4277, -0.0557,  0.1438, -1.0670,  0.0044,  2.0954, -1.2467, -0.8210, -0.7304,  0.3180,  1.0186, -0.2942 },
    {-0.2822, -0.7308, -0.6933, -0.5130, -0.9687, -0.4443, -0.3868, -0.7394, -0.7489, -0.9554, -0.9912, -0.3513, -0.8583, -1.2467,  2.5524, -0.2804, -0.3726, -1.2664, -1.0119, -0.8140 },
    { 0.3867, -0.2651,  0.2083, -0.0905, -0.3033, -0.0351, -0.0509, -0.1013, -0.3055, -0.8138, -0.8465, -0.0705, -0.5132, -0.8210, -0.2804,  1.3462,  0.4787, -0.9537, -0.5843, -0.5705 },
    {-0.0157, -0.3890, -0.0159, -0.3642, -0.3003, -0.2341, -0.2992, -0.5460, -0.5843, -0.2487, -0.4150, -0.2321, -0.2309, -0.7304, -0.3726,  0.4787,  1.5753, -0.8418, -0.5566, -0.0193 },
    {-0.8757, -0.9286, -1.2809, -1.4606, -0.7986, -0.6746, -0.9827, -0.8635, -0.8117, -0.8944, -0.5655, -1.0246, -0.4938,  0.3180, -1.2664, -0.9537, -0.8418,  3.6404,  0.7466, -0.9823 },
    {-0.6114, -0.5870, -0.7215, -1.0622, -0.8343, -0.4925, -0.7002, -1.0535,  0.5866, -0.4614, -0.3681, -0.6308, -0.3448,  1.0186, -1.0119, -0.5843, -0.5566,  0.7466,  2.2857, -0.4185 },
    {-0.0656, -0.8673, -0.9969, -1.0891, -0.2799, -0.7619, -0.8464, -1.0878, -1.0804,  0.8827,  0.2732, -0.7841,  0.2382, -0.2942, -0.8140, -0.5705, -0.0193, -0.9823, -0.4185,  1.3062 },
};

const double s_blosum100[20][20] = 
{
    { 1.8726, -0.7745, -0.8255, -1.0539, -0.4822, -0.4817, -0.6184, -0.3267, -0.9615, -0.9110, -0.9206, -0.5365, -0.7933, -1.2362, -0.4993,  0.3219, -0.1797, -1.4372, -1.2231, -0.3471},
    {-0.7745,  2.3921, -0.4537, -1.0968, -1.8282,  0.0321, -0.5220, -1.3028, -0.2352, -1.5465, -1.3033,  0.7261, -0.8189, -1.4928, -1.0776, -0.6138, -0.8019, -1.5301, -1.1691, -1.4058},
    {-0.8255, -0.4537,  2.4849,  0.3091, -1.2271, -0.1860, -0.4510, -0.5657, -0.0236, -1.6237, -1.6596, -0.2492, -1.2360, -1.6475, -1.2644, -0.0458, -0.2297, -1.9115, -1.1693, -1.5100},
    {-1.0539, -1.0968,  0.3091,  2.3913, -1.9009, -0.5398,  0.4223, -0.9059, -0.7636, -1.9293, -1.9446, -0.6180, -1.7503, -1.7793, -1.1014, -0.4982, -0.8180, -2.3666, -1.6324, -1.7957},
    {-0.4822, -1.8282, -1.2271, -1.9009,  3.1374, -1.6394, -2.1341, -1.6779, -1.8717, -0.7132, -1.0507, -1.7530, -1.0309, -0.9735, -1.7634, -0.6807, -0.6819, -1.6470, -1.3191, -0.6409},
    {-0.4817,  0.0321, -0.1860, -0.5398, -1.6394,  2.5224,  0.4401, -1.1854,  0.1463, -1.4462, -1.0781,  0.3491, -0.3591, -1.4130, -0.8346, -0.4026, -0.5870, -1.1271, -0.9699, -1.2021},
    {-0.6184, -0.5220, -0.4510,  0.4223, -2.1341,  0.4401,  2.2204, -1.3101, -0.4301, -1.6252, -1.6681, -0.0703, -1.2653, -1.8727, -0.8909, -0.4118, -0.6951, -1.7871, -1.5278, -1.2046},
    {-0.3267, -1.3028, -0.5657, -0.9059, -1.6779, -1.1854, -1.3101,  2.1752, -1.3314, -2.1320, -1.8965, -1.0579, -1.5963, -1.8371, -1.4072, -0.4682, -1.0789, -1.6456, -1.9265, -1.8287},
    {-0.9615, -0.2352, -0.0236, -0.7636, -1.8717,  0.1463, -0.4301, -1.3314,  3.0623, -1.6060, -1.4216, -0.5874, -1.0989, -0.8580, -1.1646, -0.6375, -0.8996, -1.1765,  0.2721, -1.6123},
    {-0.9110, -1.5465, -1.6237, -1.9293, -0.7132, -1.4462, -1.6252, -2.1320, -1.6060,  1.9013,  0.3702, -1.4196,  0.2886, -0.4014, -1.5369, -1.2341, -0.5967, -1.4553, -0.8840,  0.8639},
    {-0.9206, -1.3033, -1.6596, -1.9446, -1.0507, -1.0781, -1.6681, -1.8965, -1.4216,  0.3702,  1.7587, -1.3084,  0.6230, -0.0712, -1.5027, -1.2721, -0.8797, -1.2355, -0.9019,  0.0247},
    {-0.5365,  0.7261, -0.2492, -0.6180, -1.7530,  0.3491, -0.0703, -1.0579, -0.5874, -1.4196, -1.3084,  2.2003, -0.8207, -1.4371, -0.7458, -0.4437, -0.5949, -1.8992, -1.2190, -1.2634},
    {-0.7933, -0.8189, -1.2360, -1.7503, -1.0309, -0.3591, -1.2653, -1.5963, -1.0989,  0.2886,  0.6230, -0.8207,  2.6912, -0.2842, -1.2262, -1.0180, -0.5660, -0.9186, -1.0478,  0.0367},
    {-1.2362, -1.4928, -1.6475, -1.7793, -0.9735, -1.4130, -1.8727, -1.8371, -0.8580, -0.4014, -0.0712, -1.4371, -0.2842,  2.4658, -1.7221, -1.2118, -1.1136, -0.0536,  0.9748, -0.7072},
    {-0.4993, -1.0776, -1.2644, -1.1014, -1.7634, -0.8346, -0.8909, -1.4072, -1.1646, -1.5369, -1.5027, -0.7458, -1.2262, -1.7221,  2.8825, -0.6663, -0.9023, -1.9575, -1.7124, -1.3558},
    { 0.3219, -0.6138, -0.0458, -0.4982, -0.6807, -0.4026, -0.4118, -0.4682, -0.6375, -1.2341, -1.2721, -0.4437, -1.0180, -1.2118, -0.6663,  1.9737,  0.4179, -1.5468, -1.1084, -0.9219},
    {-0.1797, -0.8019, -0.2297, -0.8180, -0.6819, -0.5870, -0.6951, -1.0789, -0.8996, -0.5967, -0.8797, -0.5949, -0.5660, -1.1136, -0.9023,  0.4179,  2.1455, -1.6392, -1.0983, -0.2949},
    {-1.4372, -1.5301, -1.9115, -2.3666, -1.6470, -1.1271, -1.7871, -1.6456, -1.1765, -1.4553, -1.2355, -1.8992, -0.9186, -0.0536, -1.9575, -1.5468, -1.6392,  3.8223,  0.4812, -1.2471},
    {-1.2231, -1.1691, -1.1693, -1.6324, -1.3191, -0.9699, -1.5278, -1.9265,  0.2721, -0.8840, -0.9019, -1.2190, -1.0478,  0.9748, -1.7124, -1.1084, -1.0983,  0.4812,  2.7502, -1.0988},
    {-0.3471, -1.4058, -1.5100, -1.7957, -0.6409, -1.2021, -1.2046, -1.8287, -1.6123,  0.8639,  0.0247, -1.2634,  0.0367, -0.7072, -1.3558, -0.9219, -0.2949, -1.2471, -1.0988,  1.8316},
};

