/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// $Id: MMU.h 1.2 Mon, 11 Nov 1996 14:11:38 -0700 maccabe $
//

//
// MMU.h -- declaration of the  MMU  class
//

#ifndef _MMU_h
#define _MMU_h

#define AS_U_TEXT  8
#define AS_S_TEXT  9
#define AS_U_DATA 10
#define AS_S_DATA 11

class SystemBus;

class MMU {
public:
    // public Constructors / Destructors
    //
    MMU(SystemBus&);

    // public Member functions
    //
    UInt32 read(int, UInt32);
    void write(int, UInt32, int, UInt32);

    // other public objects
    UInt32 context;
    enum { MAX_CONTEXT = 15 };


private:
    MMU(const MMU&);		// Declare away
    void operator = (const MMU&);	// Declare away

    SystemBus&	sbus;

    UInt32	lastPage;

    UInt32*	userTextPageTable;
    UInt32*	superTextPageTable;

    UInt32*	userDataPageTable;
    UInt32*	superDataPageTable;
};

#endif /* _MMU_h */
