/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	Department of Computer Science,
 *      The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//
// $Id: st_dev.h 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $
//

//
// StorageDev.h -- declaration of the  StorageDevice  class
//

#ifndef _StorageDev_h
#define _StorageDev_h

class SystemBus;
class StorageDevice {
public:
    // public Constructors / Destructors
    //
    StorageDevice(SystemBus&, UInt32, UInt32);

    // public Query functions
    //
    UInt32		lowAddress();
    UInt32		highAddress();

    // public interface to devices
    //
    virtual void	reset() = 0;
    virtual void	run() = 0;

    virtual UInt32	read(UInt32) = 0;
    virtual void	write(UInt32, int, UInt32) = 0;

    SystemBus&		sbus;

private:
    StorageDevice(const StorageDevice&); // Declare away
    void operator = (const StorageDevice&);	  // Declare away

    UInt32	_lowAddress;
    UInt32	_highAddress;
};

#endif /* _StorageDev_h */
