/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: call.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

//---------------------------------------------------------------------
// call Instruction - see p180 of SPARC Architecture Manual, Version 8
//---------------------------------------------------------------------

#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"


void IntegerUnit::call (const Instruction& inst) {
    reg[15] = IU_PC;
    IU_PC = IU_nPC;
    IU_nPC = reg[15] + (inst.disp30() << 2);  // reg[15] serves as a temporary PC
}
