/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: mul_step.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

//-----------------------------------------------------------------------------
// Multiply Step Instruction - see p175 of SPARC Architecture Manual, Version 8
//-----------------------------------------------------------------------------

#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"


void IntegerUnit::multiply_step(const Instruction& inst) {
    // concatenate the 0th bit of N xor V
    //   with 31st to 1st bit of reg[rs1]
    //
    UInt32 operand1 = ((IU_N ^ IU_V) << 31) | ((reg[inst.rs1()] >> 1) & 0x7fffffff);

    UInt32 operand2 = ((IU_Y & 1)  == 0) ? 0 :
		      ((inst.i() == 0) ? reg[inst.rs2()] : inst.simm13());

    UInt32 result = operand1 + operand2;
    IU_Y = (reg[inst.rs1()] << 31) | ((IU_Y >> 1) & 0x7fffffff); 
    //next

    reg[inst.rd()] = result;

    UInt32 operand1_31 = operand1 >> 31;
    UInt32 operand2_31 = operand2 >> 31;
    UInt32 result_31   = result >> 31;
    
    IU_N = result_31;
    IU_Z = (result == 0) ? 1 : 0;
    IU_V = ((operand1_31 && operand2_31 && !result_31) || 
	  (!operand1_31 && !operand2_31 && result_31)) ? 1 : 0;
    IU_C = ((operand1_31 && operand2_31) || 
	  (!result_31 && (operand1_31 || operand2_31))) ? 1 : 0;
}
