/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: swap.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

//-----------------------------------------------------
// Swap Register with Memory Instruction -
//    see p171 of SPARC Architecture Manual, Version 8
//-----------------------------------------------------

#include "sizedefs.h"
#include "Instruct.h"
#include "MMU.h"
#include "sys_bus.h"
#include "RegBlock.h"
#include "IU.h"


void IntegerUnit::swap(const Instruction& inst) {
    // Init vars to shut up gcc
    UInt32 address = ~0, addr_space = USER_DATA;

    if (inst.op3() == Instruction::SWAP) {
	address = reg[inst.rs1()] +
		  ((inst.i() == 0) ? reg[inst.rs2()] : inst.simm13());
	addr_space = (IU_S == 0) ? USER_DATA : SUPERVISOR_DATA;        
    } 
    else if (inst.op3() == Instruction::SWAPA) {
	if (IU_S == 0) {
	    trap = 1;                   
	    trapFlag[privileged_instruction] = 1; 
	}
	else if (inst.i() == 1) {
	    trap = 1;                   
	    trapFlag[illegal_instruction] = 1; 
	}
	else {
	    address = reg[inst.rs1()] + reg[inst.rs2()];
	    addr_space = inst.asi();     
	}
    }
    // next


    UInt32 temp, word;

    if (trap == 0) {
	temp = reg[inst.rd()];          
	sbus.pb_retain_bus(1);               
	// next

	word = mmu.read(addr_space, address);
	// next

	if (sbus.bp_memory_exception()) {
	    trap = 1;
	    trapFlag[data_access_exception] = 1;
	} 
    }
    // next

    if (trap == 0) {
	mmu.write(addr_space, address, 0xf, temp);
	// next

	sbus.pb_retain_bus(0);

	if (sbus.bp_memory_exception()) {
	    trap = 1;
	    trapFlag[data_access_exception] = 1;
	}
	else {
	    reg[inst.rd()] = word;
	}
    }
}
