/*
 *  ISEM - Instructional Sparc EMulator and tkisem
 *  Copyright (C) 1993, 1994, 1995, 1996
 *	 Department of Computer Science,
 *       The University of New Mexico
 *
 *  Please send questions, comments, and bug reports to: isem@cs.unm.edu
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
//-----------------------------------------------------
// Write State Register Instructions -
//    see p183 of SPARC Architecture Manual, Version 8
//-----------------------------------------------------

#if __GNUC__
#define UNUSED __attribute__ ((unused)) 
#else
#define UNUSED
#endif

static char rcsid[] UNUSED = "$Id: wr_state.cpp 1.1 Fri, 25 Oct 1996 18:04:04 -0600 maccabe $";

#include "sizedefs.h"
#include "Instruct.h"
#include "RegBlock.h"
#include "IU.h"


void IntegerUnit::write_state_reg(const Instruction& inst) {
    UInt32 operand2 = (inst.i() == 0) ? reg[inst.rs2()] : inst.simm13();
    UInt32 result = reg[inst.rs1()] ^ operand2 ;

    switch (inst.op3()) {
    case Instruction::WRY:    
	Ypppp = result;    
	break;

    case Instruction::WRPSR:
	if (IU_S == 0) {
	    trap = 1;
	    trapFlag[privileged_instruction] = 1;
	}
	else if ((result & 0x1f) >= (unsigned) NWINDOWS) {
	    trap = 1;
	    trapFlag[illegal_instruction] = 1;
	}
	else {
	    PSRpppp = result;
	}
	break;

    case Instruction::WRWIM:
	if (IU_S == 0) { 
	    trap = 1;
	    trapFlag[privileged_instruction] = 1;
	}
	else {
	    WIMpppp = result;
	}
	break;

    case Instruction::WRTBR:
	if (IU_S == 0) { 
	    trap = 1;
	    trapFlag[privileged_instruction] = 1;
	}
	else {
	    TBRpppp = result;
	}
	break;

    default:
	Assert(0, "Unknown op3: PLEASE EMAIL isem@cs.unm.edu with this error!");
    }

    // Added by Gerard Rollins to deal with the delayed write of state
    // registers in IU_exec.  7/21/92
    // If no trap has been caused by one of the above instructions,
    // delayed_write_count gets bumped by 4. delayed_write_count is a private
    // member of class IntegerUnit and controls the pipelined write of state
    // registers. If delayed_write_count != 0 the pipelined write will occur.
    // delayed_write_count is bumped by 4 to give the effect that the next
    // three instructions can not rely on the state registers.

    if (!trap)
	delayed_write_count += 4;
}
