/* twpsk  - A gui application for PSK
 * Copyright (C) 1999 Ted Williams WA0EIR (ted_williams@HP.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.0 - Aug 2001
 */


#include "GUI.h"
#include "twpskWids.h"

#define TEXT 0
#define INSERT 1

extern AppRes appRes;
extern Wids pskwids;


/*
 * aboutDiag Function - Just an info dialog
 */
void aboutCB (Widget w, XtPointer widget, XtPointer cbdata)
{
   static Widget diag = NULL;
   Widget shell = (Widget) widget;
   XmString  msg_xs;
   char msg_str[] =
 "TWPSK \251 2000\n\nInterfaces by Ted Williams     - WA\330EIR
PSK classes by Hansi Reiser - DL9RDZ";

   if (diag == NULL)
      {
      diag = XmCreateInformationDialog (shell, "aboutDiag",  (ArgList) NULL, 0);
      XtVaSetValues (XtParent(diag),
         XmNtitle, "ABOUT TWPSK",
         XmNmwmDecorations, MWM_DECOR_ALL | MWM_DECOR_RESIZEH,
         NULL);

      msg_xs = XmStringCreateLtoR (msg_str, XmFONTLIST_DEFAULT_TAG);
      XtVaSetValues (diag,
         XmNmessageAlignment, XmALIGNMENT_CENTER,
         XmNmessageString, msg_xs,
         NULL);
      XmStringFree(msg_xs);

      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (diag, XmDIALOG_HELP_BUTTON));
      }
   XtManageChild (diag);
}


/*
 * Ok Callback for promptDiag
 * cdata is the last char to transmit
 */
 void OkCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   char lastChar = (char) cdata;
   XmSelectionBoxCallbackStruct *pt = (XmSelectionBoxCallbackStruct *) cbs;
   char *inputString, *freeMe;
   
   XmStringGetLtoR (pt->value, XmFONTLIST_DEFAULT_TAG, &inputString);
   freeMe = inputString;

   while (*inputString != '\0')
   {
      appendTXtext (*inputString, appRes.zero);
      inputString++; 
   }
   appendTXtext (lastChar, appRes.zero);
   XtAppAddWorkProc (XtWidgetToApplicationContext(w), procFileText,
      (XtPointer) NULL);
   XtFree (freeMe);
}


/*
 * promptDiag - used to enter text when sending a file
 */
void promptDiag (char *word, char lastChar)
{
   int i = 0;
   Arg args[5];
   Widget promptDiag;
   XmString msg_xs;
   XmString textField;

   /* Create the Prompt Dialog and remove Help and Cancel buttons */

   XtSetArg (args[i], XmNtitle, "TWPSK Prompt Dialog"); i++;
   /* We can only try this! Lesstif bug?*/
   XtSetArg (args[i], XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL); i++;

   promptDiag = XmCreatePromptDialog (pskwids.getShell(), "promptDiag",
       args, i);

   XtUnmanageChild (XmSelectionBoxGetChild (promptDiag,
      XmDIALOG_HELP_BUTTON));
   XtUnmanageChild (XmSelectionBoxGetChild (promptDiag,
      XmDIALOG_CANCEL_BUTTON));
   XtAddCallback (promptDiag, XmNokCallback, OkCB, (XtPointer) lastChar);

   msg_xs = XmStringCreateLocalized (word);
   textField = XmStringCreateLocalized ("");

   XtVaSetValues (promptDiag,
      XmNmessageAlignment, XmALIGNMENT_CENTER,
      XmNtextString, textField,
      XmNselectionLabelString, msg_xs,
      NULL); 

   XmStringFree (msg_xs);
   XmStringFree (textField);
   XtManageChild (promptDiag);
}
 

/*
 * procFileText - Sends the contents of a file
 * If the file contains a '~', stop the work
 * proc and popup a prompt dialog for text.
 */
Boolean procFileText (XtPointer data)
{
   static char *start, *ptr, *begin;
   static Boolean first = True;
   static int ToDo = TEXT;
   char lastChar;
   int i = 0;

   if (first == True)
   {
      start = (char *) data;            /* starting point within text */
      begin = (char *) data;            /* keep this to free later */
      first = False;
   }

   switch (ToDo)
   {
      case TEXT:                        /* send file text and check for ~ */
         while (start[i] != '\0')
         {
            /* if char is a '~' and previous char was a ' ', '\0' or '\n'  */
            /* then ask for text.  '\0' happens when there is a ~WORD at   */
            /* the end of a line, and the next line starts with a ~WORD    */

            if (start[i] == '~' &&
                (start[i-1] == ' ' || start[i-1] == '\0' || start[i-1] == '\n'))
            {
               i++;
               start = start + i;
               ToDo = INSERT;           /* make us go to the other case next */
               return (False);          /* reschedule the work proc */
            }
            else
            {
               appendTXtext (*start, appRes.zero);    /*send the char */
               start++; 
               continue;
            }
         }
         first = True;
         XtFree (begin);                /* Free space used by file */
         return (True);                 /* All done so don't resked work proc */

      case INSERT:                      /* Inserts text for *word */
         ptr = start;

         while ( *start != ' ' && *start != '\n')
            start++;

         lastChar = *start;             /* save the terminating char */
         *start = '\0';                 /* "~word " is now "word\0" */
         promptDiag (ptr, lastChar);    /* popup the prompt dialog */
         start++;
         ToDo = TEXT;
         return (True);                 /* Don't reschedule the work proc, */
                                        /* The diag will reschedule it */

      default:
         printf ("We never get here :-) \n");
   }
   return (False);                      /* We never get here either */
} 


/*
 * helpCB - help dialog callback
 * helpfile is keep in /usr/share/psk31
 */
void helpCB (Widget w, XtPointer wid, XtPointer call_data)
{
Widget shell = (Widget)wid;
static Widget helpDiag=NULL;
static Widget helpTxt = NULL;
char *filepath = "/usr/share/psk31/twpskHelp";
char *textpt;
char *mess = "TWPSK HELP";
XmString mess_xs;


   if (helpDiag == NULL)
   {
      textpt = getFile (filepath);              /* Read the help file */


      helpDiag = XmCreateInformationDialog(shell, "helpDiag", NULL, 0);

      XtVaSetValues (XtParent (helpDiag),
         XmNtitle, mess,
         NULL);

      mess_xs = XmStringCreateLtoR (mess, XmFONTLIST_DEFAULT_TAG);

      XtVaSetValues (helpDiag,
         XmNmessageAlignment, XmALIGNMENT_CENTER,
         XmNmessageString, mess_xs,
         XmNdialogStyle, XmDIALOG_MODELESS,
         NULL);

      XmStringFree (mess_xs);

      XtUnmanageChild (XmMessageBoxGetChild (helpDiag, XmDIALOG_CANCEL_BUTTON));
      XtUnmanageChild (XmMessageBoxGetChild (helpDiag, XmDIALOG_HELP_BUTTON));

      helpTxt = XmCreateScrolledText (helpDiag, "helpTxt", NULL, 0);
      XtVaSetValues (helpTxt,
         XmNcolumns, 80,
         XmNmargin, 10,
         XmNrows, 20,
         XmNvalue, textpt,
         XmNeditMode, XmMULTI_LINE_EDIT,
         XmNeditable, False,
         XmNresizeWidth, True,
         XmNautoShowCursorPosition, False,
         XmNcursorPositionVisible, False,
         NULL);
      XtManageChild (helpTxt);
      free (textpt);
   }
   XtManageChild (helpDiag);
}


/*
 * getFile Function
 * Passed a pathname, this malloc's space for the file
 * reads the file, and returns a pointer to the file contents.
 * The pointer must be freed!
 */
char *getFile (char *filename)
{
   FILE *fp;
   struct stat info;
   char *pt;
   if (stat (filename, &info) != 0)
   {
       perror ("File Stat");
       exit (1);
   }

   if ((pt = (char *)XtMalloc ((int)info.st_size + 1)) == NULL)
   {
       perror ("twpskDiags getFile - Xtmalloc error");
       exit (1);
   }

   if ((fp = fopen (filename, "r")) == NULL)   
   {
       perror ("twpskDiags getFile - File Open error");
       exit (1);
   }

   if (fread (pt, 1, info.st_size, fp) != (unsigned int)(info.st_size))
   {
       perror ("twpskDiags getFile - Read error");
       exit (1);
   }  
   pt[info.st_size] = '\0';
   return (pt);
} 
