/* twpsk  - A gui application for PSK
 * Copyright (C) 1999 Ted Williams WA0EIR (ted_williams@HP.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 2.0 - Aug 2001
 */

#include "twpskScope.h"


#define LINE_WIDTH 3
/*
 * Initialize drawing stuff for scope 
 */

void Scope::setup (Widget shell, Widget scopeWid)
{
   Colormap dcmap;
   XColor nill;

   x = SCOPE_WIDTH/2;    /* initialize these to 64 so first time wont't draw */
   y = SCOPE_WIDTH/2;    /* a line from 0,0 to center. */
   scopeDA = scopeWid;

   gc = XCreateGC(XtDisplay(shell),
                  RootWindowOfScreen (XtScreen(shell)),
                  GCForeground, &gcv);

   display = XtDisplay (scopeDA);
   window  = XtWindow (scopeDA);
   screen  = DefaultScreen (display);
   dcmap   = DefaultColormap (display, screen);

   XAllocNamedColor (display, dcmap, "red", &color[0], &nill);
   XAllocNamedColor (display, dcmap, "yellow", &color[1], &nill);
   XAllocNamedColor (display, dcmap, "green2", &color[2], &nill);
   XAllocNamedColor (display, dcmap, "light gray", &color[3], &nill); /*Outer*/
   XAllocNamedColor (display, dcmap, "slate gray", &color[4], &nill); /*Inner*/
}


/*
 * drawline - draws the phase lines in the scope
 */
void Scope::drawline (int phdelta, int strength, int icolor)
{
   Position cx = SCOPE_WIDTH/2, cy = SCOPE_WIDTH/2;
   float theta;
   float dx,dy;

   /* fudge factor - converts 0->256 thingies to radians */
   float fudge =  2.0 * M_PI / 256.0; 
   theta = phdelta * fudge;

   XSetForeground (display, gc, color[4].pixel);  /* fg color to color[4] to */
   XDrawLine (display, window, gc,                /* undraw the last line */
      cx, cy,                                     /* Start of last line */
      x, y);                                      /* End of the last line */

   XSetForeground (display, gc, color[icolor].pixel);    

   dx = (float)strength * cos(theta+M_PI_2) * SCOPE_WIDTH/128;
   dy = (float)strength * sin(theta+M_PI_2) * SCOPE_WIDTH/128;

   x = (int) ((float)cx + dx);
   y = (int) ((float)cy - dy);
   XDrawLine (display, window, gc,
      cx, cy,                                     /* Start of new line */
      x, y);                                      /* End of new line */
   XSetForeground (display, gc, color[3].pixel);
}


/*
 * drawcirc - redraws the circle 
 */
void Scope::drawcirc()
{
   /* Draw outer circle */
   XSetForeground (display, gc, color[3].pixel); /* fg = white */
   XSetLineAttributes (display, gc, OUTER_CIRCLE_WIDTH,
                       LineSolid, CapRound, JoinRound);      
   XDrawArc (display, window, gc,
      BORDER_WIDTH, BORDER_WIDTH,       /* upper left corner */
      SCOPE_WIDTH - 2 * BORDER_WIDTH,
      SCOPE_WIDTH - 2 * BORDER_WIDTH,   /* axis lengths */
      0, 23040);                        /* start/stop points */

   /* Change the gc for inner circle */
   gcv.foreground = color[4].pixel;
   XChangeGC (display, gc, GCForeground, &gcv);
   XSetLineAttributes (display, gc, LINE_WIDTH,
                       LineSolid, CapRound, JoinRound);      

   /* Draw filled inner circle */ 
   XFillArc (display, window, gc,
      BORDER_WIDTH, BORDER_WIDTH,      /* upper left corner */
      SCOPE_WIDTH - 2 * BORDER_WIDTH,
      SCOPE_WIDTH - 2 * BORDER_WIDTH,  /* axis lengths */
      0, 23040);                       /* start/stop points */
}
